/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.servicecatalog.api.model.ServiceInstanceCondition;
import io.fabric8.servicecatalog.api.model.ServiceInstanceConditionBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceInstancePropertiesState;
import io.fabric8.servicecatalog.api.model.ServiceInstancePropertiesStateBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstancePropertiesStateFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceInstanceStatus;
import io.fabric8.servicecatalog.api.model.ServiceInstanceStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceInstanceStatusFluentImpl<A extends ServiceInstanceStatusFluent<A>>
extends BaseFluent<A>
implements ServiceInstanceStatusFluent<A> {
    private Boolean asyncOpInProgress;
    private ArrayList<ServiceInstanceConditionBuilder> conditions = new ArrayList();
    private String currentOperation;
    private String dashboardURL;
    private Map<String, Object> defaultProvisionParameters;
    private String deprovisionStatus;
    private ServiceInstancePropertiesStateBuilder externalProperties;
    private ServiceInstancePropertiesStateBuilder inProgressProperties;
    private String lastOperation;
    private Long observedGeneration;
    private String operationStartTime;
    private Boolean orphanMitigationInProgress;
    private String provisionStatus;
    private Long reconciledGeneration;

    public ServiceInstanceStatusFluentImpl() {
    }

    public ServiceInstanceStatusFluentImpl(ServiceInstanceStatus instance) {
        if (instance != null) {
            this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
            this.withConditions(instance.getConditions());
            this.withCurrentOperation(instance.getCurrentOperation());
            this.withDashboardURL(instance.getDashboardURL());
            this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
            this.withDeprovisionStatus(instance.getDeprovisionStatus());
            this.withExternalProperties(instance.getExternalProperties());
            this.withInProgressProperties(instance.getInProgressProperties());
            this.withLastOperation(instance.getLastOperation());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withOperationStartTime(instance.getOperationStartTime());
            this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
            this.withProvisionStatus(instance.getProvisionStatus());
            this.withReconciledGeneration(instance.getReconciledGeneration());
        }
    }

    @Override
    public Boolean getAsyncOpInProgress() {
        return this.asyncOpInProgress;
    }

    @Override
    public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
        this.asyncOpInProgress = asyncOpInProgress;
        return (A)this;
    }

    @Override
    public Boolean hasAsyncOpInProgress() {
        return this.asyncOpInProgress != null;
    }

    @Override
    public A addToConditions(int index, ServiceInstanceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, ServiceInstanceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(ServiceInstanceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<ServiceInstanceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ServiceInstanceCondition ... items) {
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<ServiceInstanceCondition> items) {
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ServiceInstanceConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ServiceInstanceConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ServiceInstanceConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceInstanceCondition> getConditions() {
        return this.conditions != null ? ServiceInstanceStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<ServiceInstanceCondition> buildConditions() {
        return this.conditions != null ? ServiceInstanceStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public ServiceInstanceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public ServiceInstanceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public ServiceInstanceCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public ServiceInstanceCondition buildMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
        for (ServiceInstanceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
        for (ServiceInstanceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<ServiceInstanceCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ServiceInstanceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(ServiceInstanceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ServiceInstanceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ServiceInstanceCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public ServiceInstanceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ServiceInstanceStatusFluent.ConditionsNested<A> addNewConditionLike(ServiceInstanceCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ServiceInstanceStatusFluent.ConditionsNested<A> setNewConditionLike(int index, ServiceInstanceCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ServiceInstanceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ServiceInstanceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ServiceInstanceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ServiceInstanceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getCurrentOperation() {
        return this.currentOperation;
    }

    @Override
    public A withCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentOperation() {
        return this.currentOperation != null;
    }

    @Override
    public String getDashboardURL() {
        return this.dashboardURL;
    }

    @Override
    public A withDashboardURL(String dashboardURL) {
        this.dashboardURL = dashboardURL;
        return (A)this;
    }

    @Override
    public Boolean hasDashboardURL() {
        return this.dashboardURL != null;
    }

    @Override
    public A addToDefaultProvisionParameters(String key, Object value) {
        if (this.defaultProvisionParameters == null && key != null && value != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.defaultProvisionParameters.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null && map != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.defaultProvisionParameters.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultProvisionParameters(String key) {
        if (this.defaultProvisionParameters == null) {
            return (A)this;
        }
        if (key != null && this.defaultProvisionParameters != null) {
            this.defaultProvisionParameters.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.defaultProvisionParameters == null) continue;
                this.defaultProvisionParameters.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getDefaultProvisionParameters() {
        return this.defaultProvisionParameters;
    }

    @Override
    public <K, V> A withDefaultProvisionParameters(Map<String, Object> defaultProvisionParameters) {
        this.defaultProvisionParameters = defaultProvisionParameters == null ? null : new LinkedHashMap<String, Object>(defaultProvisionParameters);
        return (A)this;
    }

    @Override
    public Boolean hasDefaultProvisionParameters() {
        return this.defaultProvisionParameters != null;
    }

    @Override
    public String getDeprovisionStatus() {
        return this.deprovisionStatus;
    }

    @Override
    public A withDeprovisionStatus(String deprovisionStatus) {
        this.deprovisionStatus = deprovisionStatus;
        return (A)this;
    }

    @Override
    public Boolean hasDeprovisionStatus() {
        return this.deprovisionStatus != null;
    }

    @Override
    @Deprecated
    public ServiceInstancePropertiesState getExternalProperties() {
        return this.externalProperties != null ? this.externalProperties.build() : null;
    }

    @Override
    public ServiceInstancePropertiesState buildExternalProperties() {
        return this.externalProperties != null ? this.externalProperties.build() : null;
    }

    @Override
    public A withExternalProperties(ServiceInstancePropertiesState externalProperties) {
        this._visitables.get((Object)"externalProperties").remove(this.externalProperties);
        if (externalProperties != null) {
            this.externalProperties = new ServiceInstancePropertiesStateBuilder(externalProperties);
            this._visitables.get((Object)"externalProperties").add(this.externalProperties);
        } else {
            this.externalProperties = null;
            this._visitables.get((Object)"externalProperties").remove(this.externalProperties);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalProperties() {
        return this.externalProperties != null;
    }

    @Override
    public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> withNewExternalProperties() {
        return new ExternalPropertiesNestedImpl();
    }

    @Override
    public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
        return new ExternalPropertiesNestedImpl(item);
    }

    @Override
    public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editExternalProperties() {
        return this.withNewExternalPropertiesLike(this.getExternalProperties());
    }

    @Override
    public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editOrNewExternalProperties() {
        return this.withNewExternalPropertiesLike(this.getExternalProperties() != null ? this.getExternalProperties() : new ServiceInstancePropertiesStateBuilder().build());
    }

    @Override
    public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
        return this.withNewExternalPropertiesLike(this.getExternalProperties() != null ? this.getExternalProperties() : item);
    }

    @Override
    @Deprecated
    public ServiceInstancePropertiesState getInProgressProperties() {
        return this.inProgressProperties != null ? this.inProgressProperties.build() : null;
    }

    @Override
    public ServiceInstancePropertiesState buildInProgressProperties() {
        return this.inProgressProperties != null ? this.inProgressProperties.build() : null;
    }

    @Override
    public A withInProgressProperties(ServiceInstancePropertiesState inProgressProperties) {
        this._visitables.get((Object)"inProgressProperties").remove(this.inProgressProperties);
        if (inProgressProperties != null) {
            this.inProgressProperties = new ServiceInstancePropertiesStateBuilder(inProgressProperties);
            this._visitables.get((Object)"inProgressProperties").add(this.inProgressProperties);
        } else {
            this.inProgressProperties = null;
            this._visitables.get((Object)"inProgressProperties").remove(this.inProgressProperties);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInProgressProperties() {
        return this.inProgressProperties != null;
    }

    @Override
    public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> withNewInProgressProperties() {
        return new InProgressPropertiesNestedImpl();
    }

    @Override
    public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
        return new InProgressPropertiesNestedImpl(item);
    }

    @Override
    public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editInProgressProperties() {
        return this.withNewInProgressPropertiesLike(this.getInProgressProperties());
    }

    @Override
    public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressProperties() {
        return this.withNewInProgressPropertiesLike(this.getInProgressProperties() != null ? this.getInProgressProperties() : new ServiceInstancePropertiesStateBuilder().build());
    }

    @Override
    public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
        return this.withNewInProgressPropertiesLike(this.getInProgressProperties() != null ? this.getInProgressProperties() : item);
    }

    @Override
    public String getLastOperation() {
        return this.lastOperation;
    }

    @Override
    public A withLastOperation(String lastOperation) {
        this.lastOperation = lastOperation;
        return (A)this;
    }

    @Override
    public Boolean hasLastOperation() {
        return this.lastOperation != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public String getOperationStartTime() {
        return this.operationStartTime;
    }

    @Override
    public A withOperationStartTime(String operationStartTime) {
        this.operationStartTime = operationStartTime;
        return (A)this;
    }

    @Override
    public Boolean hasOperationStartTime() {
        return this.operationStartTime != null;
    }

    @Override
    public Boolean getOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress;
    }

    @Override
    public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
        this.orphanMitigationInProgress = orphanMitigationInProgress;
        return (A)this;
    }

    @Override
    public Boolean hasOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress != null;
    }

    @Override
    public String getProvisionStatus() {
        return this.provisionStatus;
    }

    @Override
    public A withProvisionStatus(String provisionStatus) {
        this.provisionStatus = provisionStatus;
        return (A)this;
    }

    @Override
    public Boolean hasProvisionStatus() {
        return this.provisionStatus != null;
    }

    @Override
    public Long getReconciledGeneration() {
        return this.reconciledGeneration;
    }

    @Override
    public A withReconciledGeneration(Long reconciledGeneration) {
        this.reconciledGeneration = reconciledGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasReconciledGeneration() {
        return this.reconciledGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstanceStatusFluentImpl that = (ServiceInstanceStatusFluentImpl)o;
        if (!Objects.equals(this.asyncOpInProgress, that.asyncOpInProgress)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentOperation, that.currentOperation)) {
            return false;
        }
        if (!Objects.equals(this.dashboardURL, that.dashboardURL)) {
            return false;
        }
        if (!Objects.equals(this.defaultProvisionParameters, that.defaultProvisionParameters)) {
            return false;
        }
        if (!Objects.equals(this.deprovisionStatus, that.deprovisionStatus)) {
            return false;
        }
        if (!Objects.equals(this.externalProperties, that.externalProperties)) {
            return false;
        }
        if (!Objects.equals(this.inProgressProperties, that.inProgressProperties)) {
            return false;
        }
        if (!Objects.equals(this.lastOperation, that.lastOperation)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.operationStartTime, that.operationStartTime)) {
            return false;
        }
        if (!Objects.equals(this.orphanMitigationInProgress, that.orphanMitigationInProgress)) {
            return false;
        }
        if (!Objects.equals(this.provisionStatus, that.provisionStatus)) {
            return false;
        }
        return Objects.equals(this.reconciledGeneration, that.reconciledGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.asyncOpInProgress, this.conditions, this.currentOperation, this.dashboardURL, this.defaultProvisionParameters, this.deprovisionStatus, this.externalProperties, this.inProgressProperties, this.lastOperation, this.observedGeneration, this.operationStartTime, this.orphanMitigationInProgress, this.provisionStatus, this.reconciledGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.asyncOpInProgress != null) {
            sb.append("asyncOpInProgress:");
            sb.append(this.asyncOpInProgress + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentOperation != null) {
            sb.append("currentOperation:");
            sb.append(this.currentOperation + ",");
        }
        if (this.dashboardURL != null) {
            sb.append("dashboardURL:");
            sb.append(this.dashboardURL + ",");
        }
        if (this.defaultProvisionParameters != null && !this.defaultProvisionParameters.isEmpty()) {
            sb.append("defaultProvisionParameters:");
            sb.append(this.defaultProvisionParameters + ",");
        }
        if (this.deprovisionStatus != null) {
            sb.append("deprovisionStatus:");
            sb.append(this.deprovisionStatus + ",");
        }
        if (this.externalProperties != null) {
            sb.append("externalProperties:");
            sb.append(this.externalProperties + ",");
        }
        if (this.inProgressProperties != null) {
            sb.append("inProgressProperties:");
            sb.append(this.inProgressProperties + ",");
        }
        if (this.lastOperation != null) {
            sb.append("lastOperation:");
            sb.append(this.lastOperation + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.operationStartTime != null) {
            sb.append("operationStartTime:");
            sb.append(this.operationStartTime + ",");
        }
        if (this.orphanMitigationInProgress != null) {
            sb.append("orphanMitigationInProgress:");
            sb.append(this.orphanMitigationInProgress + ",");
        }
        if (this.provisionStatus != null) {
            sb.append("provisionStatus:");
            sb.append(this.provisionStatus + ",");
        }
        if (this.reconciledGeneration != null) {
            sb.append("reconciledGeneration:");
            sb.append(this.reconciledGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAsyncOpInProgress() {
        return this.withAsyncOpInProgress(true);
    }

    @Override
    public A withOrphanMitigationInProgress() {
        return this.withOrphanMitigationInProgress(true);
    }

    class InProgressPropertiesNestedImpl<N>
    extends ServiceInstancePropertiesStateFluentImpl<ServiceInstanceStatusFluent.InProgressPropertiesNested<N>>
    implements ServiceInstanceStatusFluent.InProgressPropertiesNested<N>,
    Nested<N> {
        ServiceInstancePropertiesStateBuilder builder;

        InProgressPropertiesNestedImpl(ServiceInstancePropertiesState item) {
            this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
        }

        InProgressPropertiesNestedImpl() {
            this.builder = new ServiceInstancePropertiesStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceInstanceStatusFluentImpl.this.withInProgressProperties(this.builder.build());
        }

        @Override
        public N endInProgressProperties() {
            return this.and();
        }
    }

    class ExternalPropertiesNestedImpl<N>
    extends ServiceInstancePropertiesStateFluentImpl<ServiceInstanceStatusFluent.ExternalPropertiesNested<N>>
    implements ServiceInstanceStatusFluent.ExternalPropertiesNested<N>,
    Nested<N> {
        ServiceInstancePropertiesStateBuilder builder;

        ExternalPropertiesNestedImpl(ServiceInstancePropertiesState item) {
            this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
        }

        ExternalPropertiesNestedImpl() {
            this.builder = new ServiceInstancePropertiesStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceInstanceStatusFluentImpl.this.withExternalProperties(this.builder.build());
        }

        @Override
        public N endExternalProperties() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends ServiceInstanceConditionFluentImpl<ServiceInstanceStatusFluent.ConditionsNested<N>>
    implements ServiceInstanceStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ServiceInstanceConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, ServiceInstanceCondition item) {
            this.index = index;
            this.builder = new ServiceInstanceConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceInstanceConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceInstanceStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

