package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceBrokerStatusBuilder extends ClusterServiceBrokerStatusFluent<ClusterServiceBrokerStatusBuilder> implements VisitableBuilder<ClusterServiceBrokerStatus,ClusterServiceBrokerStatusBuilder>{
  public ClusterServiceBrokerStatusBuilder() {
    this(false);
  }
  public ClusterServiceBrokerStatusBuilder(Boolean validationEnabled) {
    this(new ClusterServiceBrokerStatus(), validationEnabled);
  }
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceBrokerStatus(), validationEnabled);
  }
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatusFluent<?> fluent,ClusterServiceBrokerStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatusFluent<?> fluent,ClusterServiceBrokerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterServiceBrokerStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
      fluent.withOperationStartTime(instance.getOperationStartTime());
      fluent.withReconciledGeneration(instance.getReconciledGeneration());
      fluent.withConditions(instance.getConditions());
      fluent.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
      fluent.withOperationStartTime(instance.getOperationStartTime());
      fluent.withReconciledGeneration(instance.getReconciledGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatus instance) {
    this(instance,false);
  }
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterServiceBrokerStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
      this.withOperationStartTime(instance.getOperationStartTime());
      this.withReconciledGeneration(instance.getReconciledGeneration());
      this.withConditions(instance.getConditions());
      this.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
      this.withOperationStartTime(instance.getOperationStartTime());
      this.withReconciledGeneration(instance.getReconciledGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceBrokerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceBrokerStatus build() {
    ClusterServiceBrokerStatus buildable = new ClusterServiceBrokerStatus(fluent.buildConditions(),fluent.getLastCatalogRetrievalTime(),fluent.getOperationStartTime(),fluent.getReconciledGeneration());
    return buildable;
  }
  
}