package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceClassSpecFluent<A extends ServiceClassSpecFluent<A>> extends BaseFluent<A>{
  public ServiceClassSpecFluent() {
  }
  public ServiceClassSpecFluent(ServiceClassSpec instance) {
    instance = (instance != null ? instance : new ServiceClassSpec());

    if (instance != null) {
      this.withBindable(instance.getBindable());
      this.withBindingRetrievable(instance.getBindingRetrievable());
      this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
      this.withDescription(instance.getDescription());
      this.withExternalID(instance.getExternalID());
      this.withExternalMetadata(instance.getExternalMetadata());
      this.withExternalName(instance.getExternalName());
      this.withPlanUpdatable(instance.getPlanUpdatable());
      this.withRequires(instance.getRequires());
      this.withServiceBrokerName(instance.getServiceBrokerName());
      this.withTags(instance.getTags());
      this.withBindable(instance.getBindable());
      this.withBindingRetrievable(instance.getBindingRetrievable());
      this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
      this.withDescription(instance.getDescription());
      this.withExternalID(instance.getExternalID());
      this.withExternalMetadata(instance.getExternalMetadata());
      this.withExternalName(instance.getExternalName());
      this.withPlanUpdatable(instance.getPlanUpdatable());
      this.withRequires(instance.getRequires());
      this.withServiceBrokerName(instance.getServiceBrokerName());
      this.withTags(instance.getTags());
    }
  }
  private Boolean bindable;
  private Boolean bindingRetrievable;
  private Map<String,Object> defaultProvisionParameters;
  private String description;
  private String externalID;
  private Map<String,Object> externalMetadata;
  private String externalName;
  private Boolean planUpdatable;
  private List<String> requires = new ArrayList<String>();
  private String serviceBrokerName;
  private List<String> tags = new ArrayList<String>();
  public Boolean getBindable() {
    return this.bindable;
  }
  public A withBindable(Boolean bindable) {
    this.bindable=bindable; return (A) this;
  }
  public boolean hasBindable() {
    return this.bindable != null;
  }
  public Boolean getBindingRetrievable() {
    return this.bindingRetrievable;
  }
  public A withBindingRetrievable(Boolean bindingRetrievable) {
    this.bindingRetrievable=bindingRetrievable; return (A) this;
  }
  public boolean hasBindingRetrievable() {
    return this.bindingRetrievable != null;
  }
  public A addToDefaultProvisionParameters(String key,Object value) {
    if(this.defaultProvisionParameters == null && key != null && value != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.defaultProvisionParameters.put(key, value);} return (A)this;
  }
  public A addToDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null && map != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(map != null) { this.defaultProvisionParameters.putAll(map);} return (A)this;
  }
  public A removeFromDefaultProvisionParameters(String key) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(key != null && this.defaultProvisionParameters != null) {this.defaultProvisionParameters.remove(key);} return (A)this;
  }
  public A removeFromDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.defaultProvisionParameters != null){this.defaultProvisionParameters.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getDefaultProvisionParameters() {
    return this.defaultProvisionParameters;
  }
  public <K,V>A withDefaultProvisionParameters(Map<String,Object> defaultProvisionParameters) {
    if (defaultProvisionParameters == null) { this.defaultProvisionParameters =  null;} else {this.defaultProvisionParameters = new LinkedHashMap(defaultProvisionParameters);} return (A) this;
  }
  public boolean hasDefaultProvisionParameters() {
    return this.defaultProvisionParameters != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public boolean hasDescription() {
    return this.description != null;
  }
  public String getExternalID() {
    return this.externalID;
  }
  public A withExternalID(String externalID) {
    this.externalID=externalID; return (A) this;
  }
  public boolean hasExternalID() {
    return this.externalID != null;
  }
  public A addToExternalMetadata(String key,Object value) {
    if(this.externalMetadata == null && key != null && value != null) { this.externalMetadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.externalMetadata.put(key, value);} return (A)this;
  }
  public A addToExternalMetadata(Map<String,Object> map) {
    if(this.externalMetadata == null && map != null) { this.externalMetadata = new LinkedHashMap(); }
    if(map != null) { this.externalMetadata.putAll(map);} return (A)this;
  }
  public A removeFromExternalMetadata(String key) {
    if(this.externalMetadata == null) { return (A) this; }
    if(key != null && this.externalMetadata != null) {this.externalMetadata.remove(key);} return (A)this;
  }
  public A removeFromExternalMetadata(Map<String,Object> map) {
    if(this.externalMetadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.externalMetadata != null){this.externalMetadata.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getExternalMetadata() {
    return this.externalMetadata;
  }
  public <K,V>A withExternalMetadata(Map<String,Object> externalMetadata) {
    if (externalMetadata == null) { this.externalMetadata =  null;} else {this.externalMetadata = new LinkedHashMap(externalMetadata);} return (A) this;
  }
  public boolean hasExternalMetadata() {
    return this.externalMetadata != null;
  }
  public String getExternalName() {
    return this.externalName;
  }
  public A withExternalName(String externalName) {
    this.externalName=externalName; return (A) this;
  }
  public boolean hasExternalName() {
    return this.externalName != null;
  }
  public Boolean getPlanUpdatable() {
    return this.planUpdatable;
  }
  public A withPlanUpdatable(Boolean planUpdatable) {
    this.planUpdatable=planUpdatable; return (A) this;
  }
  public boolean hasPlanUpdatable() {
    return this.planUpdatable != null;
  }
  public A addToRequires(int index,String item) {
    if (this.requires == null) {this.requires = new ArrayList<String>();}
    this.requires.add(index, item);
    return (A)this;
  }
  public A setToRequires(int index,String item) {
    if (this.requires == null) {this.requires = new ArrayList<String>();}
    this.requires.set(index, item); return (A)this;
  }
  public A addToRequires(java.lang.String... items) {
    if (this.requires == null) {this.requires = new ArrayList<String>();}
    for (String item : items) {this.requires.add(item);} return (A)this;
  }
  public A addAllToRequires(Collection<String> items) {
    if (this.requires == null) {this.requires = new ArrayList<String>();}
    for (String item : items) {this.requires.add(item);} return (A)this;
  }
  public A removeFromRequires(java.lang.String... items) {
    if (this.requires == null) return (A)this;
    for (String item : items) { this.requires.remove(item);} return (A)this;
  }
  public A removeAllFromRequires(Collection<String> items) {
    if (this.requires == null) return (A)this;
    for (String item : items) { this.requires.remove(item);} return (A)this;
  }
  public List<String> getRequires() {
    return this.requires;
  }
  public String getRequire(int index) {
    return this.requires.get(index);
  }
  public String getFirstRequire() {
    return this.requires.get(0);
  }
  public String getLastRequire() {
    return this.requires.get(requires.size() - 1);
  }
  public String getMatchingRequire(Predicate<String> predicate) {
    for (String item: requires) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingRequire(Predicate<String> predicate) {
    for (String item: requires) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequires(List<String> requires) {
    if (requires != null) {this.requires = new ArrayList(); for (String item : requires){this.addToRequires(item);}} else { this.requires = null;} return (A) this;
  }
  public A withRequires(java.lang.String... requires) {
    if (this.requires != null) {this.requires.clear(); _visitables.remove("requires"); }
    if (requires != null) {for (String item :requires){ this.addToRequires(item);}} return (A) this;
  }
  public boolean hasRequires() {
    return requires != null && !requires.isEmpty();
  }
  public String getServiceBrokerName() {
    return this.serviceBrokerName;
  }
  public A withServiceBrokerName(String serviceBrokerName) {
    this.serviceBrokerName=serviceBrokerName; return (A) this;
  }
  public boolean hasServiceBrokerName() {
    return this.serviceBrokerName != null;
  }
  public A addToTags(int index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.add(index, item);
    return (A)this;
  }
  public A setToTags(int index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.set(index, item); return (A)this;
  }
  public A addToTags(java.lang.String... items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  public A addAllToTags(Collection<String> items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  public A removeFromTags(java.lang.String... items) {
    if (this.tags == null) return (A)this;
    for (String item : items) { this.tags.remove(item);} return (A)this;
  }
  public A removeAllFromTags(Collection<String> items) {
    if (this.tags == null) return (A)this;
    for (String item : items) { this.tags.remove(item);} return (A)this;
  }
  public List<String> getTags() {
    return this.tags;
  }
  public String getTag(int index) {
    return this.tags.get(index);
  }
  public String getFirstTag() {
    return this.tags.get(0);
  }
  public String getLastTag() {
    return this.tags.get(tags.size() - 1);
  }
  public String getMatchingTag(Predicate<String> predicate) {
    for (String item: tags) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingTag(Predicate<String> predicate) {
    for (String item: tags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTags(List<String> tags) {
    if (tags != null) {this.tags = new ArrayList(); for (String item : tags){this.addToTags(item);}} else { this.tags = null;} return (A) this;
  }
  public A withTags(java.lang.String... tags) {
    if (this.tags != null) {this.tags.clear(); _visitables.remove("tags"); }
    if (tags != null) {for (String item :tags){ this.addToTags(item);}} return (A) this;
  }
  public boolean hasTags() {
    return tags != null && !tags.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceClassSpecFluent that = (ServiceClassSpecFluent) o;
    if (!java.util.Objects.equals(bindable, that.bindable)) return false;

    if (!java.util.Objects.equals(bindingRetrievable, that.bindingRetrievable)) return false;

    if (!java.util.Objects.equals(defaultProvisionParameters, that.defaultProvisionParameters)) return false;

    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(externalID, that.externalID)) return false;

    if (!java.util.Objects.equals(externalMetadata, that.externalMetadata)) return false;

    if (!java.util.Objects.equals(externalName, that.externalName)) return false;

    if (!java.util.Objects.equals(planUpdatable, that.planUpdatable)) return false;

    if (!java.util.Objects.equals(requires, that.requires)) return false;

    if (!java.util.Objects.equals(serviceBrokerName, that.serviceBrokerName)) return false;

    if (!java.util.Objects.equals(tags, that.tags)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bindable,  bindingRetrievable,  defaultProvisionParameters,  description,  externalID,  externalMetadata,  externalName,  planUpdatable,  requires,  serviceBrokerName,  tags,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindable != null) { sb.append("bindable:"); sb.append(bindable + ","); }
    if (bindingRetrievable != null) { sb.append("bindingRetrievable:"); sb.append(bindingRetrievable + ","); }
    if (defaultProvisionParameters != null && !defaultProvisionParameters.isEmpty()) { sb.append("defaultProvisionParameters:"); sb.append(defaultProvisionParameters + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (externalID != null) { sb.append("externalID:"); sb.append(externalID + ","); }
    if (externalMetadata != null && !externalMetadata.isEmpty()) { sb.append("externalMetadata:"); sb.append(externalMetadata + ","); }
    if (externalName != null) { sb.append("externalName:"); sb.append(externalName + ","); }
    if (planUpdatable != null) { sb.append("planUpdatable:"); sb.append(planUpdatable + ","); }
    if (requires != null && !requires.isEmpty()) { sb.append("requires:"); sb.append(requires + ","); }
    if (serviceBrokerName != null) { sb.append("serviceBrokerName:"); sb.append(serviceBrokerName + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags); }
    sb.append("}");
    return sb.toString();
  }
  public A withBindable() {
    return withBindable(true);
  }
  public A withBindingRetrievable() {
    return withBindingRetrievable(true);
  }
  public A withPlanUpdatable() {
    return withPlanUpdatable(true);
  }
  
}