package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CatalogRestrictionsBuilder extends CatalogRestrictionsFluent<CatalogRestrictionsBuilder> implements VisitableBuilder<CatalogRestrictions,CatalogRestrictionsBuilder>{
  public CatalogRestrictionsBuilder() {
    this(false);
  }
  public CatalogRestrictionsBuilder(Boolean validationEnabled) {
    this(new CatalogRestrictions(), validationEnabled);
  }
  public CatalogRestrictionsBuilder(CatalogRestrictionsFluent<?> fluent) {
    this(fluent, false);
  }
  public CatalogRestrictionsBuilder(CatalogRestrictionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CatalogRestrictions(), validationEnabled);
  }
  public CatalogRestrictionsBuilder(CatalogRestrictionsFluent<?> fluent,CatalogRestrictions instance) {
    this(fluent, instance, false);
  }
  public CatalogRestrictionsBuilder(CatalogRestrictionsFluent<?> fluent,CatalogRestrictions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CatalogRestrictions());

    if (instance != null) {
      fluent.withServiceClass(instance.getServiceClass());
      fluent.withServicePlan(instance.getServicePlan());
      fluent.withServiceClass(instance.getServiceClass());
      fluent.withServicePlan(instance.getServicePlan());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CatalogRestrictionsBuilder(CatalogRestrictions instance) {
    this(instance,false);
  }
  public CatalogRestrictionsBuilder(CatalogRestrictions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CatalogRestrictions());

    if (instance != null) {
      this.withServiceClass(instance.getServiceClass());
      this.withServicePlan(instance.getServicePlan());
      this.withServiceClass(instance.getServiceClass());
      this.withServicePlan(instance.getServicePlan());
    }
    this.validationEnabled = validationEnabled; 
  }
  CatalogRestrictionsFluent<?> fluent;
  Boolean validationEnabled;
  public CatalogRestrictions build() {
    CatalogRestrictions buildable = new CatalogRestrictions(fluent.getServiceClass(),fluent.getServicePlan());
    return buildable;
  }
  
}