package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretTransformBuilder extends SecretTransformFluent<SecretTransformBuilder> implements VisitableBuilder<SecretTransform,SecretTransformBuilder>{
  public SecretTransformBuilder() {
    this(false);
  }
  public SecretTransformBuilder(Boolean validationEnabled) {
    this(new SecretTransform(), validationEnabled);
  }
  public SecretTransformBuilder(SecretTransformFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretTransformBuilder(SecretTransformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretTransform(), validationEnabled);
  }
  public SecretTransformBuilder(SecretTransformFluent<?> fluent,SecretTransform instance) {
    this(fluent, instance, false);
  }
  public SecretTransformBuilder(SecretTransformFluent<?> fluent,SecretTransform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecretTransform());

    if (instance != null) {
      fluent.withAddKey(instance.getAddKey());
      fluent.withAddKeysFrom(instance.getAddKeysFrom());
      fluent.withRemoveKey(instance.getRemoveKey());
      fluent.withRenameKey(instance.getRenameKey());
      fluent.withAddKey(instance.getAddKey());
      fluent.withAddKeysFrom(instance.getAddKeysFrom());
      fluent.withRemoveKey(instance.getRemoveKey());
      fluent.withRenameKey(instance.getRenameKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretTransformBuilder(SecretTransform instance) {
    this(instance,false);
  }
  public SecretTransformBuilder(SecretTransform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecretTransform());

    if (instance != null) {
      this.withAddKey(instance.getAddKey());
      this.withAddKeysFrom(instance.getAddKeysFrom());
      this.withRemoveKey(instance.getRemoveKey());
      this.withRenameKey(instance.getRenameKey());
      this.withAddKey(instance.getAddKey());
      this.withAddKeysFrom(instance.getAddKeysFrom());
      this.withRemoveKey(instance.getRemoveKey());
      this.withRenameKey(instance.getRenameKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretTransformFluent<?> fluent;
  Boolean validationEnabled;
  public SecretTransform build() {
    SecretTransform buildable = new SecretTransform(fluent.buildAddKey(),fluent.buildAddKeysFrom(),fluent.buildRemoveKey(),fluent.buildRenameKey());
    return buildable;
  }
  
}