package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBindingConditionBuilder extends ServiceBindingConditionFluent<ServiceBindingConditionBuilder> implements VisitableBuilder<ServiceBindingCondition,ServiceBindingConditionBuilder>{
  public ServiceBindingConditionBuilder() {
    this(false);
  }
  public ServiceBindingConditionBuilder(Boolean validationEnabled) {
    this(new ServiceBindingCondition(), validationEnabled);
  }
  public ServiceBindingConditionBuilder(ServiceBindingConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBindingConditionBuilder(ServiceBindingConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBindingCondition(), validationEnabled);
  }
  public ServiceBindingConditionBuilder(ServiceBindingConditionFluent<?> fluent,ServiceBindingCondition instance) {
    this(fluent, instance, false);
  }
  public ServiceBindingConditionBuilder(ServiceBindingConditionFluent<?> fluent,ServiceBindingCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceBindingCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBindingConditionBuilder(ServiceBindingCondition instance) {
    this(instance,false);
  }
  public ServiceBindingConditionBuilder(ServiceBindingCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceBindingCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBindingConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBindingCondition build() {
    ServiceBindingCondition buildable = new ServiceBindingCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}