package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBrokerAuthInfoBuilder extends ServiceBrokerAuthInfoFluent<ServiceBrokerAuthInfoBuilder> implements VisitableBuilder<ServiceBrokerAuthInfo,ServiceBrokerAuthInfoBuilder>{
  public ServiceBrokerAuthInfoBuilder() {
    this(false);
  }
  public ServiceBrokerAuthInfoBuilder(Boolean validationEnabled) {
    this(new ServiceBrokerAuthInfo(), validationEnabled);
  }
  public ServiceBrokerAuthInfoBuilder(ServiceBrokerAuthInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBrokerAuthInfoBuilder(ServiceBrokerAuthInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBrokerAuthInfo(), validationEnabled);
  }
  public ServiceBrokerAuthInfoBuilder(ServiceBrokerAuthInfoFluent<?> fluent,ServiceBrokerAuthInfo instance) {
    this(fluent, instance, false);
  }
  public ServiceBrokerAuthInfoBuilder(ServiceBrokerAuthInfoFluent<?> fluent,ServiceBrokerAuthInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceBrokerAuthInfo());

    if (instance != null) {
      fluent.withBasic(instance.getBasic());
      fluent.withBearer(instance.getBearer());
      fluent.withBasic(instance.getBasic());
      fluent.withBearer(instance.getBearer());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBrokerAuthInfoBuilder(ServiceBrokerAuthInfo instance) {
    this(instance,false);
  }
  public ServiceBrokerAuthInfoBuilder(ServiceBrokerAuthInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceBrokerAuthInfo());

    if (instance != null) {
      this.withBasic(instance.getBasic());
      this.withBearer(instance.getBearer());
      this.withBasic(instance.getBasic());
      this.withBearer(instance.getBearer());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBrokerAuthInfoFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBrokerAuthInfo build() {
    ServiceBrokerAuthInfo buildable = new ServiceBrokerAuthInfo(fluent.buildBasic(),fluent.buildBearer());
    return buildable;
  }
  
}