package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServicePlanBuilder extends ServicePlanFluent<ServicePlanBuilder> implements VisitableBuilder<ServicePlan,ServicePlanBuilder>{
  public ServicePlanBuilder() {
    this(false);
  }
  public ServicePlanBuilder(Boolean validationEnabled) {
    this(new ServicePlan(), validationEnabled);
  }
  public ServicePlanBuilder(ServicePlanFluent<?> fluent) {
    this(fluent, false);
  }
  public ServicePlanBuilder(ServicePlanFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServicePlan(), validationEnabled);
  }
  public ServicePlanBuilder(ServicePlanFluent<?> fluent,ServicePlan instance) {
    this(fluent, instance, false);
  }
  public ServicePlanBuilder(ServicePlanFluent<?> fluent,ServicePlan instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServicePlan());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServicePlanBuilder(ServicePlan instance) {
    this(instance,false);
  }
  public ServicePlanBuilder(ServicePlan instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServicePlan());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServicePlanFluent<?> fluent;
  Boolean validationEnabled;
  public ServicePlan build() {
    ServicePlan buildable = new ServicePlan(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}