package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceBindingStatusFluent<A extends ServiceBindingStatusFluent<A>> extends BaseFluent<A>{
  public ServiceBindingStatusFluent() {
  }
  
  public ServiceBindingStatusFluent(ServiceBindingStatus instance) {
    this.copyInstance(instance);
  }
  private Boolean asyncOpInProgress;
  private ArrayList<ServiceBindingConditionBuilder> conditions = new ArrayList<ServiceBindingConditionBuilder>();
  private String currentOperation;
  private ServiceBindingPropertiesStateBuilder externalProperties;
  private ServiceBindingPropertiesStateBuilder inProgressProperties;
  private String lastOperation;
  private String operationStartTime;
  private Boolean orphanMitigationInProgress;
  private Long reconciledGeneration;
  private String unbindStatus;
  
  protected void copyInstance(ServiceBindingStatus instance) {
    instance = (instance != null ? instance : new ServiceBindingStatus());
  
    if (instance != null) {
        this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
        this.withConditions(instance.getConditions());
        this.withCurrentOperation(instance.getCurrentOperation());
        this.withExternalProperties(instance.getExternalProperties());
        this.withInProgressProperties(instance.getInProgressProperties());
        this.withLastOperation(instance.getLastOperation());
        this.withOperationStartTime(instance.getOperationStartTime());
        this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
        this.withReconciledGeneration(instance.getReconciledGeneration());
        this.withUnbindStatus(instance.getUnbindStatus());
        this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
        this.withConditions(instance.getConditions());
        this.withCurrentOperation(instance.getCurrentOperation());
        this.withExternalProperties(instance.getExternalProperties());
        this.withInProgressProperties(instance.getInProgressProperties());
        this.withLastOperation(instance.getLastOperation());
        this.withOperationStartTime(instance.getOperationStartTime());
        this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
        this.withReconciledGeneration(instance.getReconciledGeneration());
        this.withUnbindStatus(instance.getUnbindStatus());
      }
  }
  
  public Boolean getAsyncOpInProgress() {
    return this.asyncOpInProgress;
  }
  
  public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
    this.asyncOpInProgress=asyncOpInProgress; return (A) this;
  }
  
  public boolean hasAsyncOpInProgress() {
    return this.asyncOpInProgress != null;
  }
  
  public A addToConditions(int index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<ServiceBindingCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... items) {
    if (this.conditions == null) return (A)this;
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<ServiceBindingCondition> items) {
    if (this.conditions == null) return (A)this;
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ServiceBindingConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceBindingConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceBindingConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ServiceBindingCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  
  public ServiceBindingCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public ServiceBindingCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public ServiceBindingCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public ServiceBindingCondition buildMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    for (ServiceBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    for (ServiceBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConditions(List<ServiceBindingCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ServiceBindingCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ServiceBindingCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ServiceBindingCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(ServiceBindingCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,ServiceBindingCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public String getCurrentOperation() {
    return this.currentOperation;
  }
  
  public A withCurrentOperation(String currentOperation) {
    this.currentOperation=currentOperation; return (A) this;
  }
  
  public boolean hasCurrentOperation() {
    return this.currentOperation != null;
  }
  
  public ServiceBindingPropertiesState buildExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  
  public A withExternalProperties(ServiceBindingPropertiesState externalProperties) {
    _visitables.get("externalProperties").remove(this.externalProperties);
    if (externalProperties!=null){ this.externalProperties= new ServiceBindingPropertiesStateBuilder(externalProperties); _visitables.get("externalProperties").add(this.externalProperties);} else { this.externalProperties = null; _visitables.get("externalProperties").remove(this.externalProperties); } return (A) this;
  }
  
  public boolean hasExternalProperties() {
    return this.externalProperties != null;
  }
  
  public ExternalPropertiesNested<A> withNewExternalProperties() {
    return new ExternalPropertiesNested(null);
  }
  
  public ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
    return new ExternalPropertiesNested(item);
  }
  
  public ExternalPropertiesNested<A> editExternalProperties() {
    return withNewExternalPropertiesLike(java.util.Optional.ofNullable(buildExternalProperties()).orElse(null));
  }
  
  public ExternalPropertiesNested<A> editOrNewExternalProperties() {
    return withNewExternalPropertiesLike(java.util.Optional.ofNullable(buildExternalProperties()).orElse(new ServiceBindingPropertiesStateBuilder().build()));
  }
  
  public ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
    return withNewExternalPropertiesLike(java.util.Optional.ofNullable(buildExternalProperties()).orElse(item));
  }
  
  public ServiceBindingPropertiesState buildInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  
  public A withInProgressProperties(ServiceBindingPropertiesState inProgressProperties) {
    _visitables.get("inProgressProperties").remove(this.inProgressProperties);
    if (inProgressProperties!=null){ this.inProgressProperties= new ServiceBindingPropertiesStateBuilder(inProgressProperties); _visitables.get("inProgressProperties").add(this.inProgressProperties);} else { this.inProgressProperties = null; _visitables.get("inProgressProperties").remove(this.inProgressProperties); } return (A) this;
  }
  
  public boolean hasInProgressProperties() {
    return this.inProgressProperties != null;
  }
  
  public InProgressPropertiesNested<A> withNewInProgressProperties() {
    return new InProgressPropertiesNested(null);
  }
  
  public InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
    return new InProgressPropertiesNested(item);
  }
  
  public InProgressPropertiesNested<A> editInProgressProperties() {
    return withNewInProgressPropertiesLike(java.util.Optional.ofNullable(buildInProgressProperties()).orElse(null));
  }
  
  public InProgressPropertiesNested<A> editOrNewInProgressProperties() {
    return withNewInProgressPropertiesLike(java.util.Optional.ofNullable(buildInProgressProperties()).orElse(new ServiceBindingPropertiesStateBuilder().build()));
  }
  
  public InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
    return withNewInProgressPropertiesLike(java.util.Optional.ofNullable(buildInProgressProperties()).orElse(item));
  }
  
  public String getLastOperation() {
    return this.lastOperation;
  }
  
  public A withLastOperation(String lastOperation) {
    this.lastOperation=lastOperation; return (A) this;
  }
  
  public boolean hasLastOperation() {
    return this.lastOperation != null;
  }
  
  public String getOperationStartTime() {
    return this.operationStartTime;
  }
  
  public A withOperationStartTime(String operationStartTime) {
    this.operationStartTime=operationStartTime; return (A) this;
  }
  
  public boolean hasOperationStartTime() {
    return this.operationStartTime != null;
  }
  
  public Boolean getOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress;
  }
  
  public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
    this.orphanMitigationInProgress=orphanMitigationInProgress; return (A) this;
  }
  
  public boolean hasOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress != null;
  }
  
  public Long getReconciledGeneration() {
    return this.reconciledGeneration;
  }
  
  public A withReconciledGeneration(Long reconciledGeneration) {
    this.reconciledGeneration=reconciledGeneration; return (A) this;
  }
  
  public boolean hasReconciledGeneration() {
    return this.reconciledGeneration != null;
  }
  
  public String getUnbindStatus() {
    return this.unbindStatus;
  }
  
  public A withUnbindStatus(String unbindStatus) {
    this.unbindStatus=unbindStatus; return (A) this;
  }
  
  public boolean hasUnbindStatus() {
    return this.unbindStatus != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingStatusFluent that = (ServiceBindingStatusFluent) o;
    if (!java.util.Objects.equals(asyncOpInProgress, that.asyncOpInProgress)) return false;
  
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
  
    if (!java.util.Objects.equals(currentOperation, that.currentOperation)) return false;
  
    if (!java.util.Objects.equals(externalProperties, that.externalProperties)) return false;
  
    if (!java.util.Objects.equals(inProgressProperties, that.inProgressProperties)) return false;
  
    if (!java.util.Objects.equals(lastOperation, that.lastOperation)) return false;
  
    if (!java.util.Objects.equals(operationStartTime, that.operationStartTime)) return false;
  
    if (!java.util.Objects.equals(orphanMitigationInProgress, that.orphanMitigationInProgress)) return false;
  
    if (!java.util.Objects.equals(reconciledGeneration, that.reconciledGeneration)) return false;
  
    if (!java.util.Objects.equals(unbindStatus, that.unbindStatus)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(asyncOpInProgress,  conditions,  currentOperation,  externalProperties,  inProgressProperties,  lastOperation,  operationStartTime,  orphanMitigationInProgress,  reconciledGeneration,  unbindStatus,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (asyncOpInProgress != null) { sb.append("asyncOpInProgress:"); sb.append(asyncOpInProgress + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentOperation != null) { sb.append("currentOperation:"); sb.append(currentOperation + ","); }
    if (externalProperties != null) { sb.append("externalProperties:"); sb.append(externalProperties + ","); }
    if (inProgressProperties != null) { sb.append("inProgressProperties:"); sb.append(inProgressProperties + ","); }
    if (lastOperation != null) { sb.append("lastOperation:"); sb.append(lastOperation + ","); }
    if (operationStartTime != null) { sb.append("operationStartTime:"); sb.append(operationStartTime + ","); }
    if (orphanMitigationInProgress != null) { sb.append("orphanMitigationInProgress:"); sb.append(orphanMitigationInProgress + ","); }
    if (reconciledGeneration != null) { sb.append("reconciledGeneration:"); sb.append(reconciledGeneration + ","); }
    if (unbindStatus != null) { sb.append("unbindStatus:"); sb.append(unbindStatus); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAsyncOpInProgress() {
    return withAsyncOpInProgress(true);
  }
  
  public A withOrphanMitigationInProgress() {
    return withOrphanMitigationInProgress(true);
  }
  public class ConditionsNested<N> extends ServiceBindingConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,ServiceBindingCondition item) {
      this.index = index;
      this.builder = new ServiceBindingConditionBuilder(this, item);
    }
    ServiceBindingConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ExternalPropertiesNested<N> extends ServiceBindingPropertiesStateFluent<ExternalPropertiesNested<N>> implements Nested<N>{
    ExternalPropertiesNested(ServiceBindingPropertiesState item) {
      this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
    }
    ServiceBindingPropertiesStateBuilder builder;
    
    public N and() {
      return (N) ServiceBindingStatusFluent.this.withExternalProperties(builder.build());
    }
    
    public N endExternalProperties() {
      return and();
    }
    
  
  }
  public class InProgressPropertiesNested<N> extends ServiceBindingPropertiesStateFluent<InProgressPropertiesNested<N>> implements Nested<N>{
    InProgressPropertiesNested(ServiceBindingPropertiesState item) {
      this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
    }
    ServiceBindingPropertiesStateBuilder builder;
    
    public N and() {
      return (N) ServiceBindingStatusFluent.this.withInProgressProperties(builder.build());
    }
    
    public N endInProgressProperties() {
      return and();
    }
    
  
  }

}