package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBrokerListBuilder extends ServiceBrokerListFluent<ServiceBrokerListBuilder> implements VisitableBuilder<ServiceBrokerList,ServiceBrokerListBuilder>{
  public ServiceBrokerListBuilder() {
    this(new ServiceBrokerList());
  }
  
  public ServiceBrokerListBuilder(ServiceBrokerListFluent<?> fluent) {
    this(fluent, new ServiceBrokerList());
  }
  
  public ServiceBrokerListBuilder(ServiceBrokerListFluent<?> fluent,ServiceBrokerList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBrokerListBuilder(ServiceBrokerList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBrokerListFluent<?> fluent;
  
  public ServiceBrokerList build() {
    ServiceBrokerList buildable = new ServiceBrokerList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}