package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceInstanceStatusBuilder extends ServiceInstanceStatusFluent<ServiceInstanceStatusBuilder> implements VisitableBuilder<ServiceInstanceStatus,ServiceInstanceStatusBuilder>{
  public ServiceInstanceStatusBuilder() {
    this(new ServiceInstanceStatus());
  }
  
  public ServiceInstanceStatusBuilder(ServiceInstanceStatusFluent<?> fluent) {
    this(fluent, new ServiceInstanceStatus());
  }
  
  public ServiceInstanceStatusBuilder(ServiceInstanceStatusFluent<?> fluent,ServiceInstanceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceInstanceStatusBuilder(ServiceInstanceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceInstanceStatusFluent<?> fluent;
  
  public ServiceInstanceStatus build() {
    ServiceInstanceStatus buildable = new ServiceInstanceStatus(fluent.getAsyncOpInProgress(),fluent.buildConditions(),fluent.getCurrentOperation(),fluent.getDashboardURL(),fluent.getDefaultProvisionParameters(),fluent.getDeprovisionStatus(),fluent.buildExternalProperties(),fluent.buildInProgressProperties(),fluent.getLastOperation(),fluent.getObservedGeneration(),fluent.getOperationStartTime(),fluent.getOrphanMitigationInProgress(),fluent.getProvisionStatus(),fluent.getReconciledGeneration());
    return buildable;
  }
  

}