package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServicePlanListBuilder extends ServicePlanListFluent<ServicePlanListBuilder> implements VisitableBuilder<ServicePlanList,ServicePlanListBuilder>{
  public ServicePlanListBuilder() {
    this(new ServicePlanList());
  }
  
  public ServicePlanListBuilder(ServicePlanListFluent<?> fluent) {
    this(fluent, new ServicePlanList());
  }
  
  public ServicePlanListBuilder(ServicePlanListFluent<?> fluent,ServicePlanList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServicePlanListBuilder(ServicePlanList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServicePlanListFluent<?> fluent;
  
  public ServicePlanList build() {
    ServicePlanList buildable = new ServicePlanList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}