/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.servicecatalog.api.model.LocalObjectReference;
import io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder;
import io.fabric8.servicecatalog.api.model.LocalObjectReferenceFluent;
import io.fabric8.servicecatalog.api.model.ParametersFromSource;
import io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder;
import io.fabric8.servicecatalog.api.model.ParametersFromSourceFluent;
import io.fabric8.servicecatalog.api.model.SecretTransform;
import io.fabric8.servicecatalog.api.model.SecretTransformBuilder;
import io.fabric8.servicecatalog.api.model.SecretTransformFluent;
import io.fabric8.servicecatalog.api.model.ServiceBindingSpec;
import io.fabric8.servicecatalog.api.model.UserInfo;
import io.fabric8.servicecatalog.api.model.UserInfoBuilder;
import io.fabric8.servicecatalog.api.model.UserInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceBindingSpecFluent<A extends ServiceBindingSpecFluent<A>>
extends BaseFluent<A> {
    private String externalID;
    private LocalObjectReferenceBuilder instanceRef;
    private Map<String, Object> parameters;
    private ArrayList<ParametersFromSourceBuilder> parametersFrom = new ArrayList();
    private String secretName;
    private ArrayList<SecretTransformBuilder> secretTransforms = new ArrayList();
    private UserInfoBuilder userInfo;

    public ServiceBindingSpecFluent() {
    }

    public ServiceBindingSpecFluent(ServiceBindingSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBindingSpec instance) {
        ServiceBindingSpec serviceBindingSpec = instance = instance != null ? instance : new ServiceBindingSpec();
        if (instance != null) {
            this.withExternalID(instance.getExternalID());
            this.withInstanceRef(instance.getInstanceRef());
            this.withParameters(instance.getParameters());
            this.withParametersFrom(instance.getParametersFrom());
            this.withSecretName(instance.getSecretName());
            this.withSecretTransforms(instance.getSecretTransforms());
            this.withUserInfo(instance.getUserInfo());
            this.withExternalID(instance.getExternalID());
            this.withInstanceRef(instance.getInstanceRef());
            this.withParameters(instance.getParameters());
            this.withParametersFrom(instance.getParametersFrom());
            this.withSecretName(instance.getSecretName());
            this.withSecretTransforms(instance.getSecretTransforms());
            this.withUserInfo(instance.getUserInfo());
        }
    }

    public String getExternalID() {
        return this.externalID;
    }

    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)((Object)this);
    }

    public boolean hasExternalID() {
        return this.externalID != null;
    }

    public LocalObjectReference buildInstanceRef() {
        return this.instanceRef != null ? this.instanceRef.build() : null;
    }

    public A withInstanceRef(LocalObjectReference instanceRef) {
        this._visitables.get((Object)"instanceRef").remove((Object)this.instanceRef);
        if (instanceRef != null) {
            this.instanceRef = new LocalObjectReferenceBuilder(instanceRef);
            this._visitables.get((Object)"instanceRef").add(this.instanceRef);
        } else {
            this.instanceRef = null;
            this._visitables.get((Object)"instanceRef").remove((Object)this.instanceRef);
        }
        return (A)((Object)this);
    }

    public boolean hasInstanceRef() {
        return this.instanceRef != null;
    }

    public A withNewInstanceRef(String name) {
        return this.withInstanceRef(new LocalObjectReference(name));
    }

    public InstanceRefNested<A> withNewInstanceRef() {
        return new InstanceRefNested(null);
    }

    public InstanceRefNested<A> withNewInstanceRefLike(LocalObjectReference item) {
        return new InstanceRefNested(item);
    }

    public InstanceRefNested<A> editInstanceRef() {
        return this.withNewInstanceRefLike(Optional.ofNullable(this.buildInstanceRef()).orElse(null));
    }

    public InstanceRefNested<A> editOrNewInstanceRef() {
        return this.withNewInstanceRefLike(Optional.ofNullable(this.buildInstanceRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public InstanceRefNested<A> editOrNewInstanceRefLike(LocalObjectReference item) {
        return this.withNewInstanceRefLike(Optional.ofNullable(this.buildInstanceRef()).orElse(item));
    }

    public A addToParameters(String key, Object value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToParameters(Map<String, Object> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromParameters(Map<String, Object> map) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public <K, V> A withParameters(Map<String, Object> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, Object>(parameters);
        return (A)((Object)this);
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public A addToParametersFrom(int index, ParametersFromSource item) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
        if (index < 0 || index >= this.parametersFrom.size()) {
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        } else {
            this._visitables.get((Object)"parametersFrom").add(index, builder);
            this.parametersFrom.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToParametersFrom(int index, ParametersFromSource item) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
        if (index < 0 || index >= this.parametersFrom.size()) {
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        } else {
            this._visitables.get((Object)"parametersFrom").set(index, builder);
            this.parametersFrom.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToParametersFrom(ParametersFromSource ... items) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToParametersFrom(Collection<ParametersFromSource> items) {
        if (this.parametersFrom == null) {
            this.parametersFrom = new ArrayList();
        }
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").add(builder);
            this.parametersFrom.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromParametersFrom(ParametersFromSource ... items) {
        if (this.parametersFrom == null) {
            return (A)((Object)this);
        }
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").remove((Object)builder);
            this.parametersFrom.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParametersFrom(Collection<ParametersFromSource> items) {
        if (this.parametersFrom == null) {
            return (A)((Object)this);
        }
        for (ParametersFromSource item : items) {
            ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
            this._visitables.get((Object)"parametersFrom").remove((Object)builder);
            this.parametersFrom.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        if (this.parametersFrom == null) {
            return (A)((Object)this);
        }
        Iterator<ParametersFromSourceBuilder> each = this.parametersFrom.iterator();
        List visitables = this._visitables.get((Object)"parametersFrom");
        while (each.hasNext()) {
            ParametersFromSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ParametersFromSource> buildParametersFrom() {
        return this.parametersFrom != null ? ServiceBindingSpecFluent.build(this.parametersFrom) : null;
    }

    public ParametersFromSource buildParametersFrom(int index) {
        return this.parametersFrom.get(index).build();
    }

    public ParametersFromSource buildFirstParametersFrom() {
        return this.parametersFrom.get(0).build();
    }

    public ParametersFromSource buildLastParametersFrom() {
        return this.parametersFrom.get(this.parametersFrom.size() - 1).build();
    }

    public ParametersFromSource buildMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        for (ParametersFromSourceBuilder item : this.parametersFrom) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        for (ParametersFromSourceBuilder item : this.parametersFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParametersFrom(List<ParametersFromSource> parametersFrom) {
        if (this.parametersFrom != null) {
            this._visitables.get((Object)"parametersFrom").clear();
        }
        if (parametersFrom != null) {
            this.parametersFrom = new ArrayList();
            for (ParametersFromSource item : parametersFrom) {
                this.addToParametersFrom(item);
            }
        } else {
            this.parametersFrom = null;
        }
        return (A)((Object)this);
    }

    public A withParametersFrom(ParametersFromSource ... parametersFrom) {
        if (this.parametersFrom != null) {
            this.parametersFrom.clear();
            this._visitables.remove((Object)"parametersFrom");
        }
        if (parametersFrom != null) {
            for (ParametersFromSource item : parametersFrom) {
                this.addToParametersFrom(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParametersFrom() {
        return this.parametersFrom != null && !this.parametersFrom.isEmpty();
    }

    public ParametersFromNested<A> addNewParametersFrom() {
        return new ParametersFromNested(-1, null);
    }

    public ParametersFromNested<A> addNewParametersFromLike(ParametersFromSource item) {
        return new ParametersFromNested(-1, item);
    }

    public ParametersFromNested<A> setNewParametersFromLike(int index, ParametersFromSource item) {
        return new ParametersFromNested(index, item);
    }

    public ParametersFromNested<A> editParametersFrom(int index) {
        if (this.parametersFrom.size() <= index) {
            throw new RuntimeException("Can't edit parametersFrom. Index exceeds size.");
        }
        return this.setNewParametersFromLike(index, this.buildParametersFrom(index));
    }

    public ParametersFromNested<A> editFirstParametersFrom() {
        if (this.parametersFrom.size() == 0) {
            throw new RuntimeException("Can't edit first parametersFrom. The list is empty.");
        }
        return this.setNewParametersFromLike(0, this.buildParametersFrom(0));
    }

    public ParametersFromNested<A> editLastParametersFrom() {
        int index = this.parametersFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parametersFrom. The list is empty.");
        }
        return this.setNewParametersFromLike(index, this.buildParametersFrom(index));
    }

    public ParametersFromNested<A> editMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parametersFrom.size(); ++i) {
            if (!predicate.test(this.parametersFrom.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parametersFrom. No match found.");
        }
        return this.setNewParametersFromLike(index, this.buildParametersFrom(index));
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public A addToSecretTransforms(int index, SecretTransform item) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        SecretTransformBuilder builder = new SecretTransformBuilder(item);
        if (index < 0 || index >= this.secretTransforms.size()) {
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        } else {
            this._visitables.get((Object)"secretTransforms").add(index, builder);
            this.secretTransforms.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSecretTransforms(int index, SecretTransform item) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        SecretTransformBuilder builder = new SecretTransformBuilder(item);
        if (index < 0 || index >= this.secretTransforms.size()) {
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        } else {
            this._visitables.get((Object)"secretTransforms").set(index, builder);
            this.secretTransforms.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSecretTransforms(SecretTransform ... items) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSecretTransforms(Collection<SecretTransform> items) {
        if (this.secretTransforms == null) {
            this.secretTransforms = new ArrayList();
        }
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").add(builder);
            this.secretTransforms.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSecretTransforms(SecretTransform ... items) {
        if (this.secretTransforms == null) {
            return (A)((Object)this);
        }
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").remove((Object)builder);
            this.secretTransforms.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecretTransforms(Collection<SecretTransform> items) {
        if (this.secretTransforms == null) {
            return (A)((Object)this);
        }
        for (SecretTransform item : items) {
            SecretTransformBuilder builder = new SecretTransformBuilder(item);
            this._visitables.get((Object)"secretTransforms").remove((Object)builder);
            this.secretTransforms.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSecretTransforms(Predicate<SecretTransformBuilder> predicate) {
        if (this.secretTransforms == null) {
            return (A)((Object)this);
        }
        Iterator<SecretTransformBuilder> each = this.secretTransforms.iterator();
        List visitables = this._visitables.get((Object)"secretTransforms");
        while (each.hasNext()) {
            SecretTransformBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SecretTransform> buildSecretTransforms() {
        return this.secretTransforms != null ? ServiceBindingSpecFluent.build(this.secretTransforms) : null;
    }

    public SecretTransform buildSecretTransform(int index) {
        return this.secretTransforms.get(index).build();
    }

    public SecretTransform buildFirstSecretTransform() {
        return this.secretTransforms.get(0).build();
    }

    public SecretTransform buildLastSecretTransform() {
        return this.secretTransforms.get(this.secretTransforms.size() - 1).build();
    }

    public SecretTransform buildMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
        for (SecretTransformBuilder item : this.secretTransforms) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
        for (SecretTransformBuilder item : this.secretTransforms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecretTransforms(List<SecretTransform> secretTransforms) {
        if (this.secretTransforms != null) {
            this._visitables.get((Object)"secretTransforms").clear();
        }
        if (secretTransforms != null) {
            this.secretTransforms = new ArrayList();
            for (SecretTransform item : secretTransforms) {
                this.addToSecretTransforms(item);
            }
        } else {
            this.secretTransforms = null;
        }
        return (A)((Object)this);
    }

    public A withSecretTransforms(SecretTransform ... secretTransforms) {
        if (this.secretTransforms != null) {
            this.secretTransforms.clear();
            this._visitables.remove((Object)"secretTransforms");
        }
        if (secretTransforms != null) {
            for (SecretTransform item : secretTransforms) {
                this.addToSecretTransforms(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSecretTransforms() {
        return this.secretTransforms != null && !this.secretTransforms.isEmpty();
    }

    public SecretTransformsNested<A> addNewSecretTransform() {
        return new SecretTransformsNested(-1, null);
    }

    public SecretTransformsNested<A> addNewSecretTransformLike(SecretTransform item) {
        return new SecretTransformsNested(-1, item);
    }

    public SecretTransformsNested<A> setNewSecretTransformLike(int index, SecretTransform item) {
        return new SecretTransformsNested(index, item);
    }

    public SecretTransformsNested<A> editSecretTransform(int index) {
        if (this.secretTransforms.size() <= index) {
            throw new RuntimeException("Can't edit secretTransforms. Index exceeds size.");
        }
        return this.setNewSecretTransformLike(index, this.buildSecretTransform(index));
    }

    public SecretTransformsNested<A> editFirstSecretTransform() {
        if (this.secretTransforms.size() == 0) {
            throw new RuntimeException("Can't edit first secretTransforms. The list is empty.");
        }
        return this.setNewSecretTransformLike(0, this.buildSecretTransform(0));
    }

    public SecretTransformsNested<A> editLastSecretTransform() {
        int index = this.secretTransforms.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretTransforms. The list is empty.");
        }
        return this.setNewSecretTransformLike(index, this.buildSecretTransform(index));
    }

    public SecretTransformsNested<A> editMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretTransforms.size(); ++i) {
            if (!predicate.test(this.secretTransforms.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretTransforms. No match found.");
        }
        return this.setNewSecretTransformLike(index, this.buildSecretTransform(index));
    }

    public UserInfo buildUserInfo() {
        return this.userInfo != null ? this.userInfo.build() : null;
    }

    public A withUserInfo(UserInfo userInfo) {
        this._visitables.get((Object)"userInfo").remove((Object)this.userInfo);
        if (userInfo != null) {
            this.userInfo = new UserInfoBuilder(userInfo);
            this._visitables.get((Object)"userInfo").add(this.userInfo);
        } else {
            this.userInfo = null;
            this._visitables.get((Object)"userInfo").remove((Object)this.userInfo);
        }
        return (A)((Object)this);
    }

    public boolean hasUserInfo() {
        return this.userInfo != null;
    }

    public UserInfoNested<A> withNewUserInfo() {
        return new UserInfoNested(null);
    }

    public UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
        return new UserInfoNested(item);
    }

    public UserInfoNested<A> editUserInfo() {
        return this.withNewUserInfoLike(Optional.ofNullable(this.buildUserInfo()).orElse(null));
    }

    public UserInfoNested<A> editOrNewUserInfo() {
        return this.withNewUserInfoLike(Optional.ofNullable(this.buildUserInfo()).orElse(new UserInfoBuilder().build()));
    }

    public UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
        return this.withNewUserInfoLike(Optional.ofNullable(this.buildUserInfo()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingSpecFluent that = (ServiceBindingSpecFluent)((Object)o);
        if (!Objects.equals(this.externalID, that.externalID)) {
            return false;
        }
        if (!Objects.equals((Object)this.instanceRef, (Object)that.instanceRef)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.parametersFrom, that.parametersFrom)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        if (!Objects.equals(this.secretTransforms, that.secretTransforms)) {
            return false;
        }
        return Objects.equals((Object)this.userInfo, (Object)that.userInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.externalID, this.instanceRef, this.parameters, this.parametersFrom, this.secretName, this.secretTransforms, this.userInfo, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.externalID != null) {
            sb.append("externalID:");
            sb.append(this.externalID + ",");
        }
        if (this.instanceRef != null) {
            sb.append("instanceRef:");
            sb.append((Object)((Object)this.instanceRef) + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.parametersFrom != null && !this.parametersFrom.isEmpty()) {
            sb.append("parametersFrom:");
            sb.append(this.parametersFrom + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.secretTransforms != null && !this.secretTransforms.isEmpty()) {
            sb.append("secretTransforms:");
            sb.append(this.secretTransforms + ",");
        }
        if (this.userInfo != null) {
            sb.append("userInfo:");
            sb.append((Object)this.userInfo);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserInfoNested<N>
    extends UserInfoFluent<UserInfoNested<N>>
    implements Nested<N> {
        UserInfoBuilder builder;

        UserInfoNested(UserInfo item) {
            this.builder = new UserInfoBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingSpecFluent.this.withUserInfo(this.builder.build());
        }

        public N endUserInfo() {
            return this.and();
        }
    }

    public class SecretTransformsNested<N>
    extends SecretTransformFluent<SecretTransformsNested<N>>
    implements Nested<N> {
        SecretTransformBuilder builder;
        int index;

        SecretTransformsNested(int index, SecretTransform item) {
            this.index = index;
            this.builder = new SecretTransformBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingSpecFluent.this.setToSecretTransforms(this.index, this.builder.build());
        }

        public N endSecretTransform() {
            return this.and();
        }
    }

    public class ParametersFromNested<N>
    extends ParametersFromSourceFluent<ParametersFromNested<N>>
    implements Nested<N> {
        ParametersFromSourceBuilder builder;
        int index;

        ParametersFromNested(int index, ParametersFromSource item) {
            this.index = index;
            this.builder = new ParametersFromSourceBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingSpecFluent.this.setToParametersFrom(this.index, this.builder.build());
        }

        public N endParametersFrom() {
            return this.and();
        }
    }

    public class InstanceRefNested<N>
    extends LocalObjectReferenceFluent<InstanceRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        InstanceRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingSpecFluent.this.withInstanceRef(this.builder.build());
        }

        public N endInstanceRef() {
            return this.and();
        }
    }
}

