/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.servicecatalog.api.model.ServiceInstanceCondition;
import io.fabric8.servicecatalog.api.model.ServiceInstanceConditionBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluent;
import io.fabric8.servicecatalog.api.model.ServiceInstancePropertiesState;
import io.fabric8.servicecatalog.api.model.ServiceInstancePropertiesStateBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstancePropertiesStateFluent;
import io.fabric8.servicecatalog.api.model.ServiceInstanceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceInstanceStatusFluent<A extends ServiceInstanceStatusFluent<A>>
extends BaseFluent<A> {
    private Boolean asyncOpInProgress;
    private ArrayList<ServiceInstanceConditionBuilder> conditions = new ArrayList();
    private String currentOperation;
    private String dashboardURL;
    private Map<String, Object> defaultProvisionParameters;
    private String deprovisionStatus;
    private ServiceInstancePropertiesStateBuilder externalProperties;
    private ServiceInstancePropertiesStateBuilder inProgressProperties;
    private String lastOperation;
    private Long observedGeneration;
    private String operationStartTime;
    private Boolean orphanMitigationInProgress;
    private String provisionStatus;
    private Long reconciledGeneration;

    public ServiceInstanceStatusFluent() {
    }

    public ServiceInstanceStatusFluent(ServiceInstanceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceInstanceStatus instance) {
        ServiceInstanceStatus serviceInstanceStatus = instance = instance != null ? instance : new ServiceInstanceStatus();
        if (instance != null) {
            this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
            this.withConditions(instance.getConditions());
            this.withCurrentOperation(instance.getCurrentOperation());
            this.withDashboardURL(instance.getDashboardURL());
            this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
            this.withDeprovisionStatus(instance.getDeprovisionStatus());
            this.withExternalProperties(instance.getExternalProperties());
            this.withInProgressProperties(instance.getInProgressProperties());
            this.withLastOperation(instance.getLastOperation());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withOperationStartTime(instance.getOperationStartTime());
            this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
            this.withProvisionStatus(instance.getProvisionStatus());
            this.withReconciledGeneration(instance.getReconciledGeneration());
            this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
            this.withConditions(instance.getConditions());
            this.withCurrentOperation(instance.getCurrentOperation());
            this.withDashboardURL(instance.getDashboardURL());
            this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
            this.withDeprovisionStatus(instance.getDeprovisionStatus());
            this.withExternalProperties(instance.getExternalProperties());
            this.withInProgressProperties(instance.getInProgressProperties());
            this.withLastOperation(instance.getLastOperation());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withOperationStartTime(instance.getOperationStartTime());
            this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
            this.withProvisionStatus(instance.getProvisionStatus());
            this.withReconciledGeneration(instance.getReconciledGeneration());
        }
    }

    public Boolean getAsyncOpInProgress() {
        return this.asyncOpInProgress;
    }

    public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
        this.asyncOpInProgress = asyncOpInProgress;
        return (A)((Object)this);
    }

    public boolean hasAsyncOpInProgress() {
        return this.asyncOpInProgress != null;
    }

    public A addToConditions(int index, ServiceInstanceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, ServiceInstanceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(ServiceInstanceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<ServiceInstanceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(ServiceInstanceCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<ServiceInstanceCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ServiceInstanceCondition item : items) {
            ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ServiceInstanceConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ServiceInstanceConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ServiceInstanceConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServiceInstanceCondition> buildConditions() {
        return this.conditions != null ? ServiceInstanceStatusFluent.build(this.conditions) : null;
    }

    public ServiceInstanceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public ServiceInstanceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ServiceInstanceCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ServiceInstanceCondition buildMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
        for (ServiceInstanceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
        for (ServiceInstanceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<ServiceInstanceCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ServiceInstanceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(ServiceInstanceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ServiceInstanceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ServiceInstanceCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(ServiceInstanceCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ServiceInstanceCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getCurrentOperation() {
        return this.currentOperation;
    }

    public A withCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
        return (A)((Object)this);
    }

    public boolean hasCurrentOperation() {
        return this.currentOperation != null;
    }

    public String getDashboardURL() {
        return this.dashboardURL;
    }

    public A withDashboardURL(String dashboardURL) {
        this.dashboardURL = dashboardURL;
        return (A)((Object)this);
    }

    public boolean hasDashboardURL() {
        return this.dashboardURL != null;
    }

    public A addToDefaultProvisionParameters(String key, Object value) {
        if (this.defaultProvisionParameters == null && key != null && value != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.defaultProvisionParameters.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null && map != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.defaultProvisionParameters.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromDefaultProvisionParameters(String key) {
        if (this.defaultProvisionParameters == null) {
            return (A)((Object)this);
        }
        if (key != null && this.defaultProvisionParameters != null) {
            this.defaultProvisionParameters.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.defaultProvisionParameters == null) continue;
                this.defaultProvisionParameters.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getDefaultProvisionParameters() {
        return this.defaultProvisionParameters;
    }

    public <K, V> A withDefaultProvisionParameters(Map<String, Object> defaultProvisionParameters) {
        this.defaultProvisionParameters = defaultProvisionParameters == null ? null : new LinkedHashMap<String, Object>(defaultProvisionParameters);
        return (A)((Object)this);
    }

    public boolean hasDefaultProvisionParameters() {
        return this.defaultProvisionParameters != null;
    }

    public String getDeprovisionStatus() {
        return this.deprovisionStatus;
    }

    public A withDeprovisionStatus(String deprovisionStatus) {
        this.deprovisionStatus = deprovisionStatus;
        return (A)((Object)this);
    }

    public boolean hasDeprovisionStatus() {
        return this.deprovisionStatus != null;
    }

    public ServiceInstancePropertiesState buildExternalProperties() {
        return this.externalProperties != null ? this.externalProperties.build() : null;
    }

    public A withExternalProperties(ServiceInstancePropertiesState externalProperties) {
        this._visitables.get((Object)"externalProperties").remove((Object)this.externalProperties);
        if (externalProperties != null) {
            this.externalProperties = new ServiceInstancePropertiesStateBuilder(externalProperties);
            this._visitables.get((Object)"externalProperties").add(this.externalProperties);
        } else {
            this.externalProperties = null;
            this._visitables.get((Object)"externalProperties").remove((Object)this.externalProperties);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalProperties() {
        return this.externalProperties != null;
    }

    public ExternalPropertiesNested<A> withNewExternalProperties() {
        return new ExternalPropertiesNested(null);
    }

    public ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
        return new ExternalPropertiesNested(item);
    }

    public ExternalPropertiesNested<A> editExternalProperties() {
        return this.withNewExternalPropertiesLike(Optional.ofNullable(this.buildExternalProperties()).orElse(null));
    }

    public ExternalPropertiesNested<A> editOrNewExternalProperties() {
        return this.withNewExternalPropertiesLike(Optional.ofNullable(this.buildExternalProperties()).orElse(new ServiceInstancePropertiesStateBuilder().build()));
    }

    public ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
        return this.withNewExternalPropertiesLike(Optional.ofNullable(this.buildExternalProperties()).orElse(item));
    }

    public ServiceInstancePropertiesState buildInProgressProperties() {
        return this.inProgressProperties != null ? this.inProgressProperties.build() : null;
    }

    public A withInProgressProperties(ServiceInstancePropertiesState inProgressProperties) {
        this._visitables.get((Object)"inProgressProperties").remove((Object)this.inProgressProperties);
        if (inProgressProperties != null) {
            this.inProgressProperties = new ServiceInstancePropertiesStateBuilder(inProgressProperties);
            this._visitables.get((Object)"inProgressProperties").add(this.inProgressProperties);
        } else {
            this.inProgressProperties = null;
            this._visitables.get((Object)"inProgressProperties").remove((Object)this.inProgressProperties);
        }
        return (A)((Object)this);
    }

    public boolean hasInProgressProperties() {
        return this.inProgressProperties != null;
    }

    public InProgressPropertiesNested<A> withNewInProgressProperties() {
        return new InProgressPropertiesNested(null);
    }

    public InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
        return new InProgressPropertiesNested(item);
    }

    public InProgressPropertiesNested<A> editInProgressProperties() {
        return this.withNewInProgressPropertiesLike(Optional.ofNullable(this.buildInProgressProperties()).orElse(null));
    }

    public InProgressPropertiesNested<A> editOrNewInProgressProperties() {
        return this.withNewInProgressPropertiesLike(Optional.ofNullable(this.buildInProgressProperties()).orElse(new ServiceInstancePropertiesStateBuilder().build()));
    }

    public InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
        return this.withNewInProgressPropertiesLike(Optional.ofNullable(this.buildInProgressProperties()).orElse(item));
    }

    public String getLastOperation() {
        return this.lastOperation;
    }

    public A withLastOperation(String lastOperation) {
        this.lastOperation = lastOperation;
        return (A)((Object)this);
    }

    public boolean hasLastOperation() {
        return this.lastOperation != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getOperationStartTime() {
        return this.operationStartTime;
    }

    public A withOperationStartTime(String operationStartTime) {
        this.operationStartTime = operationStartTime;
        return (A)((Object)this);
    }

    public boolean hasOperationStartTime() {
        return this.operationStartTime != null;
    }

    public Boolean getOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress;
    }

    public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
        this.orphanMitigationInProgress = orphanMitigationInProgress;
        return (A)((Object)this);
    }

    public boolean hasOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress != null;
    }

    public String getProvisionStatus() {
        return this.provisionStatus;
    }

    public A withProvisionStatus(String provisionStatus) {
        this.provisionStatus = provisionStatus;
        return (A)((Object)this);
    }

    public boolean hasProvisionStatus() {
        return this.provisionStatus != null;
    }

    public Long getReconciledGeneration() {
        return this.reconciledGeneration;
    }

    public A withReconciledGeneration(Long reconciledGeneration) {
        this.reconciledGeneration = reconciledGeneration;
        return (A)((Object)this);
    }

    public boolean hasReconciledGeneration() {
        return this.reconciledGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstanceStatusFluent that = (ServiceInstanceStatusFluent)((Object)o);
        if (!Objects.equals(this.asyncOpInProgress, that.asyncOpInProgress)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentOperation, that.currentOperation)) {
            return false;
        }
        if (!Objects.equals(this.dashboardURL, that.dashboardURL)) {
            return false;
        }
        if (!Objects.equals(this.defaultProvisionParameters, that.defaultProvisionParameters)) {
            return false;
        }
        if (!Objects.equals(this.deprovisionStatus, that.deprovisionStatus)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalProperties, (Object)that.externalProperties)) {
            return false;
        }
        if (!Objects.equals((Object)this.inProgressProperties, (Object)that.inProgressProperties)) {
            return false;
        }
        if (!Objects.equals(this.lastOperation, that.lastOperation)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.operationStartTime, that.operationStartTime)) {
            return false;
        }
        if (!Objects.equals(this.orphanMitigationInProgress, that.orphanMitigationInProgress)) {
            return false;
        }
        if (!Objects.equals(this.provisionStatus, that.provisionStatus)) {
            return false;
        }
        return Objects.equals(this.reconciledGeneration, that.reconciledGeneration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asyncOpInProgress, this.conditions, this.currentOperation, this.dashboardURL, this.defaultProvisionParameters, this.deprovisionStatus, this.externalProperties, this.inProgressProperties, this.lastOperation, this.observedGeneration, this.operationStartTime, this.orphanMitigationInProgress, this.provisionStatus, this.reconciledGeneration, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.asyncOpInProgress != null) {
            sb.append("asyncOpInProgress:");
            sb.append(this.asyncOpInProgress + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentOperation != null) {
            sb.append("currentOperation:");
            sb.append(this.currentOperation + ",");
        }
        if (this.dashboardURL != null) {
            sb.append("dashboardURL:");
            sb.append(this.dashboardURL + ",");
        }
        if (this.defaultProvisionParameters != null && !this.defaultProvisionParameters.isEmpty()) {
            sb.append("defaultProvisionParameters:");
            sb.append(this.defaultProvisionParameters + ",");
        }
        if (this.deprovisionStatus != null) {
            sb.append("deprovisionStatus:");
            sb.append(this.deprovisionStatus + ",");
        }
        if (this.externalProperties != null) {
            sb.append("externalProperties:");
            sb.append((Object)((Object)this.externalProperties) + ",");
        }
        if (this.inProgressProperties != null) {
            sb.append("inProgressProperties:");
            sb.append((Object)((Object)this.inProgressProperties) + ",");
        }
        if (this.lastOperation != null) {
            sb.append("lastOperation:");
            sb.append(this.lastOperation + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.operationStartTime != null) {
            sb.append("operationStartTime:");
            sb.append(this.operationStartTime + ",");
        }
        if (this.orphanMitigationInProgress != null) {
            sb.append("orphanMitigationInProgress:");
            sb.append(this.orphanMitigationInProgress + ",");
        }
        if (this.provisionStatus != null) {
            sb.append("provisionStatus:");
            sb.append(this.provisionStatus + ",");
        }
        if (this.reconciledGeneration != null) {
            sb.append("reconciledGeneration:");
            sb.append(this.reconciledGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAsyncOpInProgress() {
        return this.withAsyncOpInProgress(true);
    }

    public A withOrphanMitigationInProgress() {
        return this.withOrphanMitigationInProgress(true);
    }

    public class InProgressPropertiesNested<N>
    extends ServiceInstancePropertiesStateFluent<InProgressPropertiesNested<N>>
    implements Nested<N> {
        ServiceInstancePropertiesStateBuilder builder;

        InProgressPropertiesNested(ServiceInstancePropertiesState item) {
            this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
        }

        public N and() {
            return (N)ServiceInstanceStatusFluent.this.withInProgressProperties(this.builder.build());
        }

        public N endInProgressProperties() {
            return this.and();
        }
    }

    public class ExternalPropertiesNested<N>
    extends ServiceInstancePropertiesStateFluent<ExternalPropertiesNested<N>>
    implements Nested<N> {
        ServiceInstancePropertiesStateBuilder builder;

        ExternalPropertiesNested(ServiceInstancePropertiesState item) {
            this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
        }

        public N and() {
            return (N)ServiceInstanceStatusFluent.this.withExternalProperties(this.builder.build());
        }

        public N endExternalProperties() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ServiceInstanceConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ServiceInstanceConditionBuilder builder;
        int index;

        ConditionsNested(int index, ServiceInstanceCondition item) {
            this.index = index;
            this.builder = new ServiceInstanceConditionBuilder(this, item);
        }

        public N and() {
            return (N)ServiceInstanceStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

