package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BearerTokenAuthConfigBuilder extends BearerTokenAuthConfigFluent<BearerTokenAuthConfigBuilder> implements VisitableBuilder<BearerTokenAuthConfig,BearerTokenAuthConfigBuilder>{
  public BearerTokenAuthConfigBuilder() {
    this(new BearerTokenAuthConfig());
  }
  
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfigFluent<?> fluent) {
    this(fluent, new BearerTokenAuthConfig());
  }
  
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfigFluent<?> fluent,BearerTokenAuthConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BearerTokenAuthConfigFluent<?> fluent;
  
  public BearerTokenAuthConfig build() {
    BearerTokenAuthConfig buildable = new BearerTokenAuthConfig(fluent.buildSecretRef());
    return buildable;
  }
  

}