package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CatalogRestrictionsFluent<A extends CatalogRestrictionsFluent<A>> extends BaseFluent<A>{
  public CatalogRestrictionsFluent() {
  }
  
  public CatalogRestrictionsFluent(CatalogRestrictions instance) {
    this.copyInstance(instance);
  }
  private List<String> serviceClass = new ArrayList<String>();
  private List<String> servicePlan = new ArrayList<String>();
  
  protected void copyInstance(CatalogRestrictions instance) {
    instance = (instance != null ? instance : new CatalogRestrictions());
    if (instance != null) {
          this.withServiceClass(instance.getServiceClass());
          this.withServicePlan(instance.getServicePlan());
          this.withServiceClass(instance.getServiceClass());
          this.withServicePlan(instance.getServicePlan());
        }
  }
  
  public A addToServiceClass(int index,String item) {
    if (this.serviceClass == null) {this.serviceClass = new ArrayList<String>();}
    this.serviceClass.add(index, item);
    return (A)this;
  }
  
  public A setToServiceClass(int index,String item) {
    if (this.serviceClass == null) {this.serviceClass = new ArrayList<String>();}
    this.serviceClass.set(index, item); return (A)this;
  }
  
  public A addToServiceClass(java.lang.String... items) {
    if (this.serviceClass == null) {this.serviceClass = new ArrayList<String>();}
    for (String item : items) {this.serviceClass.add(item);} return (A)this;
  }
  
  public A addAllToServiceClass(Collection<String> items) {
    if (this.serviceClass == null) {this.serviceClass = new ArrayList<String>();}
    for (String item : items) {this.serviceClass.add(item);} return (A)this;
  }
  
  public A removeFromServiceClass(java.lang.String... items) {
    if (this.serviceClass == null) return (A)this;
    for (String item : items) { this.serviceClass.remove(item);} return (A)this;
  }
  
  public A removeAllFromServiceClass(Collection<String> items) {
    if (this.serviceClass == null) return (A)this;
    for (String item : items) { this.serviceClass.remove(item);} return (A)this;
  }
  
  public List<String> getServiceClass() {
    return this.serviceClass;
  }
  
  public String getServiceClass(int index) {
    return this.serviceClass.get(index);
  }
  
  public String getFirstServiceClass() {
    return this.serviceClass.get(0);
  }
  
  public String getLastServiceClass() {
    return this.serviceClass.get(serviceClass.size() - 1);
  }
  
  public String getMatchingServiceClass(Predicate<String> predicate) {
      for (String item : serviceClass) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceClass(Predicate<String> predicate) {
      for (String item : serviceClass) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceClass(List<String> serviceClass) {
    if (serviceClass != null) {
        this.serviceClass = new ArrayList();
        for (String item : serviceClass) {
          this.addToServiceClass(item);
        }
    } else {
      this.serviceClass = null;
    }
    return (A) this;
  }
  
  public A withServiceClass(java.lang.String... serviceClass) {
    if (this.serviceClass != null) {this.serviceClass.clear(); _visitables.remove("serviceClass"); }
    if (serviceClass != null) {for (String item :serviceClass){ this.addToServiceClass(item);}} return (A) this;
  }
  
  public boolean hasServiceClass() {
    return this.serviceClass != null && !this.serviceClass.isEmpty();
  }
  
  public A addToServicePlan(int index,String item) {
    if (this.servicePlan == null) {this.servicePlan = new ArrayList<String>();}
    this.servicePlan.add(index, item);
    return (A)this;
  }
  
  public A setToServicePlan(int index,String item) {
    if (this.servicePlan == null) {this.servicePlan = new ArrayList<String>();}
    this.servicePlan.set(index, item); return (A)this;
  }
  
  public A addToServicePlan(java.lang.String... items) {
    if (this.servicePlan == null) {this.servicePlan = new ArrayList<String>();}
    for (String item : items) {this.servicePlan.add(item);} return (A)this;
  }
  
  public A addAllToServicePlan(Collection<String> items) {
    if (this.servicePlan == null) {this.servicePlan = new ArrayList<String>();}
    for (String item : items) {this.servicePlan.add(item);} return (A)this;
  }
  
  public A removeFromServicePlan(java.lang.String... items) {
    if (this.servicePlan == null) return (A)this;
    for (String item : items) { this.servicePlan.remove(item);} return (A)this;
  }
  
  public A removeAllFromServicePlan(Collection<String> items) {
    if (this.servicePlan == null) return (A)this;
    for (String item : items) { this.servicePlan.remove(item);} return (A)this;
  }
  
  public List<String> getServicePlan() {
    return this.servicePlan;
  }
  
  public String getServicePlan(int index) {
    return this.servicePlan.get(index);
  }
  
  public String getFirstServicePlan() {
    return this.servicePlan.get(0);
  }
  
  public String getLastServicePlan() {
    return this.servicePlan.get(servicePlan.size() - 1);
  }
  
  public String getMatchingServicePlan(Predicate<String> predicate) {
      for (String item : servicePlan) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingServicePlan(Predicate<String> predicate) {
      for (String item : servicePlan) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServicePlan(List<String> servicePlan) {
    if (servicePlan != null) {
        this.servicePlan = new ArrayList();
        for (String item : servicePlan) {
          this.addToServicePlan(item);
        }
    } else {
      this.servicePlan = null;
    }
    return (A) this;
  }
  
  public A withServicePlan(java.lang.String... servicePlan) {
    if (this.servicePlan != null) {this.servicePlan.clear(); _visitables.remove("servicePlan"); }
    if (servicePlan != null) {for (String item :servicePlan){ this.addToServicePlan(item);}} return (A) this;
  }
  
  public boolean hasServicePlan() {
    return this.servicePlan != null && !this.servicePlan.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CatalogRestrictionsFluent that = (CatalogRestrictionsFluent) o;
    if (!java.util.Objects.equals(serviceClass, that.serviceClass)) return false;
    if (!java.util.Objects.equals(servicePlan, that.servicePlan)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(serviceClass,  servicePlan,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (serviceClass != null && !serviceClass.isEmpty()) { sb.append("serviceClass:"); sb.append(serviceClass + ","); }
    if (servicePlan != null && !servicePlan.isEmpty()) { sb.append("servicePlan:"); sb.append(servicePlan); }
    sb.append("}");
    return sb.toString();
  }
  

}