package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterBearerTokenAuthConfigFluent<A extends ClusterBearerTokenAuthConfigFluent<A>> extends BaseFluent<A>{
  public ClusterBearerTokenAuthConfigFluent() {
  }
  
  public ClusterBearerTokenAuthConfigFluent(ClusterBearerTokenAuthConfig instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder secretRef;
  
  protected void copyInstance(ClusterBearerTokenAuthConfig instance) {
    instance = (instance != null ? instance : new ClusterBearerTokenAuthConfig());
    if (instance != null) {
          this.withSecretRef(instance.getSecretRef());
          this.withSecretRef(instance.getSecretRef());
        }
  }
  
  public ObjectReference buildSecretRef() {
    return this.secretRef != null ? this.secretRef.build() : null;
  }
  
  public A withSecretRef(ObjectReference secretRef) {
    this._visitables.remove(this.secretRef);
    if (secretRef != null) {
        this.secretRef = new ObjectReferenceBuilder(secretRef);
        this._visitables.get("secretRef").add(this.secretRef);
    } else {
        this.secretRef = null;
        this._visitables.get("secretRef").remove(this.secretRef);
    }
    return (A) this;
  }
  
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  
  public A withNewSecretRef(String name,String namespace) {
    return (A)withSecretRef(new ObjectReference(name, namespace));
  }
  
  public SecretRefNested<A> withNewSecretRef() {
    return new SecretRefNested(null);
  }
  
  public SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
    return new SecretRefNested(item);
  }
  
  public SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(null));
  }
  
  public SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterBearerTokenAuthConfigFluent that = (ClusterBearerTokenAuthConfigFluent) o;
    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(secretRef,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretRefNested<N> extends ObjectReferenceFluent<SecretRefNested<N>> implements Nested<N>{
    SecretRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterBearerTokenAuthConfigFluent.this.withSecretRef(builder.build());
    }
    
    public N endSecretRef() {
      return and();
    }
    
  
  }

}