package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServiceBrokerBuilder extends ClusterServiceBrokerFluent<ClusterServiceBrokerBuilder> implements VisitableBuilder<ClusterServiceBroker,ClusterServiceBrokerBuilder>{
  public ClusterServiceBrokerBuilder() {
    this(new ClusterServiceBroker());
  }
  
  public ClusterServiceBrokerBuilder(ClusterServiceBrokerFluent<?> fluent) {
    this(fluent, new ClusterServiceBroker());
  }
  
  public ClusterServiceBrokerBuilder(ClusterServiceBrokerFluent<?> fluent,ClusterServiceBroker instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServiceBrokerBuilder(ClusterServiceBroker instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServiceBrokerFluent<?> fluent;
  
  public ClusterServiceBroker build() {
    ClusterServiceBroker buildable = new ClusterServiceBroker(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}