package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterServiceBrokerSpecFluent<A extends ClusterServiceBrokerSpecFluent<A>> extends BaseFluent<A>{
  public ClusterServiceBrokerSpecFluent() {
  }
  
  public ClusterServiceBrokerSpecFluent(ClusterServiceBrokerSpec instance) {
    this.copyInstance(instance);
  }
  private ClusterServiceBrokerAuthInfoBuilder authInfo;
  private String caBundle;
  private CatalogRestrictionsBuilder catalogRestrictions;
  private Boolean insecureSkipTLSVerify;
  private String relistBehavior;
  private Duration relistDuration;
  private Long relistRequests;
  private String url;
  
  protected void copyInstance(ClusterServiceBrokerSpec instance) {
    instance = (instance != null ? instance : new ClusterServiceBrokerSpec());
    if (instance != null) {
          this.withAuthInfo(instance.getAuthInfo());
          this.withCaBundle(instance.getCaBundle());
          this.withCatalogRestrictions(instance.getCatalogRestrictions());
          this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
          this.withRelistBehavior(instance.getRelistBehavior());
          this.withRelistDuration(instance.getRelistDuration());
          this.withRelistRequests(instance.getRelistRequests());
          this.withUrl(instance.getUrl());
          this.withAuthInfo(instance.getAuthInfo());
          this.withCaBundle(instance.getCaBundle());
          this.withCatalogRestrictions(instance.getCatalogRestrictions());
          this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
          this.withRelistBehavior(instance.getRelistBehavior());
          this.withRelistDuration(instance.getRelistDuration());
          this.withRelistRequests(instance.getRelistRequests());
          this.withUrl(instance.getUrl());
        }
  }
  
  public ClusterServiceBrokerAuthInfo buildAuthInfo() {
    return this.authInfo != null ? this.authInfo.build() : null;
  }
  
  public A withAuthInfo(ClusterServiceBrokerAuthInfo authInfo) {
    this._visitables.remove(this.authInfo);
    if (authInfo != null) {
        this.authInfo = new ClusterServiceBrokerAuthInfoBuilder(authInfo);
        this._visitables.get("authInfo").add(this.authInfo);
    } else {
        this.authInfo = null;
        this._visitables.get("authInfo").remove(this.authInfo);
    }
    return (A) this;
  }
  
  public boolean hasAuthInfo() {
    return this.authInfo != null;
  }
  
  public AuthInfoNested<A> withNewAuthInfo() {
    return new AuthInfoNested(null);
  }
  
  public AuthInfoNested<A> withNewAuthInfoLike(ClusterServiceBrokerAuthInfo item) {
    return new AuthInfoNested(item);
  }
  
  public AuthInfoNested<A> editAuthInfo() {
    return withNewAuthInfoLike(java.util.Optional.ofNullable(buildAuthInfo()).orElse(null));
  }
  
  public AuthInfoNested<A> editOrNewAuthInfo() {
    return withNewAuthInfoLike(java.util.Optional.ofNullable(buildAuthInfo()).orElse(new ClusterServiceBrokerAuthInfoBuilder().build()));
  }
  
  public AuthInfoNested<A> editOrNewAuthInfoLike(ClusterServiceBrokerAuthInfo item) {
    return withNewAuthInfoLike(java.util.Optional.ofNullable(buildAuthInfo()).orElse(item));
  }
  
  public String getCaBundle() {
    return this.caBundle;
  }
  
  public A withCaBundle(String caBundle) {
    this.caBundle = caBundle;
    return (A) this;
  }
  
  public boolean hasCaBundle() {
    return this.caBundle != null;
  }
  
  public CatalogRestrictions buildCatalogRestrictions() {
    return this.catalogRestrictions != null ? this.catalogRestrictions.build() : null;
  }
  
  public A withCatalogRestrictions(CatalogRestrictions catalogRestrictions) {
    this._visitables.remove(this.catalogRestrictions);
    if (catalogRestrictions != null) {
        this.catalogRestrictions = new CatalogRestrictionsBuilder(catalogRestrictions);
        this._visitables.get("catalogRestrictions").add(this.catalogRestrictions);
    } else {
        this.catalogRestrictions = null;
        this._visitables.get("catalogRestrictions").remove(this.catalogRestrictions);
    }
    return (A) this;
  }
  
  public boolean hasCatalogRestrictions() {
    return this.catalogRestrictions != null;
  }
  
  public CatalogRestrictionsNested<A> withNewCatalogRestrictions() {
    return new CatalogRestrictionsNested(null);
  }
  
  public CatalogRestrictionsNested<A> withNewCatalogRestrictionsLike(CatalogRestrictions item) {
    return new CatalogRestrictionsNested(item);
  }
  
  public CatalogRestrictionsNested<A> editCatalogRestrictions() {
    return withNewCatalogRestrictionsLike(java.util.Optional.ofNullable(buildCatalogRestrictions()).orElse(null));
  }
  
  public CatalogRestrictionsNested<A> editOrNewCatalogRestrictions() {
    return withNewCatalogRestrictionsLike(java.util.Optional.ofNullable(buildCatalogRestrictions()).orElse(new CatalogRestrictionsBuilder().build()));
  }
  
  public CatalogRestrictionsNested<A> editOrNewCatalogRestrictionsLike(CatalogRestrictions item) {
    return withNewCatalogRestrictionsLike(java.util.Optional.ofNullable(buildCatalogRestrictions()).orElse(item));
  }
  
  public Boolean getInsecureSkipTLSVerify() {
    return this.insecureSkipTLSVerify;
  }
  
  public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
    this.insecureSkipTLSVerify = insecureSkipTLSVerify;
    return (A) this;
  }
  
  public boolean hasInsecureSkipTLSVerify() {
    return this.insecureSkipTLSVerify != null;
  }
  
  public String getRelistBehavior() {
    return this.relistBehavior;
  }
  
  public A withRelistBehavior(String relistBehavior) {
    this.relistBehavior = relistBehavior;
    return (A) this;
  }
  
  public boolean hasRelistBehavior() {
    return this.relistBehavior != null;
  }
  
  public Duration getRelistDuration() {
    return this.relistDuration;
  }
  
  public A withRelistDuration(Duration relistDuration) {
    this.relistDuration = relistDuration;
    return (A) this;
  }
  
  public boolean hasRelistDuration() {
    return this.relistDuration != null;
  }
  
  public Long getRelistRequests() {
    return this.relistRequests;
  }
  
  public A withRelistRequests(Long relistRequests) {
    this.relistRequests = relistRequests;
    return (A) this;
  }
  
  public boolean hasRelistRequests() {
    return this.relistRequests != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterServiceBrokerSpecFluent that = (ClusterServiceBrokerSpecFluent) o;
    if (!java.util.Objects.equals(authInfo, that.authInfo)) return false;
    if (!java.util.Objects.equals(caBundle, that.caBundle)) return false;
    if (!java.util.Objects.equals(catalogRestrictions, that.catalogRestrictions)) return false;
    if (!java.util.Objects.equals(insecureSkipTLSVerify, that.insecureSkipTLSVerify)) return false;
    if (!java.util.Objects.equals(relistBehavior, that.relistBehavior)) return false;
    if (!java.util.Objects.equals(relistDuration, that.relistDuration)) return false;
    if (!java.util.Objects.equals(relistRequests, that.relistRequests)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authInfo,  caBundle,  catalogRestrictions,  insecureSkipTLSVerify,  relistBehavior,  relistDuration,  relistRequests,  url,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authInfo != null) { sb.append("authInfo:"); sb.append(authInfo + ","); }
    if (caBundle != null) { sb.append("caBundle:"); sb.append(caBundle + ","); }
    if (catalogRestrictions != null) { sb.append("catalogRestrictions:"); sb.append(catalogRestrictions + ","); }
    if (insecureSkipTLSVerify != null) { sb.append("insecureSkipTLSVerify:"); sb.append(insecureSkipTLSVerify + ","); }
    if (relistBehavior != null) { sb.append("relistBehavior:"); sb.append(relistBehavior + ","); }
    if (relistDuration != null) { sb.append("relistDuration:"); sb.append(relistDuration + ","); }
    if (relistRequests != null) { sb.append("relistRequests:"); sb.append(relistRequests + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecureSkipTLSVerify() {
    return withInsecureSkipTLSVerify(true);
  }
  public class AuthInfoNested<N> extends ClusterServiceBrokerAuthInfoFluent<AuthInfoNested<N>> implements Nested<N>{
    AuthInfoNested(ClusterServiceBrokerAuthInfo item) {
      this.builder = new ClusterServiceBrokerAuthInfoBuilder(this, item);
    }
    ClusterServiceBrokerAuthInfoBuilder builder;
    
    public N and() {
      return (N) ClusterServiceBrokerSpecFluent.this.withAuthInfo(builder.build());
    }
    
    public N endAuthInfo() {
      return and();
    }
    
  
  }
  public class CatalogRestrictionsNested<N> extends CatalogRestrictionsFluent<CatalogRestrictionsNested<N>> implements Nested<N>{
    CatalogRestrictionsNested(CatalogRestrictions item) {
      this.builder = new CatalogRestrictionsBuilder(this, item);
    }
    CatalogRestrictionsBuilder builder;
    
    public N and() {
      return (N) ClusterServiceBrokerSpecFluent.this.withCatalogRestrictions(builder.build());
    }
    
    public N endCatalogRestrictions() {
      return and();
    }
    
  
  }

}