package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServiceClassSpecBuilder extends ClusterServiceClassSpecFluent<ClusterServiceClassSpecBuilder> implements VisitableBuilder<ClusterServiceClassSpec,ClusterServiceClassSpecBuilder>{
  public ClusterServiceClassSpecBuilder() {
    this(new ClusterServiceClassSpec());
  }
  
  public ClusterServiceClassSpecBuilder(ClusterServiceClassSpecFluent<?> fluent) {
    this(fluent, new ClusterServiceClassSpec());
  }
  
  public ClusterServiceClassSpecBuilder(ClusterServiceClassSpecFluent<?> fluent,ClusterServiceClassSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServiceClassSpecBuilder(ClusterServiceClassSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServiceClassSpecFluent<?> fluent;
  
  public ClusterServiceClassSpec build() {
    ClusterServiceClassSpec buildable = new ClusterServiceClassSpec(fluent.getBindable(),fluent.getBindingRetrievable(),fluent.getClusterServiceBrokerName(),fluent.getDefaultProvisionParameters(),fluent.getDescription(),fluent.getExternalID(),fluent.getExternalMetadata(),fluent.getExternalName(),fluent.getPlanUpdatable(),fluent.getRequires(),fluent.getTags());
    return buildable;
  }
  

}