package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBindingBuilder extends ServiceBindingFluent<ServiceBindingBuilder> implements VisitableBuilder<ServiceBinding,ServiceBindingBuilder>{
  public ServiceBindingBuilder() {
    this(new ServiceBinding());
  }
  
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent) {
    this(fluent, new ServiceBinding());
  }
  
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent,ServiceBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBindingBuilder(ServiceBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBindingFluent<?> fluent;
  
  public ServiceBinding build() {
    ServiceBinding buildable = new ServiceBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}