package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceInstanceSpecFluent<A extends ServiceInstanceSpecFluent<A>> extends BaseFluent<A>{
  public ServiceInstanceSpecFluent() {
  }
  
  public ServiceInstanceSpecFluent(ServiceInstanceSpec instance) {
    this.copyInstance(instance);
  }
  private String clusterServiceClassExternalID;
  private String clusterServiceClassExternalName;
  private String clusterServiceClassName;
  private ClusterObjectReferenceBuilder clusterServiceClassRef;
  private String clusterServicePlanExternalID;
  private String clusterServicePlanExternalName;
  private String clusterServicePlanName;
  private ClusterObjectReferenceBuilder clusterServicePlanRef;
  private String externalID;
  private Map<String,Object> parameters;
  private ArrayList<ParametersFromSourceBuilder> parametersFrom = new ArrayList<ParametersFromSourceBuilder>();
  private String serviceClassExternalID;
  private String serviceClassExternalName;
  private String serviceClassName;
  private LocalObjectReferenceBuilder serviceClassRef;
  private String servicePlanExternalID;
  private String servicePlanExternalName;
  private String servicePlanName;
  private LocalObjectReferenceBuilder servicePlanRef;
  private Long updateRequests;
  private UserInfoBuilder userInfo;
  
  protected void copyInstance(ServiceInstanceSpec instance) {
    instance = (instance != null ? instance : new ServiceInstanceSpec());
    if (instance != null) {
          this.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
          this.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
          this.withClusterServiceClassName(instance.getClusterServiceClassName());
          this.withClusterServiceClassRef(instance.getClusterServiceClassRef());
          this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
          this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
          this.withClusterServicePlanName(instance.getClusterServicePlanName());
          this.withClusterServicePlanRef(instance.getClusterServicePlanRef());
          this.withExternalID(instance.getExternalID());
          this.withParameters(instance.getParameters());
          this.withParametersFrom(instance.getParametersFrom());
          this.withServiceClassExternalID(instance.getServiceClassExternalID());
          this.withServiceClassExternalName(instance.getServiceClassExternalName());
          this.withServiceClassName(instance.getServiceClassName());
          this.withServiceClassRef(instance.getServiceClassRef());
          this.withServicePlanExternalID(instance.getServicePlanExternalID());
          this.withServicePlanExternalName(instance.getServicePlanExternalName());
          this.withServicePlanName(instance.getServicePlanName());
          this.withServicePlanRef(instance.getServicePlanRef());
          this.withUpdateRequests(instance.getUpdateRequests());
          this.withUserInfo(instance.getUserInfo());
          this.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
          this.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
          this.withClusterServiceClassName(instance.getClusterServiceClassName());
          this.withClusterServiceClassRef(instance.getClusterServiceClassRef());
          this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
          this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
          this.withClusterServicePlanName(instance.getClusterServicePlanName());
          this.withClusterServicePlanRef(instance.getClusterServicePlanRef());
          this.withExternalID(instance.getExternalID());
          this.withParameters(instance.getParameters());
          this.withParametersFrom(instance.getParametersFrom());
          this.withServiceClassExternalID(instance.getServiceClassExternalID());
          this.withServiceClassExternalName(instance.getServiceClassExternalName());
          this.withServiceClassName(instance.getServiceClassName());
          this.withServiceClassRef(instance.getServiceClassRef());
          this.withServicePlanExternalID(instance.getServicePlanExternalID());
          this.withServicePlanExternalName(instance.getServicePlanExternalName());
          this.withServicePlanName(instance.getServicePlanName());
          this.withServicePlanRef(instance.getServicePlanRef());
          this.withUpdateRequests(instance.getUpdateRequests());
          this.withUserInfo(instance.getUserInfo());
        }
  }
  
  public String getClusterServiceClassExternalID() {
    return this.clusterServiceClassExternalID;
  }
  
  public A withClusterServiceClassExternalID(String clusterServiceClassExternalID) {
    this.clusterServiceClassExternalID = clusterServiceClassExternalID;
    return (A) this;
  }
  
  public boolean hasClusterServiceClassExternalID() {
    return this.clusterServiceClassExternalID != null;
  }
  
  public String getClusterServiceClassExternalName() {
    return this.clusterServiceClassExternalName;
  }
  
  public A withClusterServiceClassExternalName(String clusterServiceClassExternalName) {
    this.clusterServiceClassExternalName = clusterServiceClassExternalName;
    return (A) this;
  }
  
  public boolean hasClusterServiceClassExternalName() {
    return this.clusterServiceClassExternalName != null;
  }
  
  public String getClusterServiceClassName() {
    return this.clusterServiceClassName;
  }
  
  public A withClusterServiceClassName(String clusterServiceClassName) {
    this.clusterServiceClassName = clusterServiceClassName;
    return (A) this;
  }
  
  public boolean hasClusterServiceClassName() {
    return this.clusterServiceClassName != null;
  }
  
  public ClusterObjectReference buildClusterServiceClassRef() {
    return this.clusterServiceClassRef != null ? this.clusterServiceClassRef.build() : null;
  }
  
  public A withClusterServiceClassRef(ClusterObjectReference clusterServiceClassRef) {
    this._visitables.remove(this.clusterServiceClassRef);
    if (clusterServiceClassRef != null) {
        this.clusterServiceClassRef = new ClusterObjectReferenceBuilder(clusterServiceClassRef);
        this._visitables.get("clusterServiceClassRef").add(this.clusterServiceClassRef);
    } else {
        this.clusterServiceClassRef = null;
        this._visitables.get("clusterServiceClassRef").remove(this.clusterServiceClassRef);
    }
    return (A) this;
  }
  
  public boolean hasClusterServiceClassRef() {
    return this.clusterServiceClassRef != null;
  }
  
  public A withNewClusterServiceClassRef(String name) {
    return (A)withClusterServiceClassRef(new ClusterObjectReference(name));
  }
  
  public ClusterServiceClassRefNested<A> withNewClusterServiceClassRef() {
    return new ClusterServiceClassRefNested(null);
  }
  
  public ClusterServiceClassRefNested<A> withNewClusterServiceClassRefLike(ClusterObjectReference item) {
    return new ClusterServiceClassRefNested(item);
  }
  
  public ClusterServiceClassRefNested<A> editClusterServiceClassRef() {
    return withNewClusterServiceClassRefLike(java.util.Optional.ofNullable(buildClusterServiceClassRef()).orElse(null));
  }
  
  public ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRef() {
    return withNewClusterServiceClassRefLike(java.util.Optional.ofNullable(buildClusterServiceClassRef()).orElse(new ClusterObjectReferenceBuilder().build()));
  }
  
  public ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRefLike(ClusterObjectReference item) {
    return withNewClusterServiceClassRefLike(java.util.Optional.ofNullable(buildClusterServiceClassRef()).orElse(item));
  }
  
  public String getClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID;
  }
  
  public A withClusterServicePlanExternalID(String clusterServicePlanExternalID) {
    this.clusterServicePlanExternalID = clusterServicePlanExternalID;
    return (A) this;
  }
  
  public boolean hasClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID != null;
  }
  
  public String getClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName;
  }
  
  public A withClusterServicePlanExternalName(String clusterServicePlanExternalName) {
    this.clusterServicePlanExternalName = clusterServicePlanExternalName;
    return (A) this;
  }
  
  public boolean hasClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName != null;
  }
  
  public String getClusterServicePlanName() {
    return this.clusterServicePlanName;
  }
  
  public A withClusterServicePlanName(String clusterServicePlanName) {
    this.clusterServicePlanName = clusterServicePlanName;
    return (A) this;
  }
  
  public boolean hasClusterServicePlanName() {
    return this.clusterServicePlanName != null;
  }
  
  public ClusterObjectReference buildClusterServicePlanRef() {
    return this.clusterServicePlanRef != null ? this.clusterServicePlanRef.build() : null;
  }
  
  public A withClusterServicePlanRef(ClusterObjectReference clusterServicePlanRef) {
    this._visitables.remove(this.clusterServicePlanRef);
    if (clusterServicePlanRef != null) {
        this.clusterServicePlanRef = new ClusterObjectReferenceBuilder(clusterServicePlanRef);
        this._visitables.get("clusterServicePlanRef").add(this.clusterServicePlanRef);
    } else {
        this.clusterServicePlanRef = null;
        this._visitables.get("clusterServicePlanRef").remove(this.clusterServicePlanRef);
    }
    return (A) this;
  }
  
  public boolean hasClusterServicePlanRef() {
    return this.clusterServicePlanRef != null;
  }
  
  public A withNewClusterServicePlanRef(String name) {
    return (A)withClusterServicePlanRef(new ClusterObjectReference(name));
  }
  
  public ClusterServicePlanRefNested<A> withNewClusterServicePlanRef() {
    return new ClusterServicePlanRefNested(null);
  }
  
  public ClusterServicePlanRefNested<A> withNewClusterServicePlanRefLike(ClusterObjectReference item) {
    return new ClusterServicePlanRefNested(item);
  }
  
  public ClusterServicePlanRefNested<A> editClusterServicePlanRef() {
    return withNewClusterServicePlanRefLike(java.util.Optional.ofNullable(buildClusterServicePlanRef()).orElse(null));
  }
  
  public ClusterServicePlanRefNested<A> editOrNewClusterServicePlanRef() {
    return withNewClusterServicePlanRefLike(java.util.Optional.ofNullable(buildClusterServicePlanRef()).orElse(new ClusterObjectReferenceBuilder().build()));
  }
  
  public ClusterServicePlanRefNested<A> editOrNewClusterServicePlanRefLike(ClusterObjectReference item) {
    return withNewClusterServicePlanRefLike(java.util.Optional.ofNullable(buildClusterServicePlanRef()).orElse(item));
  }
  
  public String getExternalID() {
    return this.externalID;
  }
  
  public A withExternalID(String externalID) {
    this.externalID = externalID;
    return (A) this;
  }
  
  public boolean hasExternalID() {
    return this.externalID != null;
  }
  
  public A addToParameters(String key,Object value) {
    if(this.parameters == null && key != null && value != null) { this.parameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
  }
  
  public A addToParameters(Map<String,Object> map) {
    if(this.parameters == null && map != null) { this.parameters = new LinkedHashMap(); }
    if(map != null) { this.parameters.putAll(map);} return (A)this;
  }
  
  public A removeFromParameters(String key) {
    if(this.parameters == null) { return (A) this; }
    if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
  }
  
  public A removeFromParameters(Map<String,Object> map) {
    if(this.parameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getParameters() {
    return this.parameters;
  }
  
  public <K,V>A withParameters(Map<String,Object> parameters) {
    if (parameters == null) {
      this.parameters = null;
    } else {
      this.parameters = new LinkedHashMap(parameters);
    }
    return (A) this;
  }
  
  public boolean hasParameters() {
    return this.parameters != null;
  }
  
  public A addToParametersFrom(int index,ParametersFromSource item) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
    if (index < 0 || index >= parametersFrom.size()) { _visitables.get("parametersFrom").add(builder); parametersFrom.add(builder); } else { _visitables.get("parametersFrom").add(index, builder); parametersFrom.add(index, builder);}
    return (A)this;
  }
  
  public A setToParametersFrom(int index,ParametersFromSource item) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
    if (index < 0 || index >= parametersFrom.size()) { _visitables.get("parametersFrom").add(builder); parametersFrom.add(builder); } else { _visitables.get("parametersFrom").set(index, builder); parametersFrom.set(index, builder);}
    return (A)this;
  }
  
  public A addToParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").add(builder);this.parametersFrom.add(builder);} return (A)this;
  }
  
  public A addAllToParametersFrom(Collection<ParametersFromSource> items) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").add(builder);this.parametersFrom.add(builder);} return (A)this;
  }
  
  public A removeFromParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items) {
    if (this.parametersFrom == null) return (A)this;
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").remove(builder); this.parametersFrom.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParametersFrom(Collection<ParametersFromSource> items) {
    if (this.parametersFrom == null) return (A)this;
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").remove(builder); this.parametersFrom.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
    if (parametersFrom == null) return (A) this;
    final Iterator<ParametersFromSourceBuilder> each = parametersFrom.iterator();
    final List visitables = _visitables.get("parametersFrom");
    while (each.hasNext()) {
      ParametersFromSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ParametersFromSource> buildParametersFrom() {
    return this.parametersFrom != null ? build(parametersFrom) : null;
  }
  
  public ParametersFromSource buildParametersFrom(int index) {
    return this.parametersFrom.get(index).build();
  }
  
  public ParametersFromSource buildFirstParametersFrom() {
    return this.parametersFrom.get(0).build();
  }
  
  public ParametersFromSource buildLastParametersFrom() {
    return this.parametersFrom.get(parametersFrom.size() - 1).build();
  }
  
  public ParametersFromSource buildMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
      for (ParametersFromSourceBuilder item : parametersFrom) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
      for (ParametersFromSourceBuilder item : parametersFrom) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParametersFrom(List<ParametersFromSource> parametersFrom) {
    if (this.parametersFrom != null) {
      this._visitables.get("parametersFrom").clear();
    }
    if (parametersFrom != null) {
        this.parametersFrom = new ArrayList();
        for (ParametersFromSource item : parametersFrom) {
          this.addToParametersFrom(item);
        }
    } else {
      this.parametersFrom = null;
    }
    return (A) this;
  }
  
  public A withParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... parametersFrom) {
    if (this.parametersFrom != null) {this.parametersFrom.clear(); _visitables.remove("parametersFrom"); }
    if (parametersFrom != null) {for (ParametersFromSource item :parametersFrom){ this.addToParametersFrom(item);}} return (A) this;
  }
  
  public boolean hasParametersFrom() {
    return this.parametersFrom != null && !this.parametersFrom.isEmpty();
  }
  
  public ParametersFromNested<A> addNewParametersFrom() {
    return new ParametersFromNested(-1, null);
  }
  
  public ParametersFromNested<A> addNewParametersFromLike(ParametersFromSource item) {
    return new ParametersFromNested(-1, item);
  }
  
  public ParametersFromNested<A> setNewParametersFromLike(int index,ParametersFromSource item) {
    return new ParametersFromNested(index, item);
  }
  
  public ParametersFromNested<A> editParametersFrom(int index) {
    if (parametersFrom.size() <= index) throw new RuntimeException("Can't edit parametersFrom. Index exceeds size.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  
  public ParametersFromNested<A> editFirstParametersFrom() {
    if (parametersFrom.size() == 0) throw new RuntimeException("Can't edit first parametersFrom. The list is empty.");
    return setNewParametersFromLike(0, buildParametersFrom(0));
  }
  
  public ParametersFromNested<A> editLastParametersFrom() {
    int index = parametersFrom.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parametersFrom. The list is empty.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  
  public ParametersFromNested<A> editMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parametersFrom.size();i++) { 
    if (predicate.test(parametersFrom.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parametersFrom. No match found.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  
  public String getServiceClassExternalID() {
    return this.serviceClassExternalID;
  }
  
  public A withServiceClassExternalID(String serviceClassExternalID) {
    this.serviceClassExternalID = serviceClassExternalID;
    return (A) this;
  }
  
  public boolean hasServiceClassExternalID() {
    return this.serviceClassExternalID != null;
  }
  
  public String getServiceClassExternalName() {
    return this.serviceClassExternalName;
  }
  
  public A withServiceClassExternalName(String serviceClassExternalName) {
    this.serviceClassExternalName = serviceClassExternalName;
    return (A) this;
  }
  
  public boolean hasServiceClassExternalName() {
    return this.serviceClassExternalName != null;
  }
  
  public String getServiceClassName() {
    return this.serviceClassName;
  }
  
  public A withServiceClassName(String serviceClassName) {
    this.serviceClassName = serviceClassName;
    return (A) this;
  }
  
  public boolean hasServiceClassName() {
    return this.serviceClassName != null;
  }
  
  public LocalObjectReference buildServiceClassRef() {
    return this.serviceClassRef != null ? this.serviceClassRef.build() : null;
  }
  
  public A withServiceClassRef(LocalObjectReference serviceClassRef) {
    this._visitables.remove(this.serviceClassRef);
    if (serviceClassRef != null) {
        this.serviceClassRef = new LocalObjectReferenceBuilder(serviceClassRef);
        this._visitables.get("serviceClassRef").add(this.serviceClassRef);
    } else {
        this.serviceClassRef = null;
        this._visitables.get("serviceClassRef").remove(this.serviceClassRef);
    }
    return (A) this;
  }
  
  public boolean hasServiceClassRef() {
    return this.serviceClassRef != null;
  }
  
  public A withNewServiceClassRef(String name) {
    return (A)withServiceClassRef(new LocalObjectReference(name));
  }
  
  public ServiceClassRefNested<A> withNewServiceClassRef() {
    return new ServiceClassRefNested(null);
  }
  
  public ServiceClassRefNested<A> withNewServiceClassRefLike(LocalObjectReference item) {
    return new ServiceClassRefNested(item);
  }
  
  public ServiceClassRefNested<A> editServiceClassRef() {
    return withNewServiceClassRefLike(java.util.Optional.ofNullable(buildServiceClassRef()).orElse(null));
  }
  
  public ServiceClassRefNested<A> editOrNewServiceClassRef() {
    return withNewServiceClassRefLike(java.util.Optional.ofNullable(buildServiceClassRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ServiceClassRefNested<A> editOrNewServiceClassRefLike(LocalObjectReference item) {
    return withNewServiceClassRefLike(java.util.Optional.ofNullable(buildServiceClassRef()).orElse(item));
  }
  
  public String getServicePlanExternalID() {
    return this.servicePlanExternalID;
  }
  
  public A withServicePlanExternalID(String servicePlanExternalID) {
    this.servicePlanExternalID = servicePlanExternalID;
    return (A) this;
  }
  
  public boolean hasServicePlanExternalID() {
    return this.servicePlanExternalID != null;
  }
  
  public String getServicePlanExternalName() {
    return this.servicePlanExternalName;
  }
  
  public A withServicePlanExternalName(String servicePlanExternalName) {
    this.servicePlanExternalName = servicePlanExternalName;
    return (A) this;
  }
  
  public boolean hasServicePlanExternalName() {
    return this.servicePlanExternalName != null;
  }
  
  public String getServicePlanName() {
    return this.servicePlanName;
  }
  
  public A withServicePlanName(String servicePlanName) {
    this.servicePlanName = servicePlanName;
    return (A) this;
  }
  
  public boolean hasServicePlanName() {
    return this.servicePlanName != null;
  }
  
  public LocalObjectReference buildServicePlanRef() {
    return this.servicePlanRef != null ? this.servicePlanRef.build() : null;
  }
  
  public A withServicePlanRef(LocalObjectReference servicePlanRef) {
    this._visitables.remove(this.servicePlanRef);
    if (servicePlanRef != null) {
        this.servicePlanRef = new LocalObjectReferenceBuilder(servicePlanRef);
        this._visitables.get("servicePlanRef").add(this.servicePlanRef);
    } else {
        this.servicePlanRef = null;
        this._visitables.get("servicePlanRef").remove(this.servicePlanRef);
    }
    return (A) this;
  }
  
  public boolean hasServicePlanRef() {
    return this.servicePlanRef != null;
  }
  
  public A withNewServicePlanRef(String name) {
    return (A)withServicePlanRef(new LocalObjectReference(name));
  }
  
  public ServicePlanRefNested<A> withNewServicePlanRef() {
    return new ServicePlanRefNested(null);
  }
  
  public ServicePlanRefNested<A> withNewServicePlanRefLike(LocalObjectReference item) {
    return new ServicePlanRefNested(item);
  }
  
  public ServicePlanRefNested<A> editServicePlanRef() {
    return withNewServicePlanRefLike(java.util.Optional.ofNullable(buildServicePlanRef()).orElse(null));
  }
  
  public ServicePlanRefNested<A> editOrNewServicePlanRef() {
    return withNewServicePlanRefLike(java.util.Optional.ofNullable(buildServicePlanRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ServicePlanRefNested<A> editOrNewServicePlanRefLike(LocalObjectReference item) {
    return withNewServicePlanRefLike(java.util.Optional.ofNullable(buildServicePlanRef()).orElse(item));
  }
  
  public Long getUpdateRequests() {
    return this.updateRequests;
  }
  
  public A withUpdateRequests(Long updateRequests) {
    this.updateRequests = updateRequests;
    return (A) this;
  }
  
  public boolean hasUpdateRequests() {
    return this.updateRequests != null;
  }
  
  public UserInfo buildUserInfo() {
    return this.userInfo != null ? this.userInfo.build() : null;
  }
  
  public A withUserInfo(UserInfo userInfo) {
    this._visitables.remove(this.userInfo);
    if (userInfo != null) {
        this.userInfo = new UserInfoBuilder(userInfo);
        this._visitables.get("userInfo").add(this.userInfo);
    } else {
        this.userInfo = null;
        this._visitables.get("userInfo").remove(this.userInfo);
    }
    return (A) this;
  }
  
  public boolean hasUserInfo() {
    return this.userInfo != null;
  }
  
  public UserInfoNested<A> withNewUserInfo() {
    return new UserInfoNested(null);
  }
  
  public UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
    return new UserInfoNested(item);
  }
  
  public UserInfoNested<A> editUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(null));
  }
  
  public UserInfoNested<A> editOrNewUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(new UserInfoBuilder().build()));
  }
  
  public UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceSpecFluent that = (ServiceInstanceSpecFluent) o;
    if (!java.util.Objects.equals(clusterServiceClassExternalID, that.clusterServiceClassExternalID)) return false;
    if (!java.util.Objects.equals(clusterServiceClassExternalName, that.clusterServiceClassExternalName)) return false;
    if (!java.util.Objects.equals(clusterServiceClassName, that.clusterServiceClassName)) return false;
    if (!java.util.Objects.equals(clusterServiceClassRef, that.clusterServiceClassRef)) return false;
    if (!java.util.Objects.equals(clusterServicePlanExternalID, that.clusterServicePlanExternalID)) return false;
    if (!java.util.Objects.equals(clusterServicePlanExternalName, that.clusterServicePlanExternalName)) return false;
    if (!java.util.Objects.equals(clusterServicePlanName, that.clusterServicePlanName)) return false;
    if (!java.util.Objects.equals(clusterServicePlanRef, that.clusterServicePlanRef)) return false;
    if (!java.util.Objects.equals(externalID, that.externalID)) return false;
    if (!java.util.Objects.equals(parameters, that.parameters)) return false;
    if (!java.util.Objects.equals(parametersFrom, that.parametersFrom)) return false;
    if (!java.util.Objects.equals(serviceClassExternalID, that.serviceClassExternalID)) return false;
    if (!java.util.Objects.equals(serviceClassExternalName, that.serviceClassExternalName)) return false;
    if (!java.util.Objects.equals(serviceClassName, that.serviceClassName)) return false;
    if (!java.util.Objects.equals(serviceClassRef, that.serviceClassRef)) return false;
    if (!java.util.Objects.equals(servicePlanExternalID, that.servicePlanExternalID)) return false;
    if (!java.util.Objects.equals(servicePlanExternalName, that.servicePlanExternalName)) return false;
    if (!java.util.Objects.equals(servicePlanName, that.servicePlanName)) return false;
    if (!java.util.Objects.equals(servicePlanRef, that.servicePlanRef)) return false;
    if (!java.util.Objects.equals(updateRequests, that.updateRequests)) return false;
    if (!java.util.Objects.equals(userInfo, that.userInfo)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterServiceClassExternalID,  clusterServiceClassExternalName,  clusterServiceClassName,  clusterServiceClassRef,  clusterServicePlanExternalID,  clusterServicePlanExternalName,  clusterServicePlanName,  clusterServicePlanRef,  externalID,  parameters,  parametersFrom,  serviceClassExternalID,  serviceClassExternalName,  serviceClassName,  serviceClassRef,  servicePlanExternalID,  servicePlanExternalName,  servicePlanName,  servicePlanRef,  updateRequests,  userInfo,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterServiceClassExternalID != null) { sb.append("clusterServiceClassExternalID:"); sb.append(clusterServiceClassExternalID + ","); }
    if (clusterServiceClassExternalName != null) { sb.append("clusterServiceClassExternalName:"); sb.append(clusterServiceClassExternalName + ","); }
    if (clusterServiceClassName != null) { sb.append("clusterServiceClassName:"); sb.append(clusterServiceClassName + ","); }
    if (clusterServiceClassRef != null) { sb.append("clusterServiceClassRef:"); sb.append(clusterServiceClassRef + ","); }
    if (clusterServicePlanExternalID != null) { sb.append("clusterServicePlanExternalID:"); sb.append(clusterServicePlanExternalID + ","); }
    if (clusterServicePlanExternalName != null) { sb.append("clusterServicePlanExternalName:"); sb.append(clusterServicePlanExternalName + ","); }
    if (clusterServicePlanName != null) { sb.append("clusterServicePlanName:"); sb.append(clusterServicePlanName + ","); }
    if (clusterServicePlanRef != null) { sb.append("clusterServicePlanRef:"); sb.append(clusterServicePlanRef + ","); }
    if (externalID != null) { sb.append("externalID:"); sb.append(externalID + ","); }
    if (parameters != null && !parameters.isEmpty()) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (parametersFrom != null && !parametersFrom.isEmpty()) { sb.append("parametersFrom:"); sb.append(parametersFrom + ","); }
    if (serviceClassExternalID != null) { sb.append("serviceClassExternalID:"); sb.append(serviceClassExternalID + ","); }
    if (serviceClassExternalName != null) { sb.append("serviceClassExternalName:"); sb.append(serviceClassExternalName + ","); }
    if (serviceClassName != null) { sb.append("serviceClassName:"); sb.append(serviceClassName + ","); }
    if (serviceClassRef != null) { sb.append("serviceClassRef:"); sb.append(serviceClassRef + ","); }
    if (servicePlanExternalID != null) { sb.append("servicePlanExternalID:"); sb.append(servicePlanExternalID + ","); }
    if (servicePlanExternalName != null) { sb.append("servicePlanExternalName:"); sb.append(servicePlanExternalName + ","); }
    if (servicePlanName != null) { sb.append("servicePlanName:"); sb.append(servicePlanName + ","); }
    if (servicePlanRef != null) { sb.append("servicePlanRef:"); sb.append(servicePlanRef + ","); }
    if (updateRequests != null) { sb.append("updateRequests:"); sb.append(updateRequests + ","); }
    if (userInfo != null) { sb.append("userInfo:"); sb.append(userInfo); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterServiceClassRefNested<N> extends ClusterObjectReferenceFluent<ClusterServiceClassRefNested<N>> implements Nested<N>{
    ClusterServiceClassRefNested(ClusterObjectReference item) {
      this.builder = new ClusterObjectReferenceBuilder(this, item);
    }
    ClusterObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ServiceInstanceSpecFluent.this.withClusterServiceClassRef(builder.build());
    }
    
    public N endClusterServiceClassRef() {
      return and();
    }
    
  
  }
  public class ClusterServicePlanRefNested<N> extends ClusterObjectReferenceFluent<ClusterServicePlanRefNested<N>> implements Nested<N>{
    ClusterServicePlanRefNested(ClusterObjectReference item) {
      this.builder = new ClusterObjectReferenceBuilder(this, item);
    }
    ClusterObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ServiceInstanceSpecFluent.this.withClusterServicePlanRef(builder.build());
    }
    
    public N endClusterServicePlanRef() {
      return and();
    }
    
  
  }
  public class ParametersFromNested<N> extends ParametersFromSourceFluent<ParametersFromNested<N>> implements Nested<N>{
    ParametersFromNested(int index,ParametersFromSource item) {
      this.index = index;
      this.builder = new ParametersFromSourceBuilder(this, item);
    }
    ParametersFromSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceInstanceSpecFluent.this.setToParametersFrom(index,builder.build());
    }
    
    public N endParametersFrom() {
      return and();
    }
    
  
  }
  public class ServiceClassRefNested<N> extends LocalObjectReferenceFluent<ServiceClassRefNested<N>> implements Nested<N>{
    ServiceClassRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ServiceInstanceSpecFluent.this.withServiceClassRef(builder.build());
    }
    
    public N endServiceClassRef() {
      return and();
    }
    
  
  }
  public class ServicePlanRefNested<N> extends LocalObjectReferenceFluent<ServicePlanRefNested<N>> implements Nested<N>{
    ServicePlanRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ServiceInstanceSpecFluent.this.withServicePlanRef(builder.build());
    }
    
    public N endServicePlanRef() {
      return and();
    }
    
  
  }
  public class UserInfoNested<N> extends UserInfoFluent<UserInfoNested<N>> implements Nested<N>{
    UserInfoNested(UserInfo item) {
      this.builder = new UserInfoBuilder(this, item);
    }
    UserInfoBuilder builder;
    
    public N and() {
      return (N) ServiceInstanceSpecFluent.this.withUserInfo(builder.build());
    }
    
    public N endUserInfo() {
      return and();
    }
    
  
  }

}