/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

@CacheableTask
public abstract class PostCompile
extends DefaultTask
implements LombokTask {
    @Inject
    protected abstract ExecOperations getExecOperations();

    @Override
    @Nested
    @Optional
    public abstract Property<JavaLauncher> getLauncher();

    @Override
    @Classpath
    public abstract ConfigurableFileCollection getLombokClasspath();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public abstract ConfigurableFileCollection getClassFiles();

    @Console
    public abstract Property<Boolean> getVerbose();

    public PostCompile() {
        this.getVerbose().convention((Object)false);
    }

    @TaskAction
    public void postCompile() {
        this.getExecOperations().javaexec(postCompile -> {
            if (this.getLauncher().isPresent()) {
                postCompile.setExecutable(((JavaLauncher)this.getLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath());
            }
            postCompile.setClasspath((FileCollection)this.getLombokClasspath());
            postCompile.getMainClass().set((Object)"lombok.launch.Main");
            postCompile.args(new Object[]{"post-compile"});
            if (((Boolean)this.getVerbose().get()).booleanValue()) {
                postCompile.args(new Object[]{"--verbose"});
            }
            this.getClassFiles().forEach(file -> postCompile.args(new Object[]{file.getAbsolutePath()}));
        });
    }
}

