/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.component;

import io.gatling.charts.component.Component;
import io.gatling.charts.stats.RunInfo;
import io.gatling.charts.util.HtmlHelper$;
import io.gatling.charts.util.HtmlHelper$HtmlRichString$;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)3Qa\u0002\u0005\u0003\u0015AA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!)A\u0006\u0001C\u0001[!)\u0011\u0007\u0001C!e!)a\b\u0001C!e!)q\b\u0001C!\u0001\n92+[7vY\u0006$\u0018n\u001c8DCJ$7i\\7q_:,g\u000e\u001e\u0006\u0003\u0013)\t\u0011bY8na>tWM\u001c;\u000b\u0005-a\u0011AB2iCJ$8O\u0003\u0002\u000e\u001d\u00059q-\u0019;mS:<'\"A\b\u0002\u0005%|7c\u0001\u0001\u0012/A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\r\u000e\u0003!I!A\u0007\u0005\u0003\u0013\r{W\u000e]8oK:$\u0018a\u0002:v]&sgm\\\u0002\u0001!\tq\u0012%D\u0001 \u0015\t\u0001#\"A\u0003ti\u0006$8/\u0003\u0002#?\t9!+\u001e8J]\u001a|\u0017A\u0002>p]\u0016LE\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!A/[7f\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\ri{g.Z%e\u0003\u0019a\u0014N\\5u}Q\u0019af\f\u0019\u0011\u0005a\u0001\u0001\"B\u000e\u0004\u0001\u0004i\u0002\"B\u0012\u0004\u0001\u0004!\u0013\u0001\u00025u[2,\u0012a\r\t\u0003imr!!N\u001d\u0011\u0005Y\u001aR\"A\u001c\u000b\u0005ab\u0012A\u0002\u001fs_>$h(\u0003\u0002;'\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ4#\u0001\u0002kg\u00069!n\u001d$jY\u0016\u001cX#A!\u0011\u0007\t;5G\u0004\u0002D\u000b:\u0011a\u0007R\u0005\u0002)%\u0011aiE\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015JA\u0002TKFT!AR\n")
public final class SimulationCardComponent
implements Component {
    private final RunInfo runInfo;
    private final ZoneId zoneId;

    @Override
    public String html() {
        String printableRunDateTime = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss O").withZone(this.zoneId).format(Instant.ofEpochMilli(this.runInfo.injectStart()));
        String printableGatlingReleaseDate = GatlingVersion$.MODULE$.ThisVersion().releaseDate().toLocalDate().toString();
        Duration duration = Duration.ofMillis(this.runInfo.injectEnd() - this.runInfo.injectStart());
        long days = duration.toDays();
        Duration minusDays = duration.minusDays(days);
        long hours = minusDays.toHours();
        Duration minusHours = minusDays.minusHours(hours);
        long minutes = minusHours.toMinutes();
        long seconds = minusHours.minusMinutes(minutes).getSeconds();
        String printableDuration = (String)(days > 0L ? days + "d " : "") + (hours > 0L ? hours + "h " : (days > 0L ? "0h" : "")) + (minutes > 0L ? minutes + "m " : (days > 0L || hours > 0L ? "0m" : "")) + (seconds > 0L ? seconds + "s " : "0s");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<div class=\"simulation-card\">\n       |  <div class=\"simulation-version-information\">\n       |  <span class=\"simulation-information-title\">Gatling Version</span>\n       |    <span class=\"simulation-information-item\">\n       |      <span class=\"simulation-information-label\">Version: </span>\n       |      <span>" + GatlingVersion$.MODULE$.ThisVersion().fullVersion() + "</span>\n       |    </span>\n       |    <span class=\"simulation-information-item\">\n       |      <span class=\"simulation-information-label\">Released: </span>\n       |      <span>" + printableGatlingReleaseDate + "</span>\n       |    </span>\n       |  </div>\n       |  <div id=\"simulation-information\" class=\"simulation-version-information\">\n       |    <span class=\"simulation-information-title\">Run Information</span>\n       |    <div class=\"simulation-information-container\">\n       |      <span class=\"simulation-information-item\">\n       |        <span class=\"simulation-information-label\">Date: </span>\n       |        <span>" + printableRunDateTime + "</span>\n       |      </span>\n       |      <span class=\"simulation-information-item\">\n       |        <span class=\"simulation-information-label\">Duration: </span>\n       |        <span>" + printableDuration + "</span>\n       |      </span>\n       |      " + (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.runInfo.runDescription())) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<span class=\"simulation-tooltip simulation-information-item description\" title=\"Description\" data-content=\"" + HtmlHelper$HtmlRichString$.MODULE$.htmlEscape$extension(HtmlHelper$.MODULE$.HtmlRichString(this.runInfo.runDescription())) + "\">\n           |        <span class=\"simulation-information-label\">Description: </span>\n           |        <span>" + HtmlHelper$HtmlRichString$.MODULE$.htmlEscape$extension(HtmlHelper$.MODULE$.HtmlRichString(StringHelper.RichString$.MODULE$.truncate$extension(StringHelper$.MODULE$.RichString(this.runInfo.runDescription()), 2300))) + "</span>\n           |      </span>\n           |")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<span class=\"simulation-information-item\">\n          |        <span class=\"simulation-information-label\">Description: </span>\n          |        <span>&mdash;</span>\n          |      </span>\n          |"))) + "\n       |    </div>\n       |  </div>\n       |</div>"));
    }

    @Override
    public String js() {
        return "";
    }

    @Override
    public Seq<String> jsFiles() {
        return Nil$.MODULE$;
    }

    public SimulationCardComponent(RunInfo runInfo, ZoneId zoneId) {
        this.runInfo = runInfo;
        this.zoneId = zoneId;
    }
}

