/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats.buffers;

import io.gatling.charts.stats.IntVsTimePlot;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005I4Qa\u0006\r\u00035\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0004>\u0001\t\u0007I\u0011\u0002 \t\r}\u0002\u0001\u0015!\u00034\u0011\u001d\u0001\u0005\u00011A\u0005\nyBq!\u0011\u0001A\u0002\u0013%!\t\u0003\u0004I\u0001\u0001\u0006Ka\r\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019Y\u0005\u0001)A\u0005a!9A\n\u0001b\u0001\n\u0013Q\u0005BB'\u0001A\u0003%\u0001\u0007C\u0004O\u0001\t\u0007I\u0011\u0002&\t\r=\u0003\u0001\u0015!\u00031\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015y\u0007\u0001\"\u0001_\u0011\u0015\u0001\b\u0001\"\u0001r\u0005=\u0019Vm]:j_:\u001cu.\u001e8uKJ\u001c(BA\r\u001b\u0003\u001d\u0011WO\u001a4feNT!a\u0007\u000f\u0002\u000bM$\u0018\r^:\u000b\u0005uq\u0012AB2iCJ$8O\u0003\u0002 A\u00059q-\u0019;mS:<'\"A\u0011\u0002\u0005%|7C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u0006aQ.\u001b8US6,7\u000f^1na\u000e\u0001\u0001C\u0001\u0013-\u0013\tiSE\u0001\u0003M_:<\u0017\u0001D7bqRKW.Z:uC6\u0004\u0018A\u00042vG.,G\u000fV8NS2d\u0017n\u001d\t\u0004IE\u001a\u0014B\u0001\u001a&\u0005\u0015\t%O]1z!\t!C'\u0003\u00026K\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\u0011A$h\u000f\u001f\u0011\u0005e\u0002Q\"\u0001\r\t\u000b%\"\u0001\u0019A\u0016\t\u000b9\"\u0001\u0019A\u0016\t\u000b=\"\u0001\u0019\u0001\u0019\u0002'\t,8m[3u/&$G\u000f[%o\u001b&dG.[:\u0016\u0003M\nACY;dW\u0016$x+\u001b3uQ&sW*\u001b7mSN\u0004\u0013!D2veJ,g\u000e\u001e\"vM\u001a,'/A\tdkJ\u0014XM\u001c;Ck\u001a4WM]0%KF$\"a\u0011$\u0011\u0005\u0011\"\u0015BA#&\u0005\u0011)f.\u001b;\t\u000f\u001dC\u0011\u0011!a\u0001g\u0005\u0019\u0001\u0010J\u0019\u0002\u001d\r,(O]3oi\n+hMZ3sA\u0005Y1\u000f^1si\u000e{WO\u001c;t+\u0005\u0001\u0014\u0001D:uCJ$8i\\;oiN\u0004\u0013aD2p]\u000e,(O]3oiV\u001bXM]:\u0002!\r|gnY;se\u0016tG/V:feN\u0004\u0013AE7bq\u000e{gnY;se\u0016tG/V:feN\f1#\\1y\u0007>t7-\u001e:sK:$Xk]3sg\u0002\n1#\u001e9eCR,7)\u001e:sK:$()^2lKR$\"a\u0011*\t\u000bM\u0003\u0002\u0019A\u001a\u0002\rM,7m\u001c8e\u0003!\tG\rZ*uCJ$HCA\"W\u0011\u0015\u0019\u0016\u00031\u00014\u0003\u0019\tG\rZ#oIR\u00111)\u0017\u0005\u0006'J\u0001\raM\u0001\u000fg\u0016\u001cwN\u001c3U_\n+8m[3u)\t\u0019D\fC\u0003T'\u0001\u00071'A\nvg\u0016\u00148\u000b^1siJ\u000bG/Z*fe&,7/F\u0001`!\r\u0001\u0007n\u001b\b\u0003C\u001at!AY3\u000e\u0003\rT!\u0001\u001a\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013BA4&\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001b6\u0003\t1K7\u000f\u001e\u0006\u0003O\u0016\u0002\"\u0001\\7\u000e\u0003iI!A\u001c\u000e\u0003\u001b%sGOV:US6,\u0007\u000b\\8u\u0003ai\u0017\r_\"p]\u000e,(O]3oiV\u001bXM]:TKJLWm]\u0001\u001dM2,8\u000f\u001b+sC&d\u0017N\\4D_:\u001cWO\u001d:f]R,6/\u001a:t)\u0005\u0019\u0005")
public final class SessionCounters {
    private final int[] bucketToMillis;
    private final int bucketWidthInMillis;
    private int currentBuffer;
    private final int[] startCounts;
    private final int[] concurrentUsers;
    private final int[] maxConcurrentUsers;

    private int bucketWidthInMillis() {
        return this.bucketWidthInMillis;
    }

    private int currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(int x$1) {
        this.currentBuffer = x$1;
    }

    private int[] startCounts() {
        return this.startCounts;
    }

    private int[] concurrentUsers() {
        return this.concurrentUsers;
    }

    private int[] maxConcurrentUsers() {
        return this.maxConcurrentUsers;
    }

    private void updateCurrentBucket(int second) {
        int bucket = this.secondToBucket(second);
        if (bucket > this.currentBuffer()) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.currentBuffer() + 1), bucket).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                $this.concurrentUsers()[i] = this.concurrentUsers()[this.currentBuffer()];
                $this.maxConcurrentUsers()[i] = this.maxConcurrentUsers()[this.currentBuffer()];
            });
            this.currentBuffer_$eq(bucket);
            return;
        }
    }

    public void addStart(int second) {
        this.updateCurrentBucket(second);
        int n = this.currentBuffer();
        this.startCounts()[n] = this.startCounts()[n] + 1;
        int n2 = this.currentBuffer();
        this.concurrentUsers()[n2] = this.concurrentUsers()[n2] + 1;
        if (this.concurrentUsers()[this.currentBuffer()] > this.maxConcurrentUsers()[this.currentBuffer()]) {
            this.maxConcurrentUsers()[this.currentBuffer()] = this.concurrentUsers()[this.currentBuffer()];
            return;
        }
    }

    public void addEnd(int second) {
        this.updateCurrentBucket(second);
        int n = this.currentBuffer();
        this.concurrentUsers()[n] = this.concurrentUsers()[n] - 1;
    }

    private int secondToBucket(int second) {
        return package$.MODULE$.min(second * 1000 / this.bucketWidthInMillis(), this.bucketToMillis.length - 1);
    }

    public List<IntVsTimePlot> userStartRateSeries() {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.intArrayOps(this.startCounts()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int startCount = tuple2._1$mcI$sp();
                int bucket = tuple2._2$mcI$sp();
                return new IntVsTimePlot($this.bucketToMillis[bucket], (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)startCount * (double)1000 / (double)this.bucketWidthInMillis())));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(IntVsTimePlot.class))).toList();
    }

    public List<IntVsTimePlot> maxConcurrentUsersSeries() {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.intArrayOps(this.maxConcurrentUsers()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int max = tuple2._1$mcI$sp();
                int bucket = tuple2._2$mcI$sp();
                return new IntVsTimePlot($this.bucketToMillis[bucket], max);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(IntVsTimePlot.class))).toList();
    }

    public void flushTrailingConcurrentUsers() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.currentBuffer() + 1), this.bucketToMillis.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            $this.concurrentUsers()[i] = this.concurrentUsers()[this.currentBuffer()];
            $this.maxConcurrentUsers()[i] = this.maxConcurrentUsers()[this.currentBuffer()];
        });
    }

    public SessionCounters(long minTimestamp, long maxTimestamp, int[] bucketToMillis) {
        this.bucketToMillis = bucketToMillis;
        this.bucketWidthInMillis = (int)((maxTimestamp - minTimestamp) / (long)bucketToMillis.length);
        this.currentBuffer = 0;
        this.startCounts = (int[])Array$.MODULE$.fill(bucketToMillis.length, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Int());
        this.concurrentUsers = (int[])Array$.MODULE$.fill(bucketToMillis.length, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Int());
        this.maxConcurrentUsers = (int[])Array$.MODULE$.fill(bucketToMillis.length, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Int());
    }
}

