/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.component.GroupedCount;
import io.gatling.charts.component.RequestStatistics;
import io.gatling.charts.component.Stats;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.GroupContainer$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.template.ConsoleTemplate$;
import io.gatling.charts.template.GlobalStatsJsonTemplate;
import io.gatling.charts.template.StatsJsTemplate;
import io.gatling.commons.shared.unstable.model.stats.GeneralStats;
import io.gatling.commons.shared.unstable.model.stats.Group;
import io.gatling.commons.shared.unstable.model.stats.GroupStatsPath;
import io.gatling.commons.shared.unstable.model.stats.RequestStatsPath;
import io.gatling.commons.shared.unstable.model.stats.StatsPath;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.NumberHelper;
import io.gatling.commons.util.NumberHelper$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00053QAB\u0004\u0001\u0013=A\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!AQ\u0006\u0001B\u0001B\u0003-a\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0003=\u0001\u0011\u0005QH\u0001\u000bTi\u0006$8OU3q_J$x)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0011%\taA]3q_J$(B\u0001\u0006\f\u0003\u0019\u0019\u0007.\u0019:ug*\u0011A\"D\u0001\bO\u0006$H.\u001b8h\u0015\u0005q\u0011AA5p'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012\u0001D:dC2\fGn\\4hS:<'BA\u000e\u001d\u0003!!\u0018\u0010]3tC\u001a,'\"A\u000f\u0002\u0007\r|W.\u0003\u0002 1\ti1\u000b\u001e:jGRdunZ4j]\u001e\fqC]3q_J$8oR3oKJ\fG/[8o\u0013:\u0004X\u000f^:\u0004\u0001A\u00111\u0005J\u0007\u0002\u000f%\u0011Qe\u0002\u0002\u0018%\u0016\u0004xN\u001d;t\u000f\u0016tWM]1uS>t\u0017J\u001c9viN\f1b\u00195beR\u001ch)\u001b7fgB\u0011\u0001fK\u0007\u0002S)\u0011!&C\u0001\u0007G>tg-[4\n\u00051J#aC\"iCJ$8OR5mKN\fQbY8oM&<WO]1uS>t\u0007CA\u00184\u001b\u0005\u0001$B\u0001\u00162\u0015\t\u00114\"\u0001\u0003d_J,\u0017B\u0001\u001b1\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"2a\u000e\u001e<)\tA\u0014\b\u0005\u0002$\u0001!)Q\u0006\u0002a\u0002]!)\u0001\u0005\u0002a\u0001E!)a\u0005\u0002a\u0001O\u0005Aq-\u001a8fe\u0006$X\rF\u0001?!\t\tr(\u0003\u0002A%\t!QK\\5u\u0001")
public class StatsReportGenerator
implements StrictLogging {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void generate() {
        GroupContainer rootContainer = GroupContainer$.MODULE$.root(this.computeRequestStats$1(ChartsFiles$.MODULE$.AllRequestLineTitle(), (Option)None$.MODULE$, (Option)None$.MODULE$));
        List<StatsPath> statsPaths = this.reportsGenerationInputs.logFileData().statsPaths();
        Map groupsByHierarchy = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                Option option;
                A1 A1 = x1;
                if (A1 instanceof GroupStatsPath) {
                    GroupStatsPath groupStatsPath = (GroupStatsPath)A1;
                    Group group = groupStatsPath.group();
                    return (B1)group;
                }
                if (A1 instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)A1).group()) instanceof Some) {
                    Some some = (Some)option;
                    Group group = (Group)some.value();
                    return (B1)group;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(StatsPath x1) {
                RequestStatsPath requestStatsPath;
                Option option;
                StatsPath statsPath = x1;
                if (statsPath instanceof GroupStatsPath) {
                    return true;
                }
                return statsPath instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)statsPath).group()) instanceof Some;
            }
        }).map((Function1 & Serializable)group -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group.hierarchy().reverse()), group)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashSet seenGroups = HashSet$.MODULE$.empty();
        List requestStatsPaths = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof RequestStatsPath) {
                    RequestStatsPath requestStatsPath = (RequestStatsPath)A1;
                    return (B1)requestStatsPath;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(StatsPath x2) {
                StatsPath statsPath = x2;
                return statsPath instanceof RequestStatsPath;
            }
        });
        requestStatsPaths.foreach((Function1 & Serializable)x0$1 -> {
            StatsReportGenerator.$anonfun$generate$13(this, rootContainer, seenGroups, groupsByHierarchy, x0$1);
            return BoxedUnit.UNIT;
        });
        new TemplateWriter(this.chartsFiles.statsJsFile()).writeToFile(new StatsJsTemplate(rootContainer, false).getOutput(this.configuration.core().charset()), this.configuration);
        new TemplateWriter(this.chartsFiles.statsJsonFile()).writeToFile(new StatsJsTemplate(rootContainer, true).getOutput(this.configuration.core().charset()), this.configuration);
        new TemplateWriter(this.chartsFiles.globalStatsJsonFile()).writeToFile(new GlobalStatsJsonTemplate(rootContainer.stats(), true).getOutput(), this.configuration);
        Predef$.MODULE$.println((Object)ConsoleTemplate$.MODULE$.println(rootContainer.stats(), this.reportsGenerationInputs.logFileData().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)));
    }

    private static final Stats percentiles$1(double rank, Function1 title, GeneralStats total, GeneralStats ok, GeneralStats ko) {
        return new Stats<Integer>((String)title.apply((Object)BoxesRunTime.boxToDouble((double)rank)), BoxesRunTime.boxToInteger((int)total.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ok.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ko.percentile().apply$mcID$sp(rank)), (Numeric<Integer>)Numeric.IntIsIntegral$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$generate$1(double rank) {
        return new StringBuilder(25).append("response time ").append(NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(rank))).append(" percentile").toString();
    }

    private final RequestStatistics computeRequestStats$1(String name, Option requestName, Option group2) {
        String string;
        GeneralStats total = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)None$.MODULE$);
        GeneralStats ok = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)OK$.MODULE$));
        GeneralStats ko = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)KO$.MODULE$));
        Stats<Object> numberOfRequestsStatistics = new Stats<Object>("request count", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
        Stats<Object> minResponseTimeStatistics = new Stats<Object>("min response time", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> maxResponseTimeStatistics = new Stats<Object>("max response time", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> meanResponseTimeStatistics = new Stats<Object>("mean response time", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> stdDeviationStatistics = new Stats<Object>("std deviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Function1 & Serializable percentilesTitle = (Function1 & Serializable)rank -> StatsReportGenerator.$anonfun$generate$1(BoxesRunTime.unboxToDouble((Object)rank));
        Stats percentiles1 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile1(), percentilesTitle, total, ok, ko);
        Stats percentiles2 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile2(), percentilesTitle, total, ok, ko);
        Stats percentiles3 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile3(), percentilesTitle, total, ok, ko);
        Stats percentiles4 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile4(), percentilesTitle, total, ok, ko);
        Stats<Object> meanNumberOfRequestsPerSecondStatistics = new Stats<Object>("mean requests/sec", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$);
        Seq groupedCounts = (Seq)this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRange((Option<String>)requestName, (Option<Group>)group2).map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String textLabel = (String)tuple3._1();
                String htmlLabel = (String)tuple3._2();
                int count = BoxesRunTime.unboxToInt((Object)tuple3._3());
                return new GroupedCount(textLabel, htmlLabel, count, total.count());
            }
            throw new MatchError((Object)tuple3);
        });
        Option option = requestName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String n = (String)some.value();
            string = RequestPath$.MODULE$.path(n, (Option<Group>)group2);
        } else {
            string = (String)group2.map((Function1 & Serializable)group -> RequestPath$.MODULE$.path((Group)group)).getOrElse((Function0 & Serializable)() -> "");
        }
        String path = string;
        return new RequestStatistics(name, path, numberOfRequestsStatistics, minResponseTimeStatistics, maxResponseTimeStatistics, meanResponseTimeStatistics, stdDeviationStatistics, percentiles1, percentiles2, percentiles3, percentiles4, (Seq<GroupedCount>)groupedCounts, meanNumberOfRequestsPerSecondStatistics);
    }

    private final Function2 groupStatsFunction$1() {
        BoxedUnit boxedUnit;
        if (this.configuration.charting().useGroupDurationMetric()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group duration stats.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupDurationGeneralStats((Group)group, (Option<Status>)status);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Use group cumulated response time stats.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupCumulatedResponseTimeGeneralStats((Group)group, (Option<Status>)status);
    }

    public static final /* synthetic */ String $anonfun$generate$7(double x$1) {
        return "percentiles1";
    }

    public static final /* synthetic */ String $anonfun$generate$8(double x$2) {
        return "percentiles2";
    }

    public static final /* synthetic */ String $anonfun$generate$9(double x$3) {
        return "percentiles3";
    }

    public static final /* synthetic */ String $anonfun$generate$10(double x$4) {
        return "percentiles4";
    }

    private final RequestStatistics computeGroupStats$1(String name, Group group) {
        GeneralStats total = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)None$.MODULE$);
        GeneralStats ok = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)OK$.MODULE$));
        GeneralStats ko = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)KO$.MODULE$));
        Stats<Object> numberOfRequestsStatistics = new Stats<Object>("numberOfRequests", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
        Stats<Object> minResponseTimeStatistics = new Stats<Object>("minResponseTime", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> maxResponseTimeStatistics = new Stats<Object>("maxResponseTime", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> meanResponseTimeStatistics = new Stats<Object>("meanResponseTime", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> stdDeviationStatistics = new Stats<Object>("stdDeviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats percentiles1 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile1(), (Function1 & Serializable)x$1 -> StatsReportGenerator.$anonfun$generate$7(BoxesRunTime.unboxToDouble((Object)x$1)), total, ok, ko);
        Stats percentiles2 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile2(), (Function1 & Serializable)x$2 -> StatsReportGenerator.$anonfun$generate$8(BoxesRunTime.unboxToDouble((Object)x$2)), total, ok, ko);
        Stats percentiles3 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile3(), (Function1 & Serializable)x$3 -> StatsReportGenerator.$anonfun$generate$9(BoxesRunTime.unboxToDouble((Object)x$3)), total, ok, ko);
        Stats percentiles4 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile4(), (Function1 & Serializable)x$4 -> StatsReportGenerator.$anonfun$generate$10(BoxesRunTime.unboxToDouble((Object)x$4)), total, ok, ko);
        Stats<Object> meanNumberOfRequestsPerSecondStatistics = new Stats<Object>("meanNumberOfRequestsPerSecond", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$);
        Seq groupedCounts = (Seq)this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRange((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group)).map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String textLabel = (String)tuple3._1();
                String htmlLabel = (String)tuple3._2();
                int count = BoxesRunTime.unboxToInt((Object)tuple3._3());
                return new GroupedCount(textLabel, htmlLabel, count, total.count());
            }
            throw new MatchError((Object)tuple3);
        });
        String path = RequestPath$.MODULE$.path(group);
        return new RequestStatistics(name, path, numberOfRequestsStatistics, minResponseTimeStatistics, maxResponseTimeStatistics, meanResponseTimeStatistics, stdDeviationStatistics, percentiles1, percentiles2, percentiles3, percentiles4, (Seq<GroupedCount>)groupedCounts, meanNumberOfRequestsPerSecondStatistics);
    }

    private final void addGroupsRec$1(List hierarchy, HashSet seenGroups$1, Map groupsByHierarchy$1, GroupContainer rootContainer$1) {
        if (!seenGroups$1.contains((Object)hierarchy)) {
            .colon.colon colon2;
            List tail;
            seenGroups$1.$plus$eq((Object)hierarchy);
            List list = hierarchy;
            if (list instanceof .colon.colon && (tail = (colon2 = (.colon.colon)list).next$access$1()).nonEmpty()) {
                this.addGroupsRec$1(tail, seenGroups$1, groupsByHierarchy$1, rootContainer$1);
            }
            Group group = (Group)groupsByHierarchy$1.apply((Object)hierarchy);
            RequestStatistics stats = this.computeGroupStats$1(group.name(), group);
            rootContainer$1.addGroup(group, stats);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$generate$13(StatsReportGenerator $this, GroupContainer rootContainer$1, HashSet seenGroups$1, Map groupsByHierarchy$1, RequestStatsPath x0$1) {
        RequestStatsPath requestStatsPath = x0$1;
        if (requestStatsPath != null) {
            String request = requestStatsPath.request();
            Option group2 = requestStatsPath.group();
            group2.foreach((Function1 & Serializable)group -> {
                $this.addGroupsRec$1(group.hierarchy().reverse(), seenGroups$1, groupsByHierarchy$1, rootContainer$1);
                return BoxedUnit.UNIT;
            });
            RequestStatistics stats = $this.computeRequestStats$1(request, (Option)new Some((Object)request), group2);
            rootContainer$1.addRequest((Option<Group>)group2, request, stats);
            return;
        }
        throw new MatchError((Object)requestStatsPath);
    }

    public StatsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, GatlingConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

