/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.compiler.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.gatling.compiler.config.CompilerConfiguration;
import io.gatling.compiler.config.ConfigUtils$;
import io.gatling.compiler.config.ConfigUtils$RichPath$;
import io.gatling.compiler.config.cli.ArgsParser;
import io.gatling.compiler.config.cli.CommandLineOverrides;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;

public final class CompilerConfiguration$
implements scala.Serializable {
    public static CompilerConfiguration$ MODULE$;
    private final String encodingKey;
    private final String simulationsDirectoryKey;
    private final String binariesDirectoryKey;

    static {
        new CompilerConfiguration$();
    }

    private String encodingKey() {
        return this.encodingKey;
    }

    private String simulationsDirectoryKey() {
        return this.simulationsDirectoryKey;
    }

    private String binariesDirectoryKey() {
        return this.binariesDirectoryKey;
    }

    public CompilerConfiguration configuration(String[] args) {
        ArgsParser argsParser = new ArgsParser(args);
        CommandLineOverrides commandLineOverrides = argsParser.parseArguments();
        Config cliConfig = ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CompilerConfiguration$.buildConfigurationMap$1(commandLineOverrides)).asJava()));
        Config customConfig = ConfigFactory.load((String)"gatling.conf");
        Config defaultConfig = ConfigFactory.load((String)"gatling-defaults.conf");
        Config config = cliConfig.withFallback((ConfigMergeable)customConfig.withFallback((ConfigMergeable)defaultConfig));
        String encoding = config.getString(this.encodingKey());
        Path simulationsDirectory = ConfigUtils$.MODULE$.resolvePath(Paths.get(config.getString(this.simulationsDirectoryKey()), new String[0]));
        Path binariesDirectory = (Path)ConfigUtils$.MODULE$.string2option(config.getString(this.binariesDirectoryKey())).fold((Function0 & Serializable & scala.Serializable)() -> ConfigUtils$RichPath$.MODULE$.$div$extension0(ConfigUtils$.MODULE$.RichPath(ConfigUtils$RichPath$.MODULE$.$div$extension0(ConfigUtils$.MODULE$.RichPath(ConfigUtils$.MODULE$.GatlingHome()), "target")), "test-classes"), (Function1 & Serializable & scala.Serializable)x$1 -> ConfigUtils$.MODULE$.resolvePath(ConfigUtils$.MODULE$.string2path((String)x$1)));
        Seq extraScalacOptions = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commandLineOverrides.extraScalacOptions().split(","))).toSeq();
        return new CompilerConfiguration(encoding, simulationsDirectory, binariesDirectory, (Seq<String>)extraScalacOptions);
    }

    public CompilerConfiguration apply(String encoding, Path simulationsDirectory, Path binariesDirectory, Seq<String> extraScalacOptions) {
        return new CompilerConfiguration(encoding, simulationsDirectory, binariesDirectory, extraScalacOptions);
    }

    public Option<Tuple4<String, Path, Path, Seq<String>>> unapply(CompilerConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.encoding(), (Object)x$0.simulationsDirectory(), (Object)x$0.binariesDirectory(), x$0.extraScalacOptions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final scala.collection.immutable.Map buildConfigurationMap$1(CommandLineOverrides overrides) {
        scala.collection.immutable.Map mapForSimulationFolder = (scala.collection.immutable.Map)ConfigUtils$.MODULE$.string2option(overrides.simulationsDirectory()).map((Function1 & Serializable & scala.Serializable)v -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.simulationsDirectoryKey()), v)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Map mapForBinariesFolder = (scala.collection.immutable.Map)ConfigUtils$.MODULE$.string2option(overrides.binariesFolder()).map((Function1 & Serializable & scala.Serializable)v -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.binariesDirectoryKey()), v)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        return mapForSimulationFolder.$plus$plus((GenTraversableOnce)mapForBinariesFolder);
    }

    private CompilerConfiguration$() {
        MODULE$ = this;
        this.encodingKey = "gatling.core.encoding";
        this.simulationsDirectoryKey = "gatling.core.directory.simulations";
        this.binariesDirectoryKey = "gatling.core.directory.binaries";
    }
}

