/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.commons.stats.assertion.Details;
import io.gatling.commons.stats.assertion.ForAll$;
import io.gatling.commons.stats.assertion.Global$;
import io.gatling.core.Predef;
import io.gatling.core.body.BodyProcessors;
import io.gatling.core.body.BodyWithBytesExpression;
import io.gatling.core.body.ElFileBodies;
import io.gatling.core.body.PebbleFileBodies;
import io.gatling.core.body.RawFileBodies;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.css.CssCheckType;
import io.gatling.core.check.css.CssSelectors;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jmespath.JmesPaths;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.jsonpath.JsonPaths;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckType;
import io.gatling.core.check.regex.Patterns;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.core.check.xpath.XmlParsers;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.throttle.Hold;
import io.gatling.core.controller.throttle.Jump;
import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.Assertion;
import io.gatling.javaapi.core.Body;
import io.gatling.javaapi.core.ChainBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.ClosedInjectionStep;
import io.gatling.javaapi.core.FeederBuilder;
import io.gatling.javaapi.core.Filter;
import io.gatling.javaapi.core.OpenInjectionStep;
import io.gatling.javaapi.core.PauseType;
import io.gatling.javaapi.core.ScenarioBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.ThrottleStep;
import io.gatling.javaapi.core.condition.DoIf;
import io.gatling.javaapi.core.condition.DoIfEquals;
import io.gatling.javaapi.core.condition.DoIfEqualsOrElse;
import io.gatling.javaapi.core.condition.DoIfOrElse;
import io.gatling.javaapi.core.condition.DoSwitch;
import io.gatling.javaapi.core.condition.DoSwitchOrElse;
import io.gatling.javaapi.core.condition.RandomSwitch;
import io.gatling.javaapi.core.condition.RandomSwitchOrElse;
import io.gatling.javaapi.core.condition.RoundRobinSwitch;
import io.gatling.javaapi.core.condition.UniformRandomSwitch;
import io.gatling.javaapi.core.error.Errors;
import io.gatling.javaapi.core.group.Groups;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.CoreCheckBuilders;
import io.gatling.javaapi.core.internal.CoreCheckType;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.core.loop.AsLongAs;
import io.gatling.javaapi.core.loop.AsLongAsDuring;
import io.gatling.javaapi.core.loop.DoWhile;
import io.gatling.javaapi.core.loop.DoWhileDuring;
import io.gatling.javaapi.core.loop.During;
import io.gatling.javaapi.core.loop.ForEach;
import io.gatling.javaapi.core.loop.Forever;
import io.gatling.javaapi.core.loop.Repeat;
import io.pebbletemplates.pebble.extension.Extension;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jodd.lagarto.dom.NodeSelector;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;

public final class CoreDsl {
    public static PauseType disabledPauses = PauseType.Disabled;
    public static PauseType constantPauses = PauseType.Constant;
    public static PauseType exponentialPauses = PauseType.Exponential;
    public static final Function<Body, Body.WithBytes> gzipBody = body -> new Body.WithBytes((BodyWithBytesExpression)BodyProcessors.gzip().apply((Object)body.asScala()));

    private CoreDsl() {
    }

    @Nonnull
    public static ScenarioBuilder scenario(@Nonnull String string) {
        return new ScenarioBuilder(string);
    }

    @Nonnull
    public static Filter.AllowList AllowList(String ... stringArray) {
        return CoreDsl.AllowList(Arrays.asList(stringArray));
    }

    @Nonnull
    public static Filter.AllowList AllowList(@Nonnull List<String> list) {
        return new Filter.AllowList(list);
    }

    @Nonnull
    public static Filter.DenyList DenyList(String ... stringArray) {
        return CoreDsl.DenyList(Arrays.asList(stringArray));
    }

    @Nonnull
    public static Filter.DenyList DenyList(@Nonnull List<String> list) {
        return new Filter.DenyList(list);
    }

    @Nonnull
    public static ChainBuilder exec(@Nonnull Function<Session, Session> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(function);
    }

    @Nonnull
    public static ChainBuilder exec(@Nonnull ActionBuilder actionBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(actionBuilder);
    }

    @Nonnull
    public static ChainBuilder exec(ChainBuilder ... chainBuilderArray) {
        return CoreDsl.exec(Arrays.asList(chainBuilderArray));
    }

    @Nonnull
    public static ChainBuilder exec(@Nonnull List<ChainBuilder> list) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(list);
    }

    @Nonnull
    public static ChainBuilder pause(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l);
    }

    @Nonnull
    public static ChainBuilder pause(long l, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2);
    }

    @Nonnull
    public static ChainBuilder pause(long l, long l2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration, @Nonnull Duration duration2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string, @Nonnull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string, @Nonnull String string2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function, @Nonnull Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function, @Nonnull Function<Session, Duration> function2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pace(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l);
    }

    @Nonnull
    public static ChainBuilder pace(long l, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull String string, @Nonnull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, string);
    }

    @Nonnull
    public static ChainBuilder pace(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2);
    }

    @Nonnull
    public static ChainBuilder pace(long l, long l2, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration, @Nonnull Duration duration2, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2, string3);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function, Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2, string);
    }

    @Nonnull
    public static ChainBuilder rendezVous(int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.rendezVous(n);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Supplier<Iterator<Map<String, Object>>> supplier) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Supplier<Iterator<Map<String, Object>>> supplier, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, n);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Supplier<Iterator<Map<String, Object>>> supplier, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, string);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Supplier<Iterator<Map<String, Object>>> supplier, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, function);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Iterator<Map<String, Object>> iterator) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Iterator<Map<String, Object>> iterator, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, n);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Iterator<Map<String, Object>> iterator, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, string);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Iterator<Map<String, Object>> iterator, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, function);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull FeederBuilder<?> feederBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull FeederBuilder<?> feederBuilder, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, n);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull FeederBuilder<?> feederBuilder, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, string);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull FeederBuilder<?> feederBuilder, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, function);
    }

    @Nonnull
    public static Repeat.On<ChainBuilder> repeat(int n) {
        return ChainBuilder.EMPTY.repeat(n);
    }

    @Nonnull
    public static Repeat.On<ChainBuilder> repeat(int n, @Nonnull String string) {
        return ChainBuilder.EMPTY.repeat(n, string);
    }

    @Nonnull
    public static Repeat.On<ChainBuilder> repeat(@Nonnull String string) {
        return ChainBuilder.EMPTY.repeat(string);
    }

    @Nonnull
    public static Repeat.On<ChainBuilder> repeat(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.repeat(string, string2);
    }

    @Nonnull
    public static Repeat.On<ChainBuilder> repeat(@Nonnull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.repeat(function);
    }

    @Nonnull
    public static Repeat.On<ChainBuilder> repeat(@Nonnull Function<Session, Integer> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.repeat(function, string);
    }

    @Nonnull
    public static ForEach.On<ChainBuilder> foreach(@Nonnull List<?> list, String string) {
        return ChainBuilder.EMPTY.foreach(list, string);
    }

    @Nonnull
    public static ForEach.On<ChainBuilder> foreach(@Nonnull List<?> list, String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.foreach(list, string, string2);
    }

    @Nonnull
    public static ForEach.On<ChainBuilder> foreach(@Nonnull String string, String string2) {
        return ChainBuilder.EMPTY.foreach(string, string2);
    }

    @Nonnull
    public static ForEach.On<ChainBuilder> foreach(@Nonnull String string, String string2, @Nonnull String string3) {
        return ChainBuilder.EMPTY.foreach(string, string2, string3);
    }

    @Nonnull
    public static ForEach.On<ChainBuilder> foreach(@Nonnull Function<Session, List<?>> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.foreach(function, string);
    }

    @Nonnull
    public static ForEach.On<ChainBuilder> foreach(@Nonnull Function<Session, List<?>> function, @Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.foreach(function, string, string2);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(long l) {
        return ChainBuilder.EMPTY.during(l);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(long l, boolean bl) {
        return ChainBuilder.EMPTY.during(l, bl);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(long l, @Nonnull String string) {
        return ChainBuilder.EMPTY.during(l, string);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(long l, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(l, string, bl);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Duration duration) {
        return ChainBuilder.EMPTY.during(duration);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, bl);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Duration duration, @Nonnull String string) {
        return ChainBuilder.EMPTY.during(duration, string);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Duration duration, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, string, bl);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull String string) {
        return ChainBuilder.EMPTY.during(string);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(string, bl);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.during(string, string2);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.during(string, string2, bl);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.during(function);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.during(function, bl);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Function<Session, Duration> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.during(function, string);
    }

    @Nonnull
    public static During.On<ChainBuilder> during(@Nonnull Function<Session, Duration> function, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(function, string, bl);
    }

    @Nonnull
    public static Forever.On<ChainBuilder> forever() {
        return ChainBuilder.EMPTY.forever();
    }

    @Nonnull
    public static Forever.On<ChainBuilder> forever(@Nonnull String string) {
        return ChainBuilder.EMPTY.forever(string);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAs(string);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.asLongAs(string, string2);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, bl);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, string2, bl);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.asLongAs(function);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAs(function, string);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, bl);
    }

    @Nonnull
    public static AsLongAs.On<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, string, bl);
    }

    @Nonnull
    public static DoWhile.On<ChainBuilder> doWhile(@Nonnull String string) {
        return ChainBuilder.EMPTY.doWhile(string);
    }

    @Nonnull
    public static DoWhile.On<ChainBuilder> doWhile(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doWhile(string, string2);
    }

    @Nonnull
    public static DoWhile.On<ChainBuilder> doWhile(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doWhile(function);
    }

    @Nonnull
    public static DoWhile.On<ChainBuilder> doWhile(@Nonnull Function<Session, Boolean> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.doWhile(function, string);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, long l) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Duration duration) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, long l, @Nonnull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, string2);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Duration duration, @Nonnull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, string2);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function, @Nonnull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, string2);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, long l, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, long l, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, string2, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Duration duration, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, string2, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, string2, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, long l) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, long l, @Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, string);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration, @Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, string);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, long l, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, long l, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, string, bl);
    }

    @Nonnull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, string, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, long l) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Duration duration) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, long l, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, string2);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Duration duration, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, string2);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, string2);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, long l, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, long l, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, string2, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Duration duration, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, string2, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull Function<Session, Duration> function, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, string2, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, long l) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, long l, @Nonnull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, string);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration, @Nonnull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, string);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, long l, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, long l, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, string, bl);
    }

    @Nonnull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Duration duration, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, string, bl);
    }

    @Nonnull
    public static DoIf.Then<ChainBuilder> doIf(@Nonnull String string) {
        return ChainBuilder.EMPTY.doIf(string);
    }

    @Nonnull
    public static DoIf.Then<ChainBuilder> doIf(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIf(function);
    }

    @Nonnull
    public static DoIfOrElse.Then<ChainBuilder> doIfOrElse(@Nonnull String string) {
        return ChainBuilder.EMPTY.doIfOrElse(string);
    }

    @Nonnull
    public static DoIfOrElse.Then<ChainBuilder> doIfOrElse(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIfOrElse(function);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doIfEquals(string, string2);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull String string, @Nonnull Object object) {
        return ChainBuilder.EMPTY.doIfEquals(string, object);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull String string, @Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEquals(string, function);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull Function<Session, Object> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.doIfEquals(function, string);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull Function<Session, Object> function, Object object) {
        return ChainBuilder.EMPTY.doIfEquals(function, object);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull Function<Session, Object> function, @Nonnull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEquals(function, function2);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(String string, String string2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, string2);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull String string, @Nonnull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, object);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull String string, @Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, function);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull Function<Session, Object> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, string);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull Function<Session, Object> function, @Nonnull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, object);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull Function<Session, Object> function, @Nonnull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, function2);
    }

    @Nonnull
    public static DoSwitch.On<ChainBuilder> doSwitch(@Nonnull String string) {
        return ChainBuilder.EMPTY.doSwitch(string);
    }

    @Nonnull
    public static DoSwitch.On<ChainBuilder> doSwitch(@Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitch(function);
    }

    @Nonnull
    public static DoSwitchOrElse.On<ChainBuilder> doSwitchOrElse(@Nonnull String string) {
        return ChainBuilder.EMPTY.doSwitchOrElse(string);
    }

    @Nonnull
    public static DoSwitchOrElse.On<ChainBuilder> doSwitchOrElse(@Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitchOrElse(function);
    }

    @Nonnull
    public static RandomSwitch.On<ChainBuilder> randomSwitch() {
        return ChainBuilder.EMPTY.randomSwitch();
    }

    @Nonnull
    public static RandomSwitchOrElse.On<ChainBuilder> randomSwitchOrElse() {
        return ChainBuilder.EMPTY.randomSwitchOrElse();
    }

    @Nonnull
    public static UniformRandomSwitch.On<ChainBuilder> uniformRandomSwitch() {
        return ChainBuilder.EMPTY.uniformRandomSwitch();
    }

    @Nonnull
    public static RoundRobinSwitch.On<ChainBuilder> roundRobinSwitch() {
        return ChainBuilder.EMPTY.roundRobinSwitch();
    }

    @Nonnull
    public static ChainBuilder exitBlockOnFail(@Nonnull ChainBuilder chainBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitBlockOnFail(chainBuilder);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(int n) {
        return ChainBuilder.EMPTY.tryMax(n);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(int n, @Nonnull String string) {
        return ChainBuilder.EMPTY.tryMax(n, string);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull String string) {
        return ChainBuilder.EMPTY.tryMax(string);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.tryMax(string, string2);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.tryMax(function);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull Function<Session, Integer> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.tryMax(function, string);
    }

    @Nonnull
    public static ChainBuilder exitHereIf(@Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(string);
    }

    @Nonnull
    public static ChainBuilder exitHereIf(@Nonnull Function<Session, Boolean> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(function);
    }

    @Nonnull
    public static ChainBuilder exitHere() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHere();
    }

    @Nonnull
    public static ChainBuilder exitHereIfFailed() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIfFailed();
    }

    @Nonnull
    public static ChainBuilder stopInjector(String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjector(string);
    }

    @Nonnull
    public static ChainBuilder stopInjector(Function<Session, String> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjector(function);
    }

    @Nonnull
    public static Groups.On<ChainBuilder> group(@Nonnull String string) {
        return ChainBuilder.EMPTY.group(string);
    }

    @Nonnull
    public static Groups.On<ChainBuilder> group(@Nonnull Function<Session, String> function) {
        return ChainBuilder.EMPTY.group(function);
    }

    @Nonnull
    public static PauseType normalPausesWithPercentageDuration(double d) {
        return new PauseType.NormalWithPercentageDuration(d);
    }

    @Nonnull
    public static PauseType normalPausesWithStdDevDuration(@Nonnull Duration duration) {
        return new PauseType.NormalWithStdDevDuration(duration);
    }

    @Nonnull
    public static PauseType customPauses(@Nonnull Function<Session, Long> function) {
        return new PauseType.Custom(function);
    }

    @Nonnull
    public static PauseType uniformPausesPlusOrMinusPercentage(double d) {
        return new PauseType.UniformPercentage(d);
    }

    @Nonnull
    public static PauseType uniformPausesPlusOrMinusDuration(@Nonnull Duration duration) {
        return new PauseType.UniformDuration(duration);
    }

    @Nonnull
    public static CheckBuilder.Find<String> bodyString() {
        return new CheckBuilder.Find.Default(Predef.bodyString(), CoreCheckType.BodyString, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.Find<byte[]> bodyBytes() {
        return new CheckBuilder.Find.Default(Predef.bodyBytes(), CoreCheckType.BodyBytes, byte[].class, null);
    }

    @Nonnull
    public static CheckBuilder.Find<Integer> bodyLength() {
        return CoreCheckBuilders.bodyLength();
    }

    @Nonnull
    public static CheckBuilder.Find<InputStream> bodyStream() {
        return new CheckBuilder.Find.Default(Predef.bodyStream(), CoreCheckType.BodyStream, InputStream.class, null);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Integer> substring(@Nonnull String string) {
        return CoreCheckBuilders.substring(string);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Integer> substring(@Nonnull Function<Session, String> function) {
        return CoreCheckBuilders.substring(function);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.toStringExpression(string), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.javaFunctionToExpression(function), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull String string, @Nonnull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.toStringExpression(string), Converters.toScalaMap(map), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull Function<Session, String> function, @Nonnull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.javaFunctionToExpression(function), Converters.toScalaMap(map), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> css(@Nonnull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.css(Expressions.toStringExpression(string), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> css(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.css(Expressions.javaFunctionToExpression(function), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.CssOfTypeMultipleFind css(@Nonnull String string, @Nonnull String string2) {
        return new CheckBuilder.Css((CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String>)Predef.css(Expressions.toStringExpression(string), (String)string2, (CssSelectors)Predef.defaultCssSelectors()));
    }

    @Nonnull
    public static CheckBuilder.CssOfTypeMultipleFind css(@Nonnull Function<Session, String> function, @Nonnull String string) {
        return new CheckBuilder.Css((CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String>)Predef.css(Expressions.javaFunctionToExpression(function), (String)string, (CssSelectors)Predef.defaultCssSelectors()));
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Map<String, Object>> form(@Nonnull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.form(Expressions.toStringExpression(string), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Map.class, Converters::toJavaMap);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Map<String, Object>> form(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.form(Expressions.javaFunctionToExpression(function), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Map.class, Converters::toJavaMap);
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonPath(@Nonnull String string) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)Predef.jsonPath(Expressions.toStringExpression(string), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)Predef.jsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jmesPath(@Nonnull String string) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)Predef.jmesPath(Expressions.toStringExpression(string), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jmesPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)Predef.jmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@Nonnull String string) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)Predef.jsonpJsonPath(Expressions.toStringExpression(string), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)Predef.jsonpJsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jsonpJmesPath(@Nonnull String string) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)Predef.jsonpJmesPath(Expressions.toStringExpression(string), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jsonpJmesPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)Predef.jsonpJmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.CaptureGroupCheckBuilder regex(@Nonnull String string) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)Predef.regex(Expressions.toStringExpression(string), (Patterns)Predef.defaultPatterns()));
    }

    @Nonnull
    public static CheckBuilder.CaptureGroupCheckBuilder regex(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)Predef.regex(Expressions.javaFunctionToExpression(function), (Patterns)Predef.defaultPatterns()));
    }

    public static void registerJmesPathFunctions(io.burt.jmespath.function.Function ... functionArray) {
        Predef.registerJmesPathFunctions(Converters.toScalaSeq(functionArray));
    }

    @Nonnull
    public static CheckBuilder.Find<String> md5() {
        return new CheckBuilder.Find.Default(Predef.md5(), CoreCheckType.Md5, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.Find<String> sha1() {
        return new CheckBuilder.Find.Default(Predef.sha1(), CoreCheckType.Sha1, String.class, null);
    }

    @Nonnull
    public static CheckBuilder.Find<Integer> responseTimeInMillis() {
        return CoreCheckBuilders.responseTimeInMillis();
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> csv(@Nonnull String string) {
        return FeederBuilder.Impl.csv(string);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> csv(@Nonnull String string, char c) {
        return FeederBuilder.Impl.csv(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> ssv(@Nonnull String string) {
        return FeederBuilder.Impl.ssv(string);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> ssv(@Nonnull String string, char c) {
        return FeederBuilder.Impl.ssv(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> tsv(@Nonnull String string) {
        return FeederBuilder.Impl.tsv(string);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> tsv(@Nonnull String string, char c) {
        return FeederBuilder.Impl.tsv(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> separatedValues(@Nonnull String string, char c) {
        return FeederBuilder.Impl.separatedValues(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> separatedValues(@Nonnull String string, char c, char c2) {
        return FeederBuilder.Impl.separatedValues(string, c, c2);
    }

    @Nonnull
    public static FeederBuilder.FileBased<Object> jsonFile(@Nonnull String string) {
        return FeederBuilder.Impl.jsonFile(string);
    }

    @Nonnull
    public static FeederBuilder<Object> jsonUrl(String string) {
        return FeederBuilder.Impl.jsonUrl(string);
    }

    @Nonnull
    public static FeederBuilder<Object> arrayFeeder(@Nonnull Map<String, Object>[] mapArray) {
        scala.collection.immutable.Map[] mapArray2 = (scala.collection.immutable.Map[])Arrays.stream(mapArray).map(Converters::toScalaMap).toArray(scala.collection.immutable.Map[]::new);
        return new FeederBuilder.Impl<Object>(Predef.array2FeederBuilder((scala.collection.immutable.Map[])mapArray2, (GatlingConfiguration)Predef.configuration()));
    }

    @Nonnull
    public static FeederBuilder<Object> listFeeder(@Nonnull List<Map<String, Object>> list) {
        Seq seq = Converters.toScalaSeq(list.stream().map(Converters::toScalaMap).collect(Collectors.toList()));
        return new FeederBuilder.Impl<Object>(Predef.seq2FeederBuilder((IndexedSeq)seq.toIndexedSeq(), (GatlingConfiguration)Predef.configuration()));
    }

    @Nonnull
    public static OpenInjectionStep.Ramp rampUsers(int n) {
        return new OpenInjectionStep.Ramp(n);
    }

    @Nonnull
    public static OpenInjectionStep.StressPeak stressPeakUsers(int n) {
        return new OpenInjectionStep.StressPeak(n);
    }

    @Nonnull
    public static OpenInjectionStep atOnceUsers(int n) {
        return OpenInjectionStep.atOnceUsers(n);
    }

    @Nonnull
    public static OpenInjectionStep.ConstantRate constantUsersPerSec(double d) {
        return new OpenInjectionStep.ConstantRate(d);
    }

    @Nonnull
    public static OpenInjectionStep.RampRate rampUsersPerSec(double d) {
        return new OpenInjectionStep.RampRate(d);
    }

    @Nonnull
    public static OpenInjectionStep nothingFor(long l) {
        return CoreDsl.nothingFor(Duration.ofSeconds(l));
    }

    @Nonnull
    public static OpenInjectionStep nothingFor(@Nonnull Duration duration) {
        return OpenInjectionStep.nothingFor(duration);
    }

    @Nonnull
    public static OpenInjectionStep.Stairs incrementUsersPerSec(double d) {
        return new OpenInjectionStep.Stairs(d);
    }

    @Nonnull
    public static ClosedInjectionStep.Constant constantConcurrentUsers(int n) {
        return new ClosedInjectionStep.Constant(n);
    }

    @Nonnull
    public static ClosedInjectionStep.Ramp rampConcurrentUsers(int n) {
        return new ClosedInjectionStep.Ramp(n);
    }

    @Nonnull
    public static ClosedInjectionStep.Stairs incrementConcurrentUsers(int n) {
        return new ClosedInjectionStep.Stairs(n);
    }

    @Nonnull
    public static ThrottleStep.ReachIntermediate reachRps(int n) {
        return new ThrottleStep.ReachIntermediate(n);
    }

    @Nonnull
    public static ThrottleStep holdFor(long l) {
        return CoreDsl.holdFor(Duration.ofSeconds(l));
    }

    @Nonnull
    public static ThrottleStep holdFor(@Nonnull Duration duration) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Hold(Converters.toScalaDuration(duration)));
    }

    @Nonnull
    public static ThrottleStep jumpToRps(int n) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Jump(n));
    }

    @Nonnull
    public static Assertion.WithPath global() {
        return new Assertion.WithPath((AssertionPath)Global$.MODULE$);
    }

    @Nonnull
    public static Assertion.WithPath forAll() {
        return new Assertion.WithPath((AssertionPath)ForAll$.MODULE$);
    }

    @Nonnull
    public static Assertion.WithPath details(String ... stringArray) {
        Seq seq = Converters.toScalaSeq(stringArray);
        return new Assertion.WithPath((AssertionPath)new Details(seq.toList()));
    }

    @Nonnull
    public static Body.WithString StringBody(@Nonnull String string) {
        return new Body.WithString(Predef.StringBody((String)string, (GatlingConfiguration)Predef.configuration()));
    }

    @Nonnull
    public static Body.WithString StringBody(@Nonnull Function<Session, String> function) {
        return new Body.WithString(Predef.StringBody(Expressions.javaFunctionToExpression(function), (GatlingConfiguration)Predef.configuration()));
    }

    @Nonnull
    public static Body.WithBytes RawFileBody(@Nonnull String string) {
        return new Body.WithBytes(Predef.RawFileBody(Expressions.toStringExpression(string), (RawFileBodies)Predef.rawFileBodies()));
    }

    @Nonnull
    public static Body.WithBytes RawFileBody(@Nonnull Function<Session, String> function) {
        return new Body.WithBytes(Predef.RawFileBody(Expressions.javaFunctionToExpression(function), (RawFileBodies)Predef.rawFileBodies()));
    }

    @Nonnull
    public static Body.WithString ElFileBody(@Nonnull String string) {
        return new Body.WithString(Predef.ElFileBody(Expressions.toStringExpression(string), (ElFileBodies)Predef.elFileBodies()));
    }

    @Nonnull
    public static Body.WithString ElFileBody(@Nonnull Function<Session, String> function) {
        return new Body.WithString(Predef.ElFileBody(Expressions.javaFunctionToExpression(function), (ElFileBodies)Predef.elFileBodies()));
    }

    @Nonnull
    public static Body.WithString PebbleStringBody(@Nonnull String string) {
        return new Body.WithString(Predef.PebbleStringBody((String)string, (GatlingConfiguration)Predef.configuration()));
    }

    @Nonnull
    public static Body.WithString PebbleFileBody(@Nonnull String string) {
        return new Body.WithString(Predef.PebbleFileBody(Expressions.toStringExpression(string), (PebbleFileBodies)Predef.pebbleFileBodies(), (GatlingConfiguration)Predef.configuration()));
    }

    @Nonnull
    public static Body.WithString PebbleFileBody(@Nonnull Function<Session, String> function) {
        return new Body.WithString(Predef.PebbleFileBody(Expressions.javaFunctionToExpression(function), (PebbleFileBodies)Predef.pebbleFileBodies(), (GatlingConfiguration)Predef.configuration()));
    }

    @Nonnull
    public static Body.WithBytes ByteArrayBody(@Nonnull byte[] byArray) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.toStaticValueExpression(byArray)));
    }

    @Nonnull
    public static Body.WithBytes ByteArrayBody(@Nonnull String string) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.toBytesExpression(string)));
    }

    @Nonnull
    public static Body.WithBytes ByteArrayBody(@Nonnull Function<Session, byte[]> function) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public static Body InputStreamBody(@Nonnull Function<Session, InputStream> function) {
        return new Body.Default(Predef.InputStreamBody(Expressions.javaFunctionToExpression(function)));
    }

    public static void registerPebbleExtensions(Extension ... extensionArray) {
        Predef.registerPebbleExtensions(Converters.toScalaSeq(extensionArray));
    }
}

