/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Sessions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;

public final class Session {
    private final io.gatling.core.session.Session wrapped;

    public Session(io.gatling.core.session.Session session) {
        this.wrapped = session;
    }

    @Nullable
    public <T> T get(@Nonnull String string) {
        return (T)this.wrapped.attributes().getOrElse((Object)string, () -> null);
    }

    @Nullable
    public String getString(@Nonnull String string) {
        Object t = this.get(string);
        return t != null ? t.toString() : null;
    }

    @Nullable
    public Integer getIntegerWrapper(@Nonnull String string) {
        Object t = this.get(string);
        if (t instanceof Integer) {
            return (Integer)t;
        }
        if (t instanceof String) {
            return Integer.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(t + " is not an Integer: " + t.getClass());
    }

    public int getInt(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(object + " is not an Integer: " + object.getClass());
    }

    @Nullable
    public Long getLongWrapper(@Nonnull String string) {
        Object t = this.get(string);
        if (t instanceof Integer) {
            return ((Integer)t).longValue();
        }
        if (t instanceof Long) {
            return (Long)t;
        }
        if (t instanceof String) {
            return Long.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(t + " is not an Long: " + t.getClass());
    }

    public long getLong(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(object + " is not an Long: " + object.getClass());
    }

    @Nullable
    public Double getDoubleWrapper(@Nonnull String string) {
        Object t = this.get(string);
        if (t instanceof Integer) {
            return ((Integer)t).doubleValue();
        }
        if (t instanceof Long) {
            return ((Long)t).doubleValue();
        }
        if (t instanceof Double) {
            return (Double)t;
        }
        if (t instanceof String) {
            return Double.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(t + " is not an Double: " + t.getClass());
    }

    public double getDouble(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(object + " is not an Double: " + object.getClass());
    }

    @Nullable
    public Boolean getBooleanWrapper(@Nonnull String string) {
        Object t = this.get(string);
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        if (t instanceof String) {
            return Boolean.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(t + " is not an Boolean: " + t.getClass());
    }

    public boolean getBoolean(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(object + " is not an Boolean: " + object.getClass());
    }

    @Nonnull
    public <T> List<T> getList(@Nonnull String string) {
        T t = this.get(string);
        if (t instanceof List) {
            return (List)t;
        }
        if (t instanceof Seq) {
            return Converters.toJavaList((Seq)t);
        }
        if (t == null) {
            return Collections.emptyList();
        }
        throw new ClassCastException(t + " is not an List: " + t.getClass());
    }

    @Nonnull
    public <T> java.util.Set<T> getSet(@Nonnull String string) {
        T t = this.get(string);
        if (t instanceof java.util.Set) {
            return (java.util.Set)t;
        }
        if (t instanceof Set) {
            return Converters.toJavaSet((Set)t);
        }
        if (t != null) {
            throw new ClassCastException(t + " is not an Set: " + t.getClass());
        }
        return Collections.emptySet();
    }

    @Nonnull
    public <T> java.util.Map<String, T> getMap(@Nonnull String string) {
        T t = this.get(string);
        if (t instanceof java.util.Map) {
            return (java.util.Map)t;
        }
        if (t instanceof Map) {
            return Converters.toJavaMap((Map)t);
        }
        if (t == null) {
            return Collections.emptyMap();
        }
        throw new ClassCastException(t + " is not an Map: " + t.getClass());
    }

    @Nonnull
    public Session set(@Nonnull String string, Object object) {
        return new Session(this.wrapped.set(string, object));
    }

    @Nonnull
    public Session setAll(@Nonnull java.util.Map<String, Object> map) {
        return new Session(this.wrapped.setAll(Converters.toScalaMap(map)));
    }

    @Nonnull
    public Session remove(@Nonnull String string) {
        return new Session(this.wrapped.remove(string));
    }

    @Nonnull
    public Session reset() {
        return new Session(this.wrapped.reset());
    }

    @Nonnull
    public Session removeAll(String ... stringArray) {
        return new Session(this.wrapped.removeAll(Converters.toScalaSeq(stringArray)));
    }

    public boolean contains(@Nonnull String string) {
        return this.wrapped.contains(string);
    }

    public boolean isFailed() {
        return this.wrapped.isFailed();
    }

    @Nonnull
    public Session markAsSucceeded() {
        return new Session(this.wrapped.markAsSucceeded());
    }

    @Nonnull
    public Session markAsFailed() {
        return new Session(this.wrapped.markAsFailed());
    }

    public String scenario() {
        return this.wrapped.scenario();
    }

    public List<String> groups() {
        return Sessions.groups(this);
    }

    public long userId() {
        return this.wrapped.userId();
    }

    public io.gatling.core.session.Session asScala() {
        return this.wrapped;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

