/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.ClockSingleton$;
import io.gatling.core.stats.message.End$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleData$;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserCounters;
import io.gatling.core.stats.writer.UserMessage;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001b\t\t2i\u001c8t_2,G)\u0019;b/JLG/\u001a:\u000b\u0005\r!\u0011AB<sSR,'O\u0003\u0002\u0006\r\u0005)1\u000f^1ug*\u0011q\u0001C\u0001\u0005G>\u0014XM\u0003\u0002\n\u0015\u00059q-\u0019;mS:<'\"A\u0006\u0002\u0005%|7\u0001A\n\u0003\u00019\u00012a\u0004\t\u0013\u001b\u0005\u0011\u0011BA\t\u0003\u0005)!\u0015\r^1Xe&$XM\u001d\t\u0003\u001fMI!\u0001\u0006\u0002\u0003\u0017\r{gn]8mK\u0012\u000bG/\u0019\u0005\u0006-\u0001!\taF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"a\u0004\u0001\t\u000fi\u0001!\u0019!C\u00057\u0005qa\r\\;tQRKW.\u001a:OC6,W#\u0001\u000f\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001\u00027b]\u001eT\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$=\t11\u000b\u001e:j]\u001eDa!\n\u0001!\u0002\u0013a\u0012a\u00044mkNDG+[7fe:\u000bW.\u001a\u0011\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\r=t\u0017J\\5u)\t\u0011\u0012\u0006C\u0003+M\u0001\u00071&\u0001\u0003j]&$\bCA\b-\u0013\ti#A\u0001\u0003J]&$\b\"B\u0018\u0001\t\u0003\u0002\u0014aB8o\r2,8\u000f\u001b\u000b\u0003c]\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012A!\u00168ji\")\u0001H\fa\u0001%\u0005!A-\u0019;b\u0011\u0015Q\u0004\u0001\"\u0011<\u0003%yg.T3tg\u0006<W\rF\u00022y\u0005CQ!P\u001dA\u0002y\nq!\\3tg\u0006<W\r\u0005\u0002\u0010\u007f%\u0011\u0001I\u0001\u0002\u0011\u0019>\fG-\u0012<f]RlUm]:bO\u0016DQ\u0001O\u001dA\u0002IAQa\u0011\u0001\u0005\n\u0011\u000bQb\u001c8Vg\u0016\u0014X*Z:tC\u001e,GcA\u0019F\u0015\")aI\u0011a\u0001\u000f\u0006!Qo]3s!\ty\u0001*\u0003\u0002J\u0005\tYQk]3s\u001b\u0016\u001c8/Y4f\u0011\u0015A$\t1\u0001\u0013\u0011\u0015a\u0005\u0001\"\u0003N\u0003EygNU3ta>t7/Z'fgN\fw-\u001a\u000b\u0004c9\u001b\u0006\"B(L\u0001\u0004\u0001\u0016\u0001\u0003:fgB|gn]3\u0011\u0005=\t\u0016B\u0001*\u0003\u0005=\u0011Vm\u001d9p]N,W*Z:tC\u001e,\u0007\"\u0002\u001dL\u0001\u0004\u0011\u0002\"B+\u0001\t\u00131\u0016AD8o\u000bJ\u0014xN]'fgN\fw-\u001a\u000b\u0004c]c\u0006\"\u0002-U\u0001\u0004I\u0016!B3se>\u0014\bCA\b[\u0013\tY&A\u0001\u0007FeJ|'/T3tg\u0006<W\rC\u00039)\u0002\u0007!\u0003C\u0003_\u0001\u0011\u0005s,A\u0004p]\u000e\u0013\u0018m\u001d5\u0015\u0007E\u0002G\u000eC\u0003b;\u0002\u0007!-A\u0003dCV\u001cX\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003KNj\u0011A\u001a\u0006\u0003O2\ta\u0001\u0010:p_Rt\u0014BA54\u0003\u0019\u0001&/\u001a3fM&\u00111e\u001b\u0006\u0003SNBQ\u0001O/A\u0002IAQA\u001c\u0001\u0005B=\faa\u001c8Ti>\u0004HCA\u0019q\u0011\u0015AT\u000e1\u0001\u0013\u0001")
public class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConsoleData onInit(Init init) {
        void var2_2;
        ConsoleData data = new ConsoleData(init.configuration(), ClockSingleton$.MODULE$.nowMillis(), ConsoleData$.MODULE$.$lessinit$greater$default$3(), ConsoleData$.MODULE$.$lessinit$greater$default$4(), ConsoleData$.MODULE$.$lessinit$greater$default$5(), ConsoleData$.MODULE$.$lessinit$greater$default$6(), ConsoleData$.MODULE$.$lessinit$greater$default$7());
        init.scenarios().foreach((Function1 & Serializable & scala.Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.userCount())));
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), true);
        return var2_2;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (ClockSingleton$.MODULE$.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), data.configuration(), ConsoleSummary$.MODULE$.apply$default$7());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(LoadEventMessage message, ConsoleData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            this.onErrorMessage(errorMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onUserMessage(UserMessage user, ConsoleData data) {
        MessageEvent messageEvent = user.event();
        if (Start$.MODULE$.equals(messageEvent)) {
            Option option = data.usersCounters().get((Object)user.session().scenario());
            if (option instanceof Some) {
                Some some = (Some)option;
                UserCounters name = (UserCounters)some.value();
                name.userStart();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.session().scenario()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (End$.MODULE$.equals(messageEvent)) {
            Option option = data.usersCounters().get((Object)user.session().scenario());
            if (option instanceof Some) {
                Some some = (Some)option;
                UserCounters name = (UserCounters)some.value();
                name.userDone();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.session().scenario()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)messageEvent);
        }
    }

    private void onResponseMessage(ResponseMessage response, ConsoleData data) {
        String requestPath = ((TraversableOnce)response.groupHierarchy().$colon$plus((Object)response.name(), List$.MODULE$.canBuildFrom())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable & scala.Serializable)() -> new RequestCounters(RequestCounters$.MODULE$.$lessinit$greater$default$1(), RequestCounters$.MODULE$.$lessinit$greater$default$2()));
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable & scala.Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status);
        }
    }

    private void onErrorMessage(ErrorMessage error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        block0: {
            this.cancelTimer(this.flushTimerName());
            if (data.complete()) break block0;
            this.onFlush(data);
        }
    }

    public ConsoleDataWriter() {
        this.flushTimerName = "flushTimer";
    }
}

