/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.body;

import io.gatling.commons.util.FastByteArrayInputStream;
import io.gatling.commons.util.GzipHelper$;
import io.gatling.commons.validation.Validation;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.CompositeByteArrayBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.PebbleBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.RawFileBody$;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.session.package$;
import io.gatling.core.session.package$RichExpression$;
import io.gatling.core.util.Resource;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class BodyProcessors$ {
    public static BodyProcessors$ MODULE$;

    static {
        new BodyProcessors$();
    }

    public Function1<Body, ByteArrayBody> gzip(GatlingConfiguration configuration) {
        return (Function1 & Serializable & scala.Serializable)body -> {
            RawFileBody rawFileBody;
            Some<Function1<Session, Validation<ResourceAndCachedBytes>>> some;
            Function1 function1;
            Body body2 = body;
            if (body2 instanceof StringBody) {
                StringBody stringBody = (StringBody)body2;
                Function1<Session, Validation<String>> string2 = stringBody.string();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(string2), (Function1 & Serializable & scala.Serializable)string -> GzipHelper$.MODULE$.gzip(string));
            } else if (body2 instanceof PebbleBody) {
                PebbleBody pebbleBody = (PebbleBody)body2;
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(pebbleBody), (Function1 & Serializable & scala.Serializable)string -> GzipHelper$.MODULE$.gzip(string));
            } else if (body2 instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
                Function1<Session, Validation<byte[]>> byteArray = byteArrayBody.bytes();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(byteArray), (Function1 & Serializable & scala.Serializable)bytes -> GzipHelper$.MODULE$.gzip(bytes));
            } else if (body2 instanceof RawFileBody && !(some = RawFileBody$.MODULE$.unapply(rawFileBody = (RawFileBody)body2)).isEmpty()) {
                Function1 resourceAndCachedBytes = (Function1)some.get();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(resourceAndCachedBytes), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    byte[] byArray;
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                    if (resourceAndCachedBytes == null) throw new MatchError((Object)resourceAndCachedBytes);
                    Resource resource = resourceAndCachedBytes.resource();
                    Option<byte[]> cachedBytes = resourceAndCachedBytes.cachedBytes();
                    Option<byte[]> option = cachedBytes;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] bytes = (byte[])some.value();
                        byArray = GzipHelper$.MODULE$.gzip(bytes);
                        return byArray;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        byArray = GzipHelper$.MODULE$.gzip((InputStream)new FileInputStream(resource.file()));
                    }
                    return byArray;
                });
            } else if (body2 instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body2;
                Function1<Session, Validation<InputStream>> inputStream = inputStreamBody.is();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(inputStream), (Function1 & Serializable & scala.Serializable)in -> GzipHelper$.MODULE$.gzip(in));
            } else if (body2 instanceof CompositeByteArrayBody) {
                CompositeByteArrayBody compositeByteArrayBody = (CompositeByteArrayBody)body2;
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(compositeByteArrayBody.asStream()), (Function1 & Serializable & scala.Serializable)in -> GzipHelper$.MODULE$.gzip(in));
            } else {
                throw new MatchError((Object)body2);
            }
            Function1 gzippedBytes = function1;
            return new ByteArrayBody(gzippedBytes);
        };
    }

    public Function1<Body, InputStreamBody> stream(GatlingConfiguration configuration) {
        return (Function1 & Serializable & scala.Serializable)body -> {
            RawFileBody rawFileBody;
            Some<Function1<Session, Validation<ResourceAndCachedBytes>>> some;
            Object object;
            Body body2 = body;
            if (body2 instanceof StringBody) {
                StringBody stringBody = (StringBody)body2;
                object = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(stringBody.asBytes().bytes()), (Function1 & Serializable & scala.Serializable)x$1 -> new FastByteArrayInputStream(x$1));
            } else if (body2 instanceof PebbleBody) {
                PebbleBody pebbleBody = (PebbleBody)body2;
                object = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(pebbleBody), (Function1 & Serializable & scala.Serializable)string -> new FastByteArrayInputStream(string.getBytes(configuration.core().charset())));
            } else if (body2 instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
                Function1<Session, Validation<byte[]>> byteArray = byteArrayBody.bytes();
                object = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(byteArray), (Function1 & Serializable & scala.Serializable)x$2 -> new FastByteArrayInputStream(x$2));
            } else if (body2 instanceof RawFileBody && !(some = RawFileBody$.MODULE$.unapply(rawFileBody = (RawFileBody)body2)).isEmpty()) {
                Function1 resourceAndCachedBytes = (Function1)some.get();
                object = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(resourceAndCachedBytes), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                    FileInputStream fileInputStream;
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$2;
                    if (resourceAndCachedBytes == null) throw new MatchError((Object)resourceAndCachedBytes);
                    Resource resource = resourceAndCachedBytes.resource();
                    Option<byte[]> cachedBytes = resourceAndCachedBytes.cachedBytes();
                    Option<byte[]> option = cachedBytes;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] bytes = (byte[])some.value();
                        fileInputStream = new FastByteArrayInputStream(bytes);
                        return fileInputStream;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        fileInputStream = new FileInputStream(resource.file());
                    }
                    return fileInputStream;
                });
            } else if (body2 instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body2;
                Function1<Session, Validation<InputStream>> inputStream = inputStreamBody.is();
                object = inputStream;
            } else if (body2 instanceof CompositeByteArrayBody) {
                CompositeByteArrayBody compositeByteArrayBody = (CompositeByteArrayBody)body2;
                object = compositeByteArrayBody.asStream();
            } else {
                throw new MatchError((Object)body2);
            }
            Function1 stream2 = object;
            return new InputStreamBody(stream2);
        };
    }

    private BodyProcessors$() {
        MODULE$ = this;
    }
}

