/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.End$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleData$;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserCounters;
import io.gatling.core.stats.writer.UserMessage;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u00015\u0011\u0011cQ8og>dW\rR1uC^\u0013\u0018\u000e^3s\u0015\t\u0019A!\u0001\u0004xe&$XM\u001d\u0006\u0003\u000b\u0019\tQa\u001d;biNT!a\u0002\u0005\u0002\t\r|'/\u001a\u0006\u0003\u0013)\tqaZ1uY&twMC\u0001\f\u0003\tIwn\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0011%5\t!!\u0003\u0002\u0012\u0005\tQA)\u0019;b/JLG/\u001a:\u0011\u0005=\u0019\u0012B\u0001\u000b\u0003\u0005-\u0019uN\\:pY\u0016$\u0015\r^1\t\u0011Y\u0001!\u0011!Q\u0001\n]\tQa\u00197pG.\u0004\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u00039!\tqaY8n[>t7/\u0003\u0002\u001f3\t)1\t\\8dW\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011%A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003E\u0015j\u0011a\t\u0006\u0003I\u0019\taaY8oM&<\u0017B\u0001\u0014$\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"2AK\u0016-!\ty\u0001\u0001C\u0003\u0017O\u0001\u0007q\u0003C\u0003!O\u0001\u0007\u0011\u0005C\u0004/\u0001\t\u0007I\u0011B\u0018\u0002\u001d\u0019dWo\u001d5US6,'OT1nKV\t\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005!A.\u00198h\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\rM#(/\u001b8h\u0011\u0019I\u0004\u0001)A\u0005a\u0005ya\r\\;tQRKW.\u001a:OC6,\u0007\u0005C\u0003<\u0001\u0011\u0005A(\u0001\u0004p]&s\u0017\u000e\u001e\u000b\u0003%uBQA\u0010\u001eA\u0002}\nA!\u001b8jiB\u0011q\u0002Q\u0005\u0003\u0003\n\u0011A!\u00138ji\")1\t\u0001C!\t\u00069qN\u001c$mkNDGCA#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0011)f.\u001b;\t\u000b1\u0013\u0005\u0019\u0001\n\u0002\t\u0011\fG/\u0019\u0005\u0006\u001d\u0002!\teT\u0001\n_:lUm]:bO\u0016$2!\u0012)V\u0011\u0015\tV\n1\u0001S\u0003\u001diWm]:bO\u0016\u0004\"aD*\n\u0005Q\u0013!\u0001\u0005'pC\u0012,e/\u001a8u\u001b\u0016\u001c8/Y4f\u0011\u0015aU\n1\u0001\u0013\u0011\u00159\u0006\u0001\"\u0003Y\u00035yg.V:fe6+7o]1hKR\u0019Q)\u00170\t\u000bi3\u0006\u0019A.\u0002\tU\u001cXM\u001d\t\u0003\u001fqK!!\u0018\u0002\u0003\u0017U\u001bXM]'fgN\fw-\u001a\u0005\u0006\u0019Z\u0003\rA\u0005\u0005\u0006A\u0002!I!Y\u0001\u0012_:\u0014Vm\u001d9p]N,W*Z:tC\u001e,GcA#cO\")1m\u0018a\u0001I\u0006A!/Z:q_:\u001cX\r\u0005\u0002\u0010K&\u0011aM\u0001\u0002\u0010%\u0016\u001c\bo\u001c8tK6+7o]1hK\")Aj\u0018a\u0001%!)\u0011\u000e\u0001C\u0005U\u0006qqN\\#se>\u0014X*Z:tC\u001e,GcA#la\")A\u000e\u001ba\u0001[\u0006)QM\u001d:peB\u0011qB\\\u0005\u0003_\n\u0011A\"\u0012:s_JlUm]:bO\u0016DQ\u0001\u00145A\u0002IAQA\u001d\u0001\u0005BM\fqa\u001c8De\u0006\u001c\b\u000e\u0006\u0003Fi\u0006\u0005\u0001\"B;r\u0001\u00041\u0018!B2bkN,\u0007CA<\u007f\u001d\tAH\u0010\u0005\u0002z\u000f6\t!P\u0003\u0002|\u0019\u00051AH]8pizJ!!`$\u0002\rA\u0013X\rZ3g\u0013\t9tP\u0003\u0002~\u000f\")A*\u001da\u0001%!9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011AB8o'R|\u0007\u000fF\u0002F\u0003\u0013Aa\u0001TA\u0002\u0001\u0004\u0011\u0002")
public class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConsoleData onInit(Init init) {
        void var2_2;
        ConsoleData data = new ConsoleData(this.clock.nowMillis(), ConsoleData$.MODULE$.$lessinit$greater$default$2(), ConsoleData$.MODULE$.$lessinit$greater$default$3(), ConsoleData$.MODULE$.$lessinit$greater$default$4(), ConsoleData$.MODULE$.$lessinit$greater$default$5(), ConsoleData$.MODULE$.$lessinit$greater$default$6());
        init.scenarios().foreach((Function1 & Serializable & scala.Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().console().writePeriod(), true);
        return var2_2;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, ConsoleSummary$.MODULE$.apply$default$7());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(LoadEventMessage message, ConsoleData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            this.onErrorMessage(errorMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onUserMessage(UserMessage user, ConsoleData data) {
        MessageEvent messageEvent = user.event();
        if (Start$.MODULE$.equals(messageEvent)) {
            Option option = data.usersCounters().get((Object)user.session().scenario());
            if (option instanceof Some) {
                Some some = (Some)option;
                UserCounters userCounters = (UserCounters)some.value();
                userCounters.userStart();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.session().scenario()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (End$.MODULE$.equals(messageEvent)) {
            Option option = data.usersCounters().get((Object)user.session().scenario());
            if (option instanceof Some) {
                Some some = (Some)option;
                UserCounters userCounters = (UserCounters)some.value();
                userCounters.userDone();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.session().scenario()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)messageEvent);
        }
    }

    private void onResponseMessage(ResponseMessage response, ConsoleData data) {
        String requestPath = ((TraversableOnce)response.groupHierarchy().$colon$plus((Object)response.name(), List$.MODULE$.canBuildFrom())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable & scala.Serializable)() -> new RequestCounters(RequestCounters$.MODULE$.$lessinit$greater$default$1(), RequestCounters$.MODULE$.$lessinit$greater$default$2()));
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable & scala.Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status);
        }
    }

    private void onErrorMessage(ErrorMessage error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        block0: {
            this.cancelTimer(this.flushTimerName());
            if (data.complete()) break block0;
            this.onFlush(data);
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

