/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.DataWriterType;
import io.gatling.core.stats.writer.DataWriterType$Console$;
import io.gatling.core.stats.writer.DataWriterType$File$;
import io.gatling.core.stats.writer.DataWriterType$Graphite$;
import io.gatling.core.stats.writer.RunMessage;
import io.gatling.core.stats.writer.ShortScenarioDescription;
import io.gatling.core.structure.PopulationBuilder;
import io.gatling.core.structure.PopulationBuilder$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class DataWritersStatsEngine$ {
    public static final DataWritersStatsEngine$ MODULE$ = new DataWritersStatsEngine$();

    public DataWritersStatsEngine apply(SimulationParams simulationParams, RunMessage runMessage, ActorSystem system, Clock clock, Option<Path> resultsDirectory, GatlingConfiguration configuration) {
        Seq dataWriters = (Seq)configuration.data().dataWriters().map((Function1 & Serializable)x0$1 -> {
            DataWriterType dataWriterType = x0$1;
            if (DataWriterType$Console$.MODULE$.equals(dataWriterType)) {
                return DataWritersStatsEngine$.dataWriterActor$1("io.gatling.core.stats.writer.ConsoleDataWriter", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clock, configuration}), system);
            }
            if (DataWriterType$File$.MODULE$.equals(dataWriterType)) {
                return DataWritersStatsEngine$.dataWriterActor$1("io.gatling.core.stats.writer.LogFileDataWriter", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{resultsDirectory.getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalArgumentException("Can't use the file DataWriter without setting the results directory");
                }), configuration}), system);
            }
            if (DataWriterType$Graphite$.MODULE$.equals(dataWriterType)) {
                return DataWritersStatsEngine$.dataWriterActor$1("io.gatling.graphite.GraphiteDataWriter", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clock, configuration}), system);
            }
            throw new MatchError((Object)dataWriterType);
        });
        List<PopulationBuilder> allPopulationBuilders = PopulationBuilder$.MODULE$.flatten(simulationParams.rootPopulationBuilders());
        DataWriterMessage.Init dataWriterInitMessage = new DataWriterMessage.Init(simulationParams.assertions(), runMessage, (Seq<ShortScenarioDescription>)allPopulationBuilders.map((Function1 & Serializable)pb -> new ShortScenarioDescription(pb.scenarioBuilder().name(), pb.injectionProfile().totalUserCount())));
        return new DataWritersStatsEngine(dataWriterInitMessage, (Seq<ActorRef>)dataWriters, system, clock);
    }

    private static final ActorRef dataWriterActor$1(String className, Seq args, ActorSystem system$1) {
        Class<?> clazz = Class.forName(className);
        return system$1.actorOf(Props$.MODULE$.apply(clazz, args), className);
    }

    private DataWritersStatsEngine$() {
    }
}

