/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.BufferedFileChannelWriter;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.ErrorMessageSerializer;
import io.gatling.core.stats.writer.FileData;
import io.gatling.core.stats.writer.GroupMessageSerializer;
import io.gatling.core.stats.writer.LogFileDataWriter$;
import io.gatling.core.stats.writer.ResponseMessageSerializer;
import io.gatling.core.stats.writer.RunMessageSerializer;
import io.gatling.core.stats.writer.StringInternals;
import io.gatling.core.stats.writer.UserMessageSerializer;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.HashMap;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dq!B\b\u0011\u0011\u0003Yb!B\u000f\u0011\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003\u0002C\u0014\u0002\u0005\u0004%\tA\u0006\u0015\t\rE\n\u0001\u0015!\u0003*\u0011\u0015\u0011\u0014\u0001\"\u00014\r\u0011i\u0002CA(\t\u0011u2!\u0011!Q\u0001\nQB\u0001B\u0016\u0004\u0003\u0002\u0003\u0006Ia\u0016\u0005\u0006K\u0019!\t!\u0018\u0005\u0006C\u001a!\tE\u0019\u0005\u0006Y\u001a!\t%\u001c\u0005\u0006g\u001a!\t\u0005\u001e\u0005\u0006w\u001a!\t\u0005 \u0005\b\u0003\u00031A\u0011IA\u0002\u0003Eaun\u001a$jY\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003#I\taa\u001e:ji\u0016\u0014(BA\n\u0015\u0003\u0015\u0019H/\u0019;t\u0015\t)b#\u0001\u0003d_J,'BA\f\u0019\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!G\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002\u001d\u00035\t\u0001CA\tM_\u001e4\u0015\u000e\\3ECR\fwK]5uKJ\u001c\"!A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1$A\u0006M_\u001e4\u0015\u000e\\3OC6,W#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t11\u000b\u001e:j]\u001e\fA\u0002T8h\r&dWMT1nK\u0002\nq\u0001\\8h\r&dW\r\u0006\u00035yyR\u0005CA\u001b;\u001b\u00051$BA\u001c9\u0003\u00111\u0017\u000e\\3\u000b\u0005ej\u0013a\u00018j_&\u00111H\u000e\u0002\u0005!\u0006$\b\u000eC\u0003>\u000b\u0001\u0007A'\u0001\tsKN,H\u000e^:ESJ,7\r^8ss\")q(\u0002a\u0001\u0001\u0006)!/\u001e8JIB\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"aQ\u0011\u000e\u0003\u0011S!!\u0012\u000e\u0002\rq\u0012xn\u001c;?\u0013\t9\u0015%\u0001\u0004Qe\u0016$WMZ\u0005\u0003a%S!aR\u0011\t\u000b-+\u0001\u0019\u0001'\u0002\r\r\u0014X-\u0019;f!\t\u0001S*\u0003\u0002OC\t9!i\\8mK\u0006t7C\u0001\u0004Q!\ra\u0012kU\u0005\u0003%B\u0011!\u0002R1uC^\u0013\u0018\u000e^3s!\taB+\u0003\u0002V!\tAa)\u001b7f\t\u0006$\u0018-A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u00031nk\u0011!\u0017\u0006\u00035R\taaY8oM&<\u0017B\u0001/Z\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0019al\u00181\u0011\u0005q1\u0001\"B\u001f\n\u0001\u0004!\u0004\"\u0002,\n\u0001\u00049\u0016AB8o\u0013:LG\u000f\u0006\u0002TG\")AM\u0003a\u0001K\u0006!\u0011N\\5u!\t1\u0017N\u0004\u0002\u001dO&\u0011\u0001\u000eE\u0001\u0012\t\u0006$\u0018m\u0016:ji\u0016\u0014X*Z:tC\u001e,\u0017B\u00016l\u0005\u0011Ie.\u001b;\u000b\u0005!\u0004\u0012aB8o\r2,8\u000f\u001b\u000b\u0003]F\u0004\"\u0001I8\n\u0005A\f#\u0001B+oSRDQA]\u0006A\u0002M\u000bA\u0001Z1uC\u0006IqN\\'fgN\fw-\u001a\u000b\u0004]VT\b\"\u0002<\r\u0001\u00049\u0018aB7fgN\fw-\u001a\t\u0003MbL!!_6\u0003\u00131{\u0017\rZ#wK:$\b\"\u0002:\r\u0001\u0004\u0019\u0016aB8o\u0007J\f7\u000f\u001b\u000b\u0004]v|\b\"\u0002@\u000e\u0001\u0004\u0001\u0015!B2bkN,\u0007\"\u0002:\u000e\u0001\u0004\u0019\u0016AB8o'R|\u0007\u000fF\u0002o\u0003\u000bAQA\u001d\bA\u0002M\u0003")
public final class LogFileDataWriter
extends DataWriter<FileData> {
    private final Path resultsDirectory;
    private final GatlingConfiguration configuration;

    public static Path logFile(Path resultsDirectory, String runId, boolean create) {
        return LogFileDataWriter$.MODULE$.logFile(resultsDirectory, runId, create);
    }

    @Override
    public FileData onInit(DataWriterMessage.Init init2) {
        Path simulationLog = LogFileDataWriter$.MODULE$.logFile(this.resultsDirectory, init2.runMessage().runId(), true);
        FileChannel channel = new RandomAccessFile(simulationLog.toFile(), "rw").getChannel();
        ByteBuffer bb = ByteBuffer.allocate(this.configuration.data().file().bufferSize());
        BufferedFileChannelWriter writer = new BufferedFileChannelWriter(channel, bb);
        HashMap<String, Object> scenarios = new HashMap<String, Object>();
        ((IterableOnceOps)((IterableOps)init2.scenarios().map((Function1 & Serializable)x$4 -> x$4.name())).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)LogFileDataWriter.$anonfun$onInit$2(scenarios, x0$1)));
        new RunMessageSerializer(writer).serialize(new Tuple3((Object)init2.runMessage(), init2.assertions(), scenarios));
        return new FileData(new UserMessageSerializer(writer, init2.runMessage().start(), scenarios), new ResponseMessageSerializer(writer, init2.runMessage().start()), new GroupMessageSerializer(writer, init2.runMessage().start()), new ErrorMessageSerializer(writer, init2.runMessage().start()), writer);
    }

    @Override
    public void onFlush(FileData data) {
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, FileData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.User) {
            DataWriterMessage.LoadEvent.User user = (DataWriterMessage.LoadEvent.User)loadEvent;
            data.userMessageSerializer().serialize(user);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Group) {
            DataWriterMessage.LoadEvent.Group group = (DataWriterMessage.LoadEvent.Group)loadEvent;
            data.groupMessageSerializer().serialize(group);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            data.responseMessageSerializer().serialize(response);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            data.errorMessageSerializer().serialize(error);
            return;
        }
        throw new MatchError((Object)loadEvent);
    }

    @Override
    public void onCrash(String cause, FileData data) {
    }

    @Override
    public void onStop(FileData data) {
        data.writer().close();
    }

    public static final /* synthetic */ int $anonfun$onInit$2(HashMap scenarios$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String scenario = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            return BoxesRunTime.unboxToInt((Object)scenarios$1.put(scenario, BoxesRunTime.boxToInteger((int)index)));
        }
        throw new MatchError((Object)tuple2);
    }

    public LogFileDataWriter(Path resultsDirectory, GatlingConfiguration configuration) {
        this.resultsDirectory = resultsDirectory;
        this.configuration = configuration;
        super("file-data-writer");
        StringInternals.checkAvailability();
    }
}

