/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.ConfigHelper;
import io.gatling.commons.util.ConfigHelper$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.SystemProps$;
import io.gatling.core.config.ConfigKeys$charting$;
import io.gatling.core.config.ConfigKeys$charting$indicators$;
import io.gatling.core.config.ConfigKeys$core$;
import io.gatling.core.config.ConfigKeys$core$extract$css$;
import io.gatling.core.config.ConfigKeys$core$extract$jsonPath$;
import io.gatling.core.config.ConfigKeys$core$extract$regex$;
import io.gatling.core.config.ConfigKeys$core$extract$xpath$;
import io.gatling.core.config.ConfigKeys$data$;
import io.gatling.core.config.ConfigKeys$data$console$;
import io.gatling.core.config.ConfigKeys$data$file$;
import io.gatling.core.config.ConfigKeys$data$leak$;
import io.gatling.core.config.ConfigKeys$http$;
import io.gatling.core.config.ConfigKeys$http$dns$;
import io.gatling.core.config.ConfigKeys$jms$;
import io.gatling.core.config.ConfigKeys$netty$;
import io.gatling.core.config.ConfigKeys$socket$;
import io.gatling.core.config.ConfigKeys$ssl$;
import io.gatling.core.config.ConfigKeys$ssl$keyStore$;
import io.gatling.core.config.ConfigKeys$ssl$trustStore$;
import io.gatling.core.config.ConsoleDataWriterConfiguration;
import io.gatling.core.config.CoreConfiguration;
import io.gatling.core.config.CssConfiguration;
import io.gatling.core.config.DataConfiguration;
import io.gatling.core.config.DnsConfiguration;
import io.gatling.core.config.ExtractConfiguration;
import io.gatling.core.config.FileDataWriterConfiguration;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.core.config.IndicatorsConfiguration;
import io.gatling.core.config.JmsConfiguration;
import io.gatling.core.config.JsonPathConfiguration;
import io.gatling.core.config.LeakDataWriterConfiguration;
import io.gatling.core.config.NettyConfiguration;
import io.gatling.core.config.RegexConfiguration;
import io.gatling.core.config.ReportsConfiguration;
import io.gatling.core.config.SocketConfiguration;
import io.gatling.core.config.SslConfiguration;
import io.gatling.core.config.XPathConfiguration;
import io.gatling.core.stats.writer.DataWriterType;
import io.gatling.core.stats.writer.DataWriterType$;
import io.gatling.shared.util.Ssl$;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZoneOffset;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GatlingConfiguration$
implements StrictLogging {
    public static final GatlingConfiguration$ MODULE$ = new GatlingConfiguration$();
    private static final String GatlingDefaultsConfigFile;
    private static final String GatlingCustomConfigFile;
    private static final String GatlingCustomConfigFileOverrideSystemProperty;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        GatlingDefaultsConfigFile = "gatling-defaults.conf";
        GatlingCustomConfigFile = "gatling.conf";
        GatlingCustomConfigFileOverrideSystemProperty = "gatling.conf.file";
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private String GatlingDefaultsConfigFile() {
        return GatlingDefaultsConfigFile;
    }

    private String GatlingCustomConfigFile() {
        return GatlingCustomConfigFile;
    }

    private String GatlingCustomConfigFileOverrideSystemProperty() {
        return GatlingCustomConfigFileOverrideSystemProperty;
    }

    public GatlingConfiguration loadForTest(Seq<Tuple2<String, ?>> props) {
        Config defaultsConfig = ConfigFactory.parseResources((ClassLoader)this.getClass().getClassLoader(), (String)this.GatlingDefaultsConfigFile());
        Config propertiesConfig = ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)props.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
        Config config = ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, defaultsConfig}));
        return this.mapToGatlingConfig(config);
    }

    public GatlingConfiguration load() {
        BoxedUnit boxedUnit;
        String customConfigFile = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)this.GatlingCustomConfigFileOverrideSystemProperty(), (Function0 & Serializable)() -> MODULE$.GatlingCustomConfigFile());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Gatling will try to load '{}' config file as ClassLoader resource.", (Object)customConfigFile);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Config defaultsConfig = ConfigFactory.parseResources((ClassLoader)this.getClass().getClassLoader(), (String)this.GatlingDefaultsConfigFile());
        Config customConfig = ConfigFactory.parseResources((ClassLoader)this.getClass().getClassLoader(), (String)customConfigFile);
        Config config = ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{customConfig, defaultsConfig}));
        return this.mapToGatlingConfig(config);
    }

    private CoreConfiguration coreConfiguration(Config config) {
        String x$1 = config.getString(ConfigKeys$core$.MODULE$.Encoding());
        long x$2 = config.getLong(ConfigKeys$core$.MODULE$.ElFileBodiesCacheMaxCapacity());
        long x$3 = config.getLong(ConfigKeys$core$.MODULE$.RawFileBodiesCacheMaxCapacity());
        long x$4 = config.getLong(ConfigKeys$core$.MODULE$.RawFileBodiesInMemoryMaxSize());
        long x$5 = config.getLong(ConfigKeys$core$.MODULE$.PebbleFileBodiesCacheMaxCapacity());
        long x$6 = config.getLong(ConfigKeys$core$.MODULE$.FeederAdaptiveLoadModeThreshold()) * 0x100000L;
        long x$7 = config.getLong(ConfigKeys$core$.MODULE$.ShutdownTimeout());
        ExtractConfiguration x$8 = new ExtractConfiguration(new RegexConfiguration(config.getLong(ConfigKeys$core$extract$regex$.MODULE$.CacheMaxCapacity())), new XPathConfiguration(config.getLong(ConfigKeys$core$extract$xpath$.MODULE$.CacheMaxCapacity())), new JsonPathConfiguration(config.getLong(ConfigKeys$core$extract$jsonPath$.MODULE$.CacheMaxCapacity())), new CssConfiguration(config.getLong(ConfigKeys$core$extract$css$.MODULE$.CacheMaxCapacity())));
        return new CoreConfiguration(x$1, x$8, x$2, x$3, x$4, x$5, x$6, x$7);
    }

    private SocketConfiguration socketConfiguration(Config config) {
        return new SocketConfiguration(new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$socket$.MODULE$.ConnectTimeout()))).millis(), config.getBoolean(ConfigKeys$socket$.MODULE$.TcpNoDelay()), config.getBoolean(ConfigKeys$socket$.MODULE$.SoKeepAlive()));
    }

    private List<String> defaultEnabledProtocols(boolean useOpenSsl) {
        List list;
        if (useOpenSsl) {
            return new .colon.colon((Object)"TLSv1.3", (List)new .colon.colon((Object)"TLSv1.2", (List)new .colon.colon((Object)"TLSv1.1", (List)new .colon.colon((Object)"TLSv1", (List)Nil$.MODULE$))));
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, null, null);
            list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])ctx.getDefaultSSLParameters().getProtocols()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GatlingConfiguration$.$anonfun$defaultEnabledProtocols$1(x$1)))).toList();
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the default SSL context", e);
        }
        return list;
    }

    private SslConfiguration sslConfiguration(Config config) {
        boolean bl;
        block3: {
            block0: {
                block2: {
                    block1: {
                        if (!config.getBoolean(ConfigKeys$ssl$.MODULE$.UseOpenSsl())) break block0;
                        if (!OpenSsl.isAvailable()) break block1;
                        if (true) break block2;
                        break block0;
                    }
                    throw new UnsupportedOperationException("BoringSSL is enabled in your configuration, yet it's not available for your platform " + PlatformDependent.normalizedOs() + "_" + PlatformDependent.normalizedArch() + ".", OpenSsl.unavailabilityCause());
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        boolean useOpenSsl = bl;
        List<String> list = CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$ssl$.MODULE$.EnabledProtocols())).asScala().toList();
        List<String> enabledProtocols = Nil$.MODULE$.equals(list) ? this.defaultEnabledProtocols(useOpenSsl) : list;
        Option storeType = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$keyStore$.MODULE$.Type());
        Option storeFile = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$keyStore$.MODULE$.File());
        Option storePassword = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$keyStore$.MODULE$.Password());
        Option storeAlgorithm = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$keyStore$.MODULE$.Algorithm());
        Option storeType2 = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$trustStore$.MODULE$.Type());
        Option storeFile2 = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$trustStore$.MODULE$.File());
        Option storePassword2 = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$trustStore$.MODULE$.Password());
        Option storeAlgorithm2 = ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$ssl$trustStore$.MODULE$.Algorithm());
        return new SslConfiguration(useOpenSsl, config.getBoolean(ConfigKeys$ssl$.MODULE$.UseOpenSslFinalizers()), new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$ssl$.MODULE$.HandshakeTimeout()))).millis(), config.getBoolean(ConfigKeys$ssl$.MODULE$.UseInsecureTrustManager()), enabledProtocols, (List<String>)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$ssl$.MODULE$.EnabledCipherSuites())).asScala().toList(), config.getInt(ConfigKeys$ssl$.MODULE$.SessionCacheSize()), new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$ssl$.MODULE$.SessionTimeout()))).seconds(), config.getBoolean(ConfigKeys$ssl$.MODULE$.EnableSni()), (Option<KeyManagerFactory>)storeFile.map((Function1 & Serializable)x$2 -> Ssl$.MODULE$.newKeyManagerFactory(storeType, x$2, (String)storePassword.getOrElse((Function0 & Serializable)() -> ""), storeAlgorithm)), (Option<TrustManagerFactory>)storeFile2.map((Function1 & Serializable)x$3 -> Ssl$.MODULE$.newTrustManagerFactory(storeType2, x$3, (String)storePassword2.getOrElse((Function0 & Serializable)() -> ""), storeAlgorithm2)));
    }

    private NettyConfiguration nettyConfiguration(Config config) {
        ConfigHelper.PimpedConfig$.MODULE$.getStringOption$extension(ConfigHelper$.MODULE$.PimpedConfig(config), ConfigKeys$netty$.MODULE$.Allocator()).foreach((Function1 & Serializable)x$4 -> {
            SystemProps$.MODULE$.setSystemPropertyIfUndefined("io.netty.allocator.type", (Object)x$4);
            return BoxedUnit.UNIT;
        });
        SystemProps$.MODULE$.setSystemPropertyIfUndefined("io.netty.maxThreadLocalCharBufferSize", (Object)config.getString(ConfigKeys$netty$.MODULE$.MaxThreadLocalCharBufferSize()));
        return new NettyConfiguration(config.getBoolean(ConfigKeys$netty$.MODULE$.UseNativeTransport()), config.getBoolean(ConfigKeys$netty$.MODULE$.UseIoUring()));
    }

    private ReportsConfiguration chartingConfiguration(Config config) {
        return new ReportsConfiguration(config.getInt(ConfigKeys$charting$.MODULE$.MaxPlotPerSeries()), config.getBoolean(ConfigKeys$charting$.MODULE$.UseGroupDurationMetric()), new IndicatorsConfiguration(config.getInt(ConfigKeys$charting$indicators$.MODULE$.LowerBound()), config.getInt(ConfigKeys$charting$indicators$.MODULE$.HigherBound()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile1()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile2()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile3()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile4())));
    }

    private HttpConfiguration httpConfiguration(Config config) {
        Object object;
        long x$1 = config.getLong(ConfigKeys$http$.MODULE$.FetchedCssCacheMaxCapacity());
        long x$2 = config.getLong(ConfigKeys$http$.MODULE$.FetchedHtmlCacheMaxCapacity());
        int x$3 = config.getInt(ConfigKeys$http$.MODULE$.PerUserCacheMaxCapacity());
        Option x$4 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$http$.MODULE$.WarmUpUrl())));
        FiniteDuration x$5 = new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$http$.MODULE$.RequestTimeout()))).millis();
        FiniteDuration x$6 = new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$http$.MODULE$.PooledConnectionIdleTimeout()))).millis();
        boolean enable = config.getBoolean(ConfigKeys$http$.MODULE$.EnableHostnameVerification());
        if (!enable) {
            System.setProperty("jdk.tls.allowUnsafeServerCertChange", "true");
            object = System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        } else {
            object = BoxedUnit.UNIT;
        }
        boolean x$7 = enable;
        DnsConfiguration x$8 = new DnsConfiguration(new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$http$dns$.MODULE$.QueryTimeout()))).millis(), config.getInt(ConfigKeys$http$dns$.MODULE$.MaxQueriesPerResolve()));
        return new HttpConfiguration(x$1, x$2, x$3, (Option<String>)x$4, x$6, x$5, x$7, x$8);
    }

    private JmsConfiguration jmsConfiguration(Config config) {
        return new JmsConfiguration(new package.DurationLong(package$.MODULE$.DurationLong(config.getLong(ConfigKeys$jms$.MODULE$.ReplyTimeoutScanPeriod()))).millis());
    }

    private DataConfiguration dataConfiguration(Config config) {
        ZoneId x$1 = config.getBoolean(ConfigKeys$data$.MODULE$.UtcDateTime()) ? ZoneOffset.UTC : ZoneId.systemDefault();
        Seq x$2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$data$.MODULE$.Writers())).asScala().flatMap((Function1 & Serializable)x$5 -> DataWriterType$.MODULE$.findByName((String)x$5).toList())).toSeq();
        boolean bl = config.getBoolean(ConfigKeys$data$console$.MODULE$.Light());
        int value = config.getInt(ConfigKeys$data$console$.MODULE$.WritePeriod());
        Predef$.MODULE$.require(value > 0, (Function0 & Serializable)() -> ConfigKeys$data$console$.MODULE$.WritePeriod() + " must be > 0");
        ConsoleDataWriterConfiguration x$3 = new ConsoleDataWriterConfiguration(bl, new package.DurationInt(package$.MODULE$.DurationInt(value)).seconds());
        FileDataWriterConfiguration x$4 = new FileDataWriterConfiguration(config.getInt(ConfigKeys$data$file$.MODULE$.BufferSize()));
        LeakDataWriterConfiguration x$52 = new LeakDataWriterConfiguration(new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$data$leak$.MODULE$.NoActivityTimeout()))).seconds());
        boolean x$6 = config.getBoolean(ConfigKeys$data$.MODULE$.EnableAnalytics());
        return new DataConfiguration(x$1, (Seq<DataWriterType>)x$2, x$4, x$52, x$3, x$6);
    }

    private GatlingConfiguration mapToGatlingConfig(Config config) {
        CoreConfiguration x$1 = this.coreConfiguration(config);
        SocketConfiguration x$2 = this.socketConfiguration(config);
        SslConfiguration x$3 = this.sslConfiguration(config);
        NettyConfiguration x$4 = this.nettyConfiguration(config);
        ReportsConfiguration x$5 = this.chartingConfiguration(config);
        HttpConfiguration x$6 = this.httpConfiguration(config);
        JmsConfiguration x$7 = this.jmsConfiguration(config);
        DataConfiguration x$8 = this.dataConfiguration(config);
        return new GatlingConfiguration(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8);
    }

    public static final /* synthetic */ boolean $anonfun$defaultEnabledProtocols$1(String x$1) {
        String string = x$1;
        String string2 = "SSLv3";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private GatlingConfiguration$() {
    }
}

