/*
 * Copyright 2011-2020 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.core.check.time

import io.gatling.commons.validation._
import io.gatling.core.check.{ DefaultFindCheckBuilder, FindCheckBuilder, FindExtractor }
import io.gatling.core.session._
import io.gatling.core.stats.message.ResponseTimings

trait ResponseTimeCheckType

object ResponseTimeCheckBuilder {

  val ResponseTimeInMillis: FindCheckBuilder[ResponseTimeCheckType, ResponseTimings, Int] =
    new DefaultFindCheckBuilder[ResponseTimeCheckType, ResponseTimings, Int](
      extractor = new FindExtractor[ResponseTimings, Int]("responseTimeInMillis", prepared => Some(prepared.responseTime).success).expressionSuccess,
      displayActualValue = false
    )
}
