/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.ErrorStats;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.ConsoleErrorsWriter$;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.UserCounters;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ConsoleSummary$ {
    public static ConsoleSummary$ MODULE$;
    private final String Iso8601Format;
    private final SimpleDateFormat Iso8601DateTimeFormat;
    private final int OutputLength;
    private final String NewBlock;

    static {
        new ConsoleSummary$();
    }

    private String Iso8601Format() {
        return this.Iso8601Format;
    }

    private SimpleDateFormat Iso8601DateTimeFormat() {
        return this.Iso8601DateTimeFormat;
    }

    public int OutputLength() {
        return this.OutputLength;
    }

    public String NewBlock() {
        return this.NewBlock;
    }

    public StringBuilder writeSubTitle(StringBuilder sb, String title) {
        return sb.append(StringHelper.RichString$.MODULE$.rightPad$extension1(StringHelper$.MODULE$.RichString(new StringBuilder(6).append("---- ").append(title).append(" ").toString()), this.OutputLength(), "-"));
    }

    public ConsoleSummary apply(long runDuration, Map<String, UserCounters> usersCounters, RequestCounters globalRequestCounters, Map<String, RequestCounters> requestsCounters, Map<String, Object> errorsCounters, GatlingConfiguration configuration, Date time) {
        StringBuilder sb = new StringBuilder().append(StringHelper$.MODULE$.Eol()).append(this.NewBlock()).append(StringHelper$.MODULE$.Eol()).append(this.Iso8601DateTimeFormat().format(time)).append(' ').append(StringHelper.RichString$.MODULE$.leftPad$extension0(StringHelper$.MODULE$.RichString(new StringBuilder(9).append(((Object)BoxesRunTime.boxToLong((long)runDuration)).toString()).append("s elapsed").toString()), this.OutputLength() - this.Iso8601Format().length() - 9)).append(StringHelper$.MODULE$.Eol());
        this.writeSubTitle(sb, "Requests").append(StringHelper$.MODULE$.Eol());
        this.writeRequestsCounter$1(sb, "Global", globalRequestCounters).append(StringHelper$.MODULE$.Eol());
        this.writeDetailedRequestsCounter$1(sb, configuration, requestsCounters).append(StringHelper$.MODULE$.Eol());
        this.writeErrors$1(sb, errorsCounters).append(StringHelper$.MODULE$.Eol());
        usersCounters.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String scenarioName = (String)tuple2._1();
            UserCounters usersStats = (UserCounters)tuple2._2();
            StringBuilder stringBuilder = this.writeUsersCounters$1(sb, scenarioName, usersStats).append(StringHelper$.MODULE$.Eol());
            return stringBuilder;
        });
        sb.append(this.NewBlock()).append(StringHelper$.MODULE$.Eol());
        String text = sb.toString();
        long totalWaiting = BoxesRunTime.unboxToLong((Object)Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(usersCounters.values()), (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.waitingCount()), (Numeric)Numeric.LongIsIntegral$.MODULE$));
        long totalRunning = BoxesRunTime.unboxToLong((Object)Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(usersCounters.values()), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.activeCount()), (Numeric)Numeric.LongIsIntegral$.MODULE$));
        boolean complete = totalWaiting == 0L && totalRunning == 0L;
        return new ConsoleSummary(text, complete);
    }

    private final StringBuilder writeUsersCounters$1(StringBuilder sb, String scenarioName, UserCounters userCounters) {
        StringBuilder stringBuilder;
        Some some;
        long tot;
        Option<Object> option = userCounters.totalUserCount();
        if (option instanceof Some && (tot = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= userCounters.doneCount() + userCounters.activeCount()) {
            int width = this.OutputLength() - 6;
            int donePercent = (int)package$.MODULE$.floor((double)100 * (double)userCounters.doneCount() / (double)tot);
            int done = (int)package$.MODULE$.floor((double)width * (double)userCounters.doneCount() / (double)tot);
            int active = (int)package$.MODULE$.ceil((double)width * (double)userCounters.activeCount() / (double)tot);
            int waiting = width - done - active;
            stringBuilder = this.writeSubTitle(sb, scenarioName).append(StringHelper$.MODULE$.Eol()).append('[').append(new StringOps(Predef$.MODULE$.augmentString("#")).$times(done)).append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(active)).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(waiting)).append(']').append(StringHelper.RichString$.MODULE$.leftPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToInteger((int)donePercent)).toString()), 3)).append('%').append(StringHelper$.MODULE$.Eol()).append("          waiting: ").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToLong((long)userCounters.waitingCount())).toString()), 6)).append(" / active: ").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToLong((long)userCounters.activeCount())).toString()), 6)).append(" / done: ").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToLong((long)userCounters.doneCount())).toString()), 6));
        } else {
            stringBuilder = this.writeSubTitle(sb, scenarioName).append(StringHelper$.MODULE$.Eol()).append("          active: ").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToLong((long)userCounters.activeCount())).toString()), 6)).append(" / done: ").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToLong((long)userCounters.doneCount())).toString()), 6));
        }
        return stringBuilder;
    }

    private final StringBuilder writeRequestsCounter$1(StringBuilder sb, String actionName, RequestCounters requestCounters) {
        int maxActionNameLength = this.OutputLength() - 24;
        return sb.append("> ").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(StringHelper.RichString$.MODULE$.truncate$extension(StringHelper$.MODULE$.RichString(actionName), maxActionNameLength - 3)), maxActionNameLength)).append(" (OK=").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToInteger((int)requestCounters.successfulCount())).toString()), 6)).append(" KO=").append(StringHelper.RichString$.MODULE$.rightPad$extension0(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToInteger((int)requestCounters.failedCount())).toString()), 6)).append(')');
    }

    private final StringBuilder writeDetailedRequestsCounter$1(StringBuilder sb, GatlingConfiguration configuration$1, Map requestsCounters$1) {
        block1: {
            if (configuration$1.data().console().light()) break block1;
            requestsCounters$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String actionName = (String)tuple2._1();
                RequestCounters requestCounters = (RequestCounters)tuple2._2();
                StringBuilder stringBuilder = this.writeRequestsCounter$1(sb, actionName, requestCounters).append(StringHelper$.MODULE$.Eol());
                return stringBuilder;
            });
            if (requestsCounters$1.nonEmpty()) {
                sb.setLength(sb.length() - StringHelper$.MODULE$.Eol().length());
            }
        }
        return sb;
    }

    public static final /* synthetic */ int $anonfun$apply$2(Tuple2 x$1) {
        return -x$1._2$mcI$sp();
    }

    private final StringBuilder writeErrors$1(StringBuilder sb, Map errorsCounters$1) {
        block0: {
            if (!errorsCounters$1.nonEmpty()) break block0;
            int errorsTotal = BoxesRunTime.unboxToInt((Object)errorsCounters$1.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.writeSubTitle(sb, "Errors").append(StringHelper$.MODULE$.Eol());
            ((IterableLike)errorsCounters$1.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ConsoleSummary$.$anonfun$apply$2(x$1)), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String message = (String)tuple2._1();
                int count = tuple2._2$mcI$sp();
                StringBuilder stringBuilder = ConsoleErrorsWriter$.MODULE$.writeError(sb, new ErrorStats(message, count, errorsTotal)).append(StringHelper$.MODULE$.Eol());
                return stringBuilder;
            });
        }
        return sb;
    }

    private ConsoleSummary$() {
        MODULE$ = this;
        this.Iso8601Format = "yyyy-MM-dd HH:mm:ss";
        this.Iso8601DateTimeFormat = new SimpleDateFormat(this.Iso8601Format());
        this.OutputLength = 80;
        this.NewBlock = new StringOps(Predef$.MODULE$.augmentString("=")).$times(this.OutputLength());
    }
}

