/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.shared.unstable.util.Ssl$;
import io.gatling.commons.util.ConfigHelper$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.ConfigKeys$charting$;
import io.gatling.core.ConfigKeys$charting$indicators$;
import io.gatling.core.ConfigKeys$core$;
import io.gatling.core.ConfigKeys$core$directory$;
import io.gatling.core.ConfigKeys$core$extract$css$;
import io.gatling.core.ConfigKeys$core$extract$jsonPath$;
import io.gatling.core.ConfigKeys$core$extract$regex$;
import io.gatling.core.ConfigKeys$core$extract$xpath$;
import io.gatling.core.ConfigKeys$data$;
import io.gatling.core.ConfigKeys$data$console$;
import io.gatling.core.ConfigKeys$data$file$;
import io.gatling.core.ConfigKeys$data$graphite$;
import io.gatling.core.ConfigKeys$data$leak$;
import io.gatling.core.ConfigKeys$http$;
import io.gatling.core.ConfigKeys$http$dns$;
import io.gatling.core.ConfigKeys$jms$;
import io.gatling.core.ConfigKeys$netty$;
import io.gatling.core.ConfigKeys$socket$;
import io.gatling.core.ConfigKeys$ssl$;
import io.gatling.core.ConfigKeys$ssl$keyStore$;
import io.gatling.core.ConfigKeys$ssl$trustStore$;
import io.gatling.core.config.ChartingConfiguration;
import io.gatling.core.config.ConsoleDataWriterConfiguration;
import io.gatling.core.config.CoreConfiguration;
import io.gatling.core.config.CssConfiguration;
import io.gatling.core.config.DataConfiguration;
import io.gatling.core.config.DirectoryConfiguration;
import io.gatling.core.config.DnsConfiguration;
import io.gatling.core.config.ExtractConfiguration;
import io.gatling.core.config.FileDataWriterConfiguration;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GraphiteDataWriterConfiguration;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.core.config.IndicatorsConfiguration;
import io.gatling.core.config.JmsConfiguration;
import io.gatling.core.config.JsonPathConfiguration;
import io.gatling.core.config.LeakDataWriterConfiguration;
import io.gatling.core.config.NettyConfiguration;
import io.gatling.core.config.ObsoleteUsage;
import io.gatling.core.config.RegexConfiguration;
import io.gatling.core.config.Removed;
import io.gatling.core.config.Renamed;
import io.gatling.core.config.RenamedAwareConfig$;
import io.gatling.core.config.SocketConfiguration;
import io.gatling.core.config.SslConfiguration;
import io.gatling.core.config.TransportProtocol$;
import io.gatling.core.config.XPathConfiguration;
import io.gatling.core.stats.writer.DataWriterType;
import io.gatling.core.stats.writer.DataWriterType$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GatlingConfiguration$
implements StrictLogging {
    public static final GatlingConfiguration$ MODULE$ = new GatlingConfiguration$();
    private static final String GatlingDefaultsConfigFile;
    private static final String GatlingCustomConfigFile;
    private static final String GatlingCustomConfigFileOverrideSystemProperty;
    private static final String ActorSystemDefaultsConfigFile;
    private static final String ActorSystemConfigFile;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        GatlingDefaultsConfigFile = "gatling-defaults.conf";
        GatlingCustomConfigFile = "gatling.conf";
        GatlingCustomConfigFileOverrideSystemProperty = "gatling.conf.file";
        ActorSystemDefaultsConfigFile = "gatling-akka-defaults.conf";
        ActorSystemConfigFile = "gatling-akka.conf";
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private String GatlingDefaultsConfigFile() {
        return GatlingDefaultsConfigFile;
    }

    private String GatlingCustomConfigFile() {
        return GatlingCustomConfigFile;
    }

    private String GatlingCustomConfigFileOverrideSystemProperty() {
        return GatlingCustomConfigFileOverrideSystemProperty;
    }

    private String ActorSystemDefaultsConfigFile() {
        return ActorSystemDefaultsConfigFile;
    }

    private String ActorSystemConfigFile() {
        return ActorSystemConfigFile;
    }

    public Config loadActorSystemConfiguration() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Config defaultsConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)this.ActorSystemDefaultsConfigFile());
        Config customConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)this.ActorSystemConfigFile());
        return ConfigHelper$.MODULE$.configChain(customConfig, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{defaultsConfig}));
    }

    public GatlingConfiguration loadForTest() {
        return this.loadForTest((scala.collection.mutable.Map)Map$.MODULE$.empty());
    }

    public GatlingConfiguration loadForTest(scala.collection.mutable.Map<String, ?> props) {
        Config defaultsConfig = ConfigFactory.parseResources((ClassLoader)this.getClass().getClassLoader(), (String)this.GatlingDefaultsConfigFile());
        Config propertiesConfig = ConfigFactory.parseMap((Map)CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava());
        Config config = ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, defaultsConfig}));
        return this.mapToGatlingConfig(config);
    }

    public GatlingConfiguration load(scala.collection.mutable.Map<String, ?> props) {
        BoxedUnit boxedUnit;
        String customConfigFile = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)this.GatlingCustomConfigFileOverrideSystemProperty(), (Function0 & Serializable)() -> MODULE$.GatlingCustomConfigFile());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Gatling will try to load '{}' config file as ClassLoader resource.", (Object)customConfigFile);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Config defaultsConfig = ConfigFactory.parseResources((String)this.GatlingDefaultsConfigFile());
        Config customConfig = ConfigFactory.parseResources((String)customConfigFile);
        Config propertiesConfig = ConfigFactory.parseMap((Map)CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava());
        Config config = ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{customConfig, propertiesConfig, defaultsConfig}));
        Seq removedProperties = GatlingConfiguration$.loadObsoleteUsagesFromBundle$1("config-removed", (Function2 & Serializable)(path, advice) -> new Removed((String)path, (String)advice));
        Seq renamedProperties = GatlingConfiguration$.loadObsoleteUsagesFromBundle$1("config-renamed", (Function2 & Serializable)(path, replacement) -> new Renamed((String)path, (String)replacement));
        this.warnAboutRemovedProperties$1(config, removedProperties, renamedProperties);
        return this.mapToGatlingConfig(RenamedAwareConfig$.MODULE$.apply(config, (Seq<Renamed>)renamedProperties));
    }

    private CoreConfiguration coreConfiguration(Config config) {
        String x$12 = ResourceBundle.getBundle("gatling-version").getString("version");
        Option x$22 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.OutputDirectoryBaseName())));
        Option x$3 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.RunDescription())));
        String x$4 = config.getString(ConfigKeys$core$.MODULE$.Encoding());
        Option x$5 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.SimulationClass())));
        long x$6 = config.getLong(ConfigKeys$core$.MODULE$.ElFileBodiesCacheMaxCapacity());
        long x$7 = config.getLong(ConfigKeys$core$.MODULE$.RawFileBodiesCacheMaxCapacity());
        long x$8 = config.getLong(ConfigKeys$core$.MODULE$.RawFileBodiesInMemoryMaxSize());
        long x$9 = config.getLong(ConfigKeys$core$.MODULE$.PebbleFileBodiesCacheMaxCapacity());
        long x$10 = config.getLong(ConfigKeys$core$.MODULE$.FeederAdaptiveLoadModeThreshold()) * 0x100000L;
        long x$11 = config.getLong(ConfigKeys$core$.MODULE$.ShutdownTimeout());
        ExtractConfiguration x$122 = new ExtractConfiguration(new RegexConfiguration(config.getLong(ConfigKeys$core$extract$regex$.MODULE$.CacheMaxCapacity())), new XPathConfiguration(config.getLong(ConfigKeys$core$extract$xpath$.MODULE$.CacheMaxCapacity())), new JsonPathConfiguration(config.getLong(ConfigKeys$core$extract$jsonPath$.MODULE$.CacheMaxCapacity())), new CssConfiguration(config.getLong(ConfigKeys$core$extract$css$.MODULE$.CacheMaxCapacity())));
        DirectoryConfiguration x$13 = new DirectoryConfiguration((Option<Path>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$directory$.MODULE$.Resources()))).map((Function1 & Serializable)x$1 -> Paths.get(x$1, new String[0])), (Option<Path>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$directory$.MODULE$.Binaries()))).map((Function1 & Serializable)x$2 -> Paths.get(x$2, new String[0])), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$directory$.MODULE$.ReportsOnly()))), Paths.get(config.getString(ConfigKeys$core$directory$.MODULE$.Results()), new String[0]));
        return new CoreConfiguration(x$12, (Option<String>)x$22, (Option<String>)x$3, x$4, (Option<String>)x$5, x$122, x$13, x$6, x$7, x$8, x$9, x$10, x$11);
    }

    private SocketConfiguration socketConfiguration(Config config) {
        return new SocketConfiguration(new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$socket$.MODULE$.ConnectTimeout()))).millis(), config.getBoolean(ConfigKeys$socket$.MODULE$.TcpNoDelay()), config.getBoolean(ConfigKeys$socket$.MODULE$.SoKeepAlive()), config.getBoolean(ConfigKeys$socket$.MODULE$.SoReuseAddress()));
    }

    private List<String> defaultEnabledProtocols(boolean useOpenSsl) {
        List list;
        if (useOpenSsl) {
            list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"}));
        } else {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, null, null);
                list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])ctx.getDefaultSSLParameters().getProtocols()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GatlingConfiguration$.$anonfun$defaultEnabledProtocols$1(x$3)))).toList();
            }
            catch (Exception e) {
                throw new Error("Failed to initialize the default SSL context", e);
            }
        }
        return list;
    }

    private SslConfiguration sslConfiguration(Config config) {
        boolean useOpenSsl = config.getBoolean(ConfigKeys$ssl$.MODULE$.UseOpenSsl());
        List<String> list = CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$ssl$.MODULE$.EnabledProtocols())).asScala().toList();
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List<String> list2 = list;
        List<String> list3 = !(nil$ != null ? !nil$.equals(list2) : list2 != null) ? this.defaultEnabledProtocols(useOpenSsl) : list;
        List<String> enabledProtocols = list3;
        Option storeType = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$ssl$keyStore$.MODULE$.Type())));
        Option storeFile = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$ssl$keyStore$.MODULE$.File())));
        String storePassword = config.getString(ConfigKeys$ssl$keyStore$.MODULE$.Password());
        Option storeAlgorithm = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$ssl$keyStore$.MODULE$.Algorithm())));
        Option storeType2 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$ssl$trustStore$.MODULE$.Type())));
        Option storeFile2 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$ssl$trustStore$.MODULE$.File())));
        String storePassword2 = config.getString(ConfigKeys$ssl$trustStore$.MODULE$.Password());
        Option storeAlgorithm2 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$ssl$trustStore$.MODULE$.Algorithm())));
        return new SslConfiguration(useOpenSsl, config.getBoolean(ConfigKeys$ssl$.MODULE$.UseOpenSslFinalizers()), new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$ssl$.MODULE$.HandshakeTimeout()))).millis(), config.getBoolean(ConfigKeys$ssl$.MODULE$.UseInsecureTrustManager()), enabledProtocols, (List<String>)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$ssl$.MODULE$.EnabledCipherSuites())).asScala().toList(), config.getInt(ConfigKeys$ssl$.MODULE$.SessionCacheSize()), new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$ssl$.MODULE$.SessionTimeout()))).seconds(), config.getBoolean(ConfigKeys$ssl$.MODULE$.EnableSni()), (Option<KeyManagerFactory>)storeFile.map((Function1 & Serializable)x$4 -> Ssl$.MODULE$.newKeyManagerFactory(storeType, x$4, storePassword, storeAlgorithm)), (Option<TrustManagerFactory>)storeFile2.map((Function1 & Serializable)x$5 -> Ssl$.MODULE$.newTrustManagerFactory(storeType2, x$5, storePassword2, storeAlgorithm2)));
    }

    private NettyConfiguration nettyConfiguration(Config config) {
        return new NettyConfiguration(config.getBoolean(ConfigKeys$netty$.MODULE$.UseNativeTransport()), config.getString(ConfigKeys$netty$.MODULE$.Allocator()), config.getInt(ConfigKeys$netty$.MODULE$.MaxThreadLocalCharBufferSize()));
    }

    private ChartingConfiguration chartingConfiguration(Config config) {
        return new ChartingConfiguration(config.getBoolean(ConfigKeys$charting$.MODULE$.NoReports()), config.getInt(ConfigKeys$charting$.MODULE$.MaxPlotPerSeries()), config.getBoolean(ConfigKeys$charting$.MODULE$.UseGroupDurationMetric()), new IndicatorsConfiguration(config.getInt(ConfigKeys$charting$indicators$.MODULE$.LowerBound()), config.getInt(ConfigKeys$charting$indicators$.MODULE$.HigherBound()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile1()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile2()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile3()), config.getDouble(ConfigKeys$charting$indicators$.MODULE$.Percentile4())));
    }

    private HttpConfiguration httpConfiguration(Config config) {
        Object object;
        long x$1 = config.getLong(ConfigKeys$http$.MODULE$.FetchedCssCacheMaxCapacity());
        long x$2 = config.getLong(ConfigKeys$http$.MODULE$.FetchedHtmlCacheMaxCapacity());
        int x$3 = config.getInt(ConfigKeys$http$.MODULE$.PerUserCacheMaxCapacity());
        Option x$4 = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$http$.MODULE$.WarmUpUrl())));
        boolean x$5 = config.getBoolean(ConfigKeys$http$.MODULE$.EnableGA());
        FiniteDuration x$6 = new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$http$.MODULE$.RequestTimeout()))).millis();
        FiniteDuration x$7 = new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$http$.MODULE$.PooledConnectionIdleTimeout()))).millis();
        boolean enable = config.getBoolean(ConfigKeys$http$.MODULE$.EnableHostnameVerification());
        if (!enable) {
            System.setProperty("jdk.tls.allowUnsafeServerCertChange", "true");
            object = System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        } else {
            object = BoxedUnit.UNIT;
        }
        boolean x$8 = enable;
        DnsConfiguration x$9 = new DnsConfiguration(new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$http$dns$.MODULE$.QueryTimeout()))).millis(), config.getInt(ConfigKeys$http$dns$.MODULE$.MaxQueriesPerResolve()));
        return new HttpConfiguration(x$1, x$2, x$3, (Option<String>)x$4, x$5, x$7, x$6, x$8, x$9);
    }

    private JmsConfiguration jmsConfiguration(Config config) {
        return new JmsConfiguration(new package.DurationLong(package$.MODULE$.DurationLong(config.getLong(ConfigKeys$jms$.MODULE$.ReplyTimeoutScanPeriod()))).millis());
    }

    private DataConfiguration dataConfiguration(Config config) {
        Seq x$1 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$data$.MODULE$.Writers())).asScala().flatMap((Function1 & Serializable)x$6 -> DataWriterType$.MODULE$.findByName((String)x$6).toList())).toSeq();
        ConsoleDataWriterConfiguration x$2 = new ConsoleDataWriterConfiguration(config.getBoolean(ConfigKeys$data$console$.MODULE$.Light()), new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$data$console$.MODULE$.WritePeriod()))).seconds());
        FileDataWriterConfiguration x$3 = new FileDataWriterConfiguration(config.getInt(ConfigKeys$data$file$.MODULE$.BufferSize()));
        LeakDataWriterConfiguration x$4 = new LeakDataWriterConfiguration(new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$data$leak$.MODULE$.NoActivityTimeout()))).seconds());
        GraphiteDataWriterConfiguration x$5 = new GraphiteDataWriterConfiguration(config.getBoolean(ConfigKeys$data$graphite$.MODULE$.Light()), config.getString(ConfigKeys$data$graphite$.MODULE$.Host()), config.getInt(ConfigKeys$data$graphite$.MODULE$.Port()), TransportProtocol$.MODULE$.apply(config.getString(ConfigKeys$data$graphite$.MODULE$.Protocol()).trim()), config.getString(ConfigKeys$data$graphite$.MODULE$.RootPathPrefix()), config.getInt(ConfigKeys$data$graphite$.MODULE$.BufferSize()), new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$data$graphite$.MODULE$.WritePeriod()))).seconds());
        return new DataConfiguration((Seq<DataWriterType>)x$1, x$3, x$4, x$2, x$5);
    }

    private GatlingConfiguration mapToGatlingConfig(Config config) {
        CoreConfiguration x$1 = this.coreConfiguration(config);
        SocketConfiguration x$2 = this.socketConfiguration(config);
        SslConfiguration x$3 = this.sslConfiguration(config);
        NettyConfiguration x$4 = this.nettyConfiguration(config);
        ChartingConfiguration x$5 = this.chartingConfiguration(config);
        HttpConfiguration x$6 = this.httpConfiguration(config);
        JmsConfiguration x$7 = this.jmsConfiguration(config);
        DataConfiguration x$8 = this.dataConfiguration(config);
        return new GatlingConfiguration(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8);
    }

    private static final Seq loadObsoleteUsagesFromBundle$1(String bundleName, Function2 creator) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(bundle.getKeys()).asScala().map((Function1 & Serializable)key -> (ObsoleteUsage)creator.apply(key, (Object)bundle.getString((String)key))).toVector();
    }

    private final void warnAboutRemovedProperties$1(Config config, Seq removedProperties, Seq renamedProperties) {
        block2: {
            BoxedUnit boxedUnit;
            Seq obsoleteUsages = (Seq)((IterableOps)removedProperties.$plus$plus((IterableOnce)renamedProperties)).collect((PartialFunction)new Serializable(config){
                private static final long serialVersionUID = 0L;
                private final Config config$1;

                public final <A1 extends ObsoleteUsage, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = this.config$1.hasPath(A1.path()) ? A1.message() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(ObsoleteUsage x1) {
                    ObsoleteUsage obsoleteUsage = x1;
                    boolean bl = this.config$1.hasPath(obsoleteUsage.path());
                    return bl;
                }
                {
                    this.config$1 = config$1;
                }
            });
            if (!obsoleteUsages.nonEmpty()) break block2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(270).append("|Your Gatling configuration options are outdated, some properties have been renamed or removed.\n              |Please update (check gatling.conf in Gatling bundle, or gatling-defaults.conf in gatling-core jar).\n              |Enabled obsolete properties:\n              |").append(obsoleteUsages.mkString("\n")).toString())));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$defaultEnabledProtocols$1(String x$3) {
        String string = x$3;
        String string2 = "SSLv3";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private GatlingConfiguration$() {
    }
}

