/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.util.cache;

import com.github.benmanes.caffeine.cache.LoadingCache;
import io.gatling.core.util.cache.Cache$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]r!\u0002\b\u0010\u0011\u0003Qb!\u0002\u000f\u0010\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039\u0003\"B#\u0002\t\u00031\u0005\"B0\u0002\t\u0003\u0001g\u0001\u0002\u000f\u0010\u0001\rD\u0001\"\u001a\u0004\u0003\u0002\u0003\u0006IA\u001a\u0005\ta\u001a\u0011\t\u0011)A\u0005c\"AaP\u0002B\u0001B\u0003%q\u0010\u0003\u0004%\r\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f1A\u0011AA\t\u0011\u001d\tYB\u0002C\u0001\u0003;Aq!!\t\u0007\t\u0003\t\u0019#A\u0003DC\u000eDWM\u0003\u0002\u0011#\u0005)1-Y2iK*\u0011!cE\u0001\u0005kRLGN\u0003\u0002\u0015+\u0005!1m\u001c:f\u0015\t1r#A\u0004hCRd\u0017N\\4\u000b\u0003a\t!![8\u0004\u0001A\u00111$A\u0007\u0002\u001f\t)1)Y2iKN\u0011\u0011A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0012A\u00058fo\u000e{gnY;se\u0016tGoQ1dQ\u0016,2\u0001\u000b\u001b?)\tI\u0003\t\u0005\u0003+aIjT\"A\u0016\u000b\u00051j\u0013AC2p]\u000e,(O]3oi*\u0011!C\f\u0006\u0002_\u0005!!.\u0019<b\u0013\t\t4FA\u0007D_:\u001cWO\u001d:f]Rl\u0015\r\u001d\t\u0003gQb\u0001\u0001B\u00036\u0007\t\u0007aGA\u0001L#\t9$\b\u0005\u0002 q%\u0011\u0011\b\t\u0002\b\u001d>$\b.\u001b8h!\ty2(\u0003\u0002=A\t\u0019\u0011I\\=\u0011\u0005MrD!B \u0004\u0005\u00041$!\u0001,\t\u000b\u0005\u001b\u0001\u0019\u0001\"\u0002\u000f5\f\u0007pU5{KB\u0011qdQ\u0005\u0003\t\u0002\u0012A\u0001T8oO\u0006Ib.Z<D_:\u001cWO\u001d:f]Rdu.\u00193j]\u001e\u001c\u0015m\u00195f+\r9e\u000b\u0017\u000b\u0004\u0011fS\u0006\u0003B%T+^k\u0011A\u0013\u0006\u0003!-S!\u0001T'\u0002\u0011\r\fgMZ3j]\u0016T!AT(\u0002\u0011\t,g.\\1oKNT!\u0001U)\u0002\r\u001dLG\u000f[;c\u0015\u0005\u0011\u0016aA2p[&\u0011AK\u0013\u0002\r\u0019>\fG-\u001b8h\u0007\u0006\u001c\u0007.\u001a\t\u0003gY#Q!\u000e\u0003C\u0002Y\u0002\"a\r-\u0005\u000b}\"!\u0019\u0001\u001c\t\u000b\u0005#\u0001\u0019\u0001\"\t\u000bm#\u0001\u0019\u0001/\u0002\u0003\u0019\u0004BaH/V/&\u0011a\f\t\u0002\n\rVt7\r^5p]F\n\u0011C\\3x\u00136lW\u000f^1cY\u0016\u001c\u0015m\u00195f+\u0015\t\u0017qFA\u001a)\r\u0011\u0017Q\u0007\t\u00077\u0019\ti#!\r\u0016\u0007\u0011|Wp\u0005\u0002\u0007=\u0005)\u0011/^3vKB\u0019q\r\u001c8\u000e\u0003!T!!\u001b6\u0002\u0013%lW.\u001e;bE2,'BA6!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003[\"\u0014Q!U;fk\u0016\u0004\"aM8\u0005\u000bU2!\u0019\u0001\u001c\u0002\u00075\f\u0007\u000f\u0005\u0003ss:dhBA:x!\t!\b%D\u0001v\u0015\t1\u0018$\u0001\u0004=e>|GOP\u0005\u0003q\u0002\na\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\ri\u0015\r\u001d\u0006\u0003q\u0002\u0002\"aM?\u0005\u000b}2!\u0019\u0001\u001c\u0002\u00175\f\u0007pQ1qC\u000eLG/\u001f\t\u0004?\u0005\u0005\u0011bAA\u0002A\t\u0019\u0011J\u001c;\u0015\u0011\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\u0001Ba\u0007\u0004oy\")QM\u0003a\u0001M\")\u0001O\u0003a\u0001c\")aP\u0003a\u0001\u007f\u0006\u0019\u0001/\u001e;\u0015\r\u0005\u001d\u00111CA\f\u0011\u0019\t)b\u0003a\u0001]\u0006\u00191.Z=\t\r\u0005e1\u00021\u0001}\u0003\u00151\u0018\r\\;f\u0003\u0019\u0011X-\\8wKR!\u0011qAA\u0010\u0011\u0019\t)\u0002\u0004a\u0001]\u0006\u0019q-\u001a;\u0015\t\u0005\u0015\u00121\u0006\t\u0005?\u0005\u001dB0C\u0002\u0002*\u0001\u0012aa\u00149uS>t\u0007BBA\u000b\u001b\u0001\u0007a\u000eE\u00024\u0003_!Q!N\u0003C\u0002Y\u00022aMA\u001a\t\u0015yTA1\u00017\u0011\u0015qX\u00011\u0001\u0000\u0001")
public class Cache<K, V> {
    private final Queue<K> queue;
    private final Map<K, V> map;
    private final int maxCapacity;

    public static <K, V> Cache<K, V> newImmutableCache(int maxCapacity) {
        return Cache$.MODULE$.newImmutableCache(maxCapacity);
    }

    public static <K, V> LoadingCache<K, V> newConcurrentLoadingCache(long maxSize, Function1<K, V> f) {
        return Cache$.MODULE$.newConcurrentLoadingCache(maxSize, f);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentCache(long maxSize) {
        return Cache$.MODULE$.newConcurrentCache(maxSize);
    }

    public Cache<K, V> put(K key, V value) {
        Cache cache;
        if (this.map.get(key).contains(value) || this.maxCapacity == 0) {
            cache = this;
        } else if (IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(this.map.sizeIs(), this.maxCapacity)) {
            Tuple2 tuple2 = this.queue.dequeue();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object removedKey = tuple2._1();
            Queue newQueue = (Queue)tuple2._2();
            Tuple2 tuple22 = new Tuple2(removedKey, (Object)newQueue);
            Tuple2 tuple23 = tuple22;
            Object removedKey2 = tuple23._1();
            Queue newQueue2 = (Queue)tuple23._2();
            Map newMap = (Map)this.map.$minus(removedKey2).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value));
            cache = new Cache<K, V>(newQueue2.enqueue(key), newMap, this.maxCapacity);
        } else {
            Queue newQueue = this.queue.enqueue(key);
            Map newMap = (Map)this.map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value));
            cache = new Cache<K, V>(newQueue, newMap, this.maxCapacity);
        }
        return cache;
    }

    public Cache<K, V> remove(K key) {
        Cache cache;
        if (this.map.contains(key)) {
            Queue newQueue = (Queue)this.queue.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Cache.$anonfun$remove$1(key, x$2)));
            Map newMap = (Map)this.map.$minus(key);
            cache = new Cache<K, V>(newQueue, newMap, this.maxCapacity);
        } else {
            cache = this;
        }
        return cache;
    }

    public Option<V> get(K key) {
        return this.map.get(key);
    }

    public static final /* synthetic */ boolean $anonfun$remove$1(Object key$1, Object x$2) {
        return !BoxesRunTime.equals((Object)x$2, (Object)key$1);
    }

    public Cache(Queue<K> queue, Map<K, V> map, int maxCapacity) {
        this.queue = queue;
        this.map = map;
        this.maxCapacity = maxCapacity;
    }
}

