/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.controller.inject;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.stats.StatsEngine;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd!\u0002\u000f\u001e\u0003\u0013A\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011}\u0002!\u0011!Q\u0001\n\u0001C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005-\")A\f\u0001C\u0001;\"9A\r\u0001a\u0001\n\u0013)\u0007bB5\u0001\u0001\u0004%IA\u001b\u0005\u0007a\u0002\u0001\u000b\u0015\u00024\t\u000fE\u0004\u0001\u0019!C\u0005K\"9!\u000f\u0001a\u0001\n\u0013\u0019\bBB;\u0001A\u0003&a\rC\u0004w\u0001\u0001\u0007I\u0011B<\t\u000fm\u0004\u0001\u0019!C\u0005y\"1a\u0010\u0001Q!\naDaa \u0001\u0005\n\u0005\u0005\u0001bBA\u0002\u0001\u0011E\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001A\u0011CA\u0001\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!a\b\u0001\t#\t\t\u0003\u0003\u0004\u00026\u0001!\t\"\u001a\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\t\t\u0006\u0001D\u0001\u0003'Bq!!\u0017\u0001\r\u0003\t\t\u0001\u0003\u0004\u0002\\\u0001!\ta\u001e\u0005\u0007\u0003;\u0002A\u0011A<\t\u000f\u00055\u0002A\"\u0001\u0002`!1\u0011\u0011\r\u0001\u0007\u0002]\u0014\u0001bV8sW2|\u0017\r\u001a\u0006\u0003=}\ta!\u001b8kK\u000e$(B\u0001\u0011\"\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0003E\r\nAaY8sK*\u0011A%J\u0001\bO\u0006$H.\u001b8h\u0015\u00051\u0013AA5p\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003iU\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002m\u0005\u00191m\\7\n\u0005a\n$!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0005tG\u0016t\u0017M]5p!\tYT(D\u0001=\u0015\tI\u0014%\u0003\u0002?y\tA1kY3oCJLw.A\u0005vg\u0016\u0014\u0018\nZ$f]B\u0011\u0011IS\u0007\u0002\u0005*\u00111\tR\u0001\u0007CR|W.[2\u000b\u0005\u00153\u0015AC2p]\u000e,(O]3oi*\u0011q\tS\u0001\u0005kRLGNC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-\u0013%AC!u_6L7\rT8oO\u0006qQM^3oi2{w\u000e]$s_V\u0004\bC\u0001(T\u001b\u0005y%B\u0001)R\u0003\u001d\u0019\u0007.\u00198oK2T!AU\u0013\u0002\u000b9,G\u000f^=\n\u0005Q{%AD#wK:$Hj\\8q\u000fJ|W\u000f]\u0001\fgR\fGo]#oO&tW\r\u0005\u0002X56\t\u0001L\u0003\u0002ZC\u0005)1\u000f^1ug&\u00111\f\u0017\u0002\f'R\fGo]#oO&tW-\u0001\u0004=S:LGO\u0010\u000b\u0006=\u0002\f'm\u0019\t\u0003?\u0002i\u0011!\b\u0005\u0006s\u0015\u0001\rA\u000f\u0005\u0006\u007f\u0015\u0001\r\u0001\u0011\u0005\u0006\u0019\u0016\u0001\r!\u0014\u0005\u0006+\u0016\u0001\rAV\u0001\ng\u000eDW\rZ;mK\u0012,\u0012A\u001a\t\u0003U\u001dL!\u0001[\u0016\u0003\u0007%sG/A\u0007tG\",G-\u001e7fI~#S-\u001d\u000b\u0003W:\u0004\"A\u000b7\n\u00055\\#\u0001B+oSRDqa\\\u0004\u0002\u0002\u0003\u0007a-A\u0002yIE\n!b]2iK\u0012,H.\u001a3!\u0003\u001d\u0019Ho\u001c9qK\u0012\f1b\u001d;paB,Gm\u0018\u0013fcR\u00111\u000e\u001e\u0005\b_*\t\t\u00111\u0001g\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0013\u0001D1mYN\u001b\u0007.\u001a3vY\u0016$W#\u0001=\u0011\u0005)J\u0018B\u0001>,\u0005\u001d\u0011un\u001c7fC:\f\u0001#\u00197m'\u000eDW\rZ;mK\u0012|F%Z9\u0015\u0005-l\bbB8\u000e\u0003\u0003\u0005\r\u0001_\u0001\u000eC2d7k\u00195fIVdW\r\u001a\u0011\u0002/%t7M]3nK:$8k\u00195fIVdW\rZ+tKJ\u001cH#A6\u0002\u001fM,G/\u00117m'\u000eDW\rZ;mK\u0012\fQ#\u001b8de\u0016lWM\u001c;Ti>\u0004\b/\u001a3Vg\u0016\u00148/A\u0005ti\u0006\u0014H/V:feR)1.a\u0003\u0002\u0016!9\u0011Q\u0002\nA\u0002\u0005=\u0011AB;tKJLE\rE\u0002+\u0003#I1!a\u0005,\u0005\u0011auN\\4\t\u000f\u0005]!\u00031\u0001\u0002\u001a\u0005IQM^3oi2{w\u000e\u001d\t\u0004\u001d\u0006m\u0011bAA\u000f\u001f\nIQI^3oi2{w\u000e]\u0001\u000bS:TWm\u0019;Vg\u0016\u0014HcA6\u0002$!9\u0011QE\nA\u0002\u0005\u001d\u0012!\u00023fY\u0006L\b\u0003BA\u0015\u0003ci!!a\u000b\u000b\t\u00055\u0012qF\u0001\tIV\u0014\u0018\r^5p]*\u0011QiK\u0005\u0005\u0003g\tYC\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002%\u001d,GoQ8oGV\u0014(/\u001a8u+N,'o]\u0001\rg\u000e,g.\u0019:j_:\u000bW.Z\u000b\u0003\u0003w\u0001B!!\u0010\u0002L9!\u0011qHA$!\r\t\teK\u0007\u0003\u0003\u0007R1!!\u0012(\u0003\u0019a$o\\8u}%\u0019\u0011\u0011J\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\ti%a\u0014\u0003\rM#(/\u001b8h\u0015\r\tIeK\u0001\fS:TWm\u0019;CCR\u001c\u0007\u000eF\u0002l\u0003+Bq!a\u0016\u0017\u0001\u0004\t9#A\u0006cCR\u001c\u0007nV5oI><\u0018aB3oIV\u001bXM]\u0001\u0014SN\fE\u000e\\+tKJ\u001c8k\u00195fIVdW\rZ\u0001\u0012SN\fE\u000e\\+tKJ\u001c8\u000b^8qa\u0016$WCAA\u0014\u0003\u001dI7/R7qif\u0004")
public abstract class Workload
implements StrictLogging {
    private final Scenario scenario;
    private final AtomicLong userIdGen;
    private final EventLoopGroup eventLoopGroup;
    private final StatsEngine statsEngine;
    private int scheduled;
    private int stopped;
    private boolean allScheduled;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(int x$1) {
        this.scheduled = x$1;
    }

    private int stopped() {
        return this.stopped;
    }

    private void stopped_$eq(int x$1) {
        this.stopped = x$1;
    }

    private boolean allScheduled() {
        return this.allScheduled;
    }

    private void allScheduled_$eq(boolean x$1) {
        this.allScheduled = x$1;
    }

    private void incrementScheduledUsers() {
        this.scheduled_$eq(this.scheduled() + 1);
    }

    public void setAllScheduled() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Scenario {} has finished injecting", (Object)this.scenario);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.allScheduled_$eq(true);
    }

    public void incrementStoppedUsers() {
        this.stopped_$eq(this.stopped() + 1);
    }

    private void startUser(long userId, EventLoop eventLoop) {
        BoxedUnit boxedUnit;
        Session rawSession = Session$.MODULE$.apply(this.scenario.name(), userId, this.scenario.onExit(), eventLoop);
        Session session = (Session)this.scenario.onStart().apply((Object)rawSession);
        this.scenario.entry().$bang(session);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Start user #{}", (Object)BoxesRunTime.boxToLong((long)session.userId()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.statsEngine.logUserStart(this.scenario.name());
    }

    public void injectUser(FiniteDuration delay) {
        this.incrementScheduledUsers();
        long userId = this.userIdGen.incrementAndGet();
        EventLoop eventLoop = this.eventLoopGroup.next();
        if (!eventLoop.isShutdown()) {
            if (delay.$less$eq((Object)Duration$.MODULE$.Zero())) {
                eventLoop.execute(() -> this.startUser(userId, eventLoop));
                return;
            }
            eventLoop.schedule(() -> this.startUser(userId, eventLoop), delay.toMillis(), TimeUnit.MILLISECONDS);
            return;
        }
    }

    public int getConcurrentUsers() {
        return this.scheduled() - this.stopped();
    }

    public String scenarioName() {
        return this.scenario.name();
    }

    public abstract void injectBatch(FiniteDuration var1);

    public abstract void endUser();

    public boolean isAllUsersScheduled() {
        return this.allScheduled();
    }

    public boolean isAllUsersStopped() {
        return this.allScheduled() && this.scheduled() == this.stopped();
    }

    public abstract FiniteDuration duration();

    public abstract boolean isEmpty();

    public Workload(Scenario scenario, AtomicLong userIdGen, EventLoopGroup eventLoopGroup, StatsEngine statsEngine) {
        this.scenario = scenario;
        this.userIdGen = userIdGen;
        this.eventLoopGroup = eventLoopGroup;
        this.statsEngine = statsEngine;
        StrictLogging.$init$((StrictLogging)this);
        this.scheduled = 0;
        this.stopped = 0;
        this.allScheduled = false;
        Statics.releaseFence();
    }
}

