/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.PluginConfiguration;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.HttpEnterpriseClient;
import io.gatling.plugin.domain.BatchEnterprisePluginClient;
import io.gatling.plugin.domain.InteractiveEnterprisePluginClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.model.BuildPlugin;

public class EnterprisePluginProvider {
    public static BatchEnterprisePlugin getBatchInstance(PluginConfiguration pluginConfiguration) throws EnterprisePluginException {
        BuildPlugin buildPlugin = EnterprisePluginProvider.getBuildPlugin(pluginConfiguration);
        EnterpriseClient enterpriseClient = EnterprisePluginProvider.getEnterpriseClient(pluginConfiguration, buildPlugin);
        return new BatchEnterprisePluginClient(enterpriseClient, pluginConfiguration.pluginIO.getLogger(), pluginConfiguration.webAppUrl);
    }

    public static EnterprisePlugin getInstance(PluginConfiguration pluginConfiguration) throws EnterprisePluginException {
        BuildPlugin buildPlugin = EnterprisePluginProvider.getBuildPlugin(pluginConfiguration);
        EnterpriseClient enterpriseClient = EnterprisePluginProvider.getEnterpriseClient(pluginConfiguration, buildPlugin);
        if (buildPlugin.interactive.booleanValue()) {
            return new InteractiveEnterprisePluginClient(enterpriseClient, pluginConfiguration.pluginIO, pluginConfiguration.webAppUrl);
        }
        return new BatchEnterprisePluginClient(enterpriseClient, pluginConfiguration.pluginIO.getLogger(), pluginConfiguration.webAppUrl);
    }

    private static BuildPlugin getBuildPlugin(PluginConfiguration pluginConfiguration) {
        return BuildPlugin.getInstance(pluginConfiguration.buildTool, pluginConfiguration.pluginVersion, pluginConfiguration.requireBatchMode);
    }

    private static EnterpriseClient getEnterpriseClient(PluginConfiguration pluginConfiguration, BuildPlugin buildPlugin) throws EnterprisePluginException {
        return new HttpEnterpriseClient(pluginConfiguration.apiUrl, pluginConfiguration.apiToken, pluginConfiguration.privateControlPlaneUrl, buildPlugin);
    }
}

