/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.util.checksum;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class PkgChecksum {
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    private PkgChecksum() {
    }

    public static String computeChecksum(File file) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                 ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (zipEntry.getName().equals(MANIFEST_NAME)) continue;
                    zipInputStream.closeEntry();
                    messageDigest.update(BigInteger.valueOf(zipEntry.getCrc()).toByteArray());
                }
            }
            return Base64.getEncoder().encodeToString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Checksum algorithm was not available", noSuchAlgorithmException);
        }
    }
}

