/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum BuildTool {
    JS_CLI("js-cli"),
    MAVEN("maven"),
    GRADLE("gradle"),
    SBT("sbt");

    public final String value;
    private static final Map<String, BuildTool> BUILD_TOOL_BY_VALUE;

    private BuildTool(String string2) {
        this.value = string2;
    }

    public static BuildTool get(String string) {
        return BUILD_TOOL_BY_VALUE.get(string);
    }

    static {
        HashMap<String, BuildTool> hashMap = new HashMap<String, BuildTool>();
        for (BuildTool buildTool : BuildTool.values()) {
            hashMap.put(buildTool.value, buildTool);
        }
        BUILD_TOOL_BY_VALUE = Collections.unmodifiableMap(hashMap);
    }
}

