/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.util;

import io.gatling.plugin.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    private static final String PATH_SEPARATOR = "/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unpack(File file, File file2, Function<String, Boolean> function, ConflictResolver conflictResolver) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                try {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    try {
                        ZipUtil.unpackZipEntry(inputStream, zipEntry, file2, function, conflictResolver);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    throw new IOException("Failed to process zip entry '" + zipEntry.getName(), iOException);
                    return;
                }
            }
        }
    }

    private static void unpackZipEntry(InputStream inputStream, ZipEntry zipEntry, File file, Function<String, Boolean> function, ConflictResolver conflictResolver) throws IOException {
        String string = zipEntry.getName();
        if (string.contains("..")) {
            throw new IllegalArgumentException("Malicious jar file with relative path " + string);
        }
        if (function.apply(string).booleanValue()) {
            if (!zipEntry.isDirectory()) {
                // empty if block
            }
        } else {
            File file2 = new File(file, string);
            if (zipEntry.isDirectory()) {
                IOUtil.mkdirs(file2);
            } else {
                IOUtil.mkdirs(file2.getParentFile());
                if (file2.exists() && conflictResolver != null && conflictResolver.resolve(string, file2, inputStream)) {
                    return;
                }
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));){
                    inputStream.transferTo(bufferedOutputStream);
                }
            }
        }
    }

    public static void pack(File file, File file2, Runnable runnable) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));){
            ZipUtil.packRecursive(file, zipOutputStream, "", runnable);
        }
    }

    private static void packRecursive(File file, ZipOutputStream zipOutputStream, String string, Runnable runnable) throws IOException {
        if (!file.exists()) {
            throw new IOException("Given directory '" + String.valueOf(file) + "' doesn't exist!");
        }
        if (!file.isDirectory()) {
            throw new IOException("Given file is not a directory '" + String.valueOf(file) + "'");
        }
        for (File file2 : file.listFiles()) {
            boolean bl = file2.isDirectory();
            String string2 = string + file2.getName();
            if (bl) {
                string2 = string2 + PATH_SEPARATOR;
            }
            ZipEntry zipEntry = ZipUtil.fromFile(string2, file2);
            zipOutputStream.putNextEntry(zipEntry);
            if (!bl) {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));){
                    ((InputStream)bufferedInputStream).transferTo(zipOutputStream);
                }
            }
            if (runnable != null) {
                runnable.run();
            }
            zipOutputStream.closeEntry();
            if (!bl) continue;
            ZipUtil.packRecursive(file2, zipOutputStream, string2, runnable);
        }
    }

    private static ZipEntry fromFile(String string, File file) {
        ZipEntry zipEntry = new ZipEntry(string);
        if (!file.isDirectory()) {
            zipEntry.setSize(file.length());
        }
        zipEntry.setTime(file.lastModified());
        return zipEntry;
    }

    @FunctionalInterface
    public static interface ConflictResolver {
        public boolean resolve(String var1, File var2, InputStream var3);
    }
}

