/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.PluginClient;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidSimulationClassException;
import io.gatling.plugin.exceptions.SeveralSimulationClassNamesFoundException;
import io.gatling.plugin.exceptions.SeveralTeamsFoundException;
import io.gatling.plugin.exceptions.SimulationStartException;
import io.gatling.plugin.exceptions.TeamNotFoundException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.HostByLocation;
import io.gatling.plugin.model.Location;
import io.gatling.plugin.model.Locations;
import io.gatling.plugin.model.Pkg;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationStartResult;
import io.gatling.plugin.model.Team;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class BatchEnterprisePluginClient
extends PluginClient
implements BatchEnterprisePlugin {
    public BatchEnterprisePluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger) {
        super(enterpriseClient, pluginLogger);
    }

    @Override
    public long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        this.validateJavaVersion(file);
        return this.uploadPackageWithChecksum(uUID, file);
    }

    @Override
    public long uploadPackageWithSimulationId(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(file, "simulationId");
        ObjectsUtil.nonNullParam(file, "file");
        Simulation simulation = this.enterpriseClient.getSimulation(uUID);
        return this.uploadPackage(simulation.pkgId, file);
    }

    @Override
    public UUID uploadPackageConfiguration(String string) throws EnterprisePluginException {
        return this.enterpriseClient.uploadPackageConfiguration(string);
    }

    @Override
    public SimulationStartResult uploadPackageAndStartSimulation(UUID uUID, Map<String, String> map, Map<String, String> map2, String string, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "simulationId");
        ObjectsUtil.nonNullParam(map, "systemProperties");
        ObjectsUtil.nonNullParam(map2, "environmentVariables");
        ObjectsUtil.nonNullParam(file, "file");
        Simulation simulation = this.enterpriseClient.getSimulation(uUID);
        List<String> list = this.getSimulationClasses(file);
        String string2 = this.simulationClassName(simulation, list, string);
        this.uploadPackageWithChecksum(simulation.pkgId, file);
        if (!simulation.className.equals(string2)) {
            this.logger.info(String.format("The Simulation configured in Gatling Enterprise was using the class %s. Updating to %s.", simulation.className, string2));
            this.enterpriseClient.updateSimulationClassName(simulation.id, string2);
        }
        RunSummary runSummary = this.enterpriseClient.startSimulation(uUID, map, map2);
        return new SimulationStartResult(simulation, runSummary, false);
    }

    @Override
    public SimulationStartResult createAndStartSimulation(UUID uUID, String string, String string2, String string3, UUID uUID2, Map<String, String> map, Map<String, String> map2, File file) throws EnterprisePluginException {
        ObjectsUtil.nonEmptyParam(string2, "artifactId");
        List<String> list = this.getSimulationClasses(file);
        String string4 = this.simulationClassName(null, list, string3);
        Team team = this.defaultTeam(uUID);
        Pkg pkg = uUID2 != null ? this.enterpriseClient.getPackage(uUID2) : this.createAndUploadDefaultPackage(team, string, string2, file);
        Map<String, HostByLocation> map3 = this.defaultHostByLocation();
        return this.createAndStartSimulation(team, pkg, string4, map3, map, map2);
    }

    private Team defaultTeam(UUID uUID) throws EnterprisePluginException {
        List<Team> list = this.enterpriseClient.getTeams();
        if (list.isEmpty()) {
            throw new IllegalStateException("Cannot create a simulation: no team was found and a simulation must belong to a team. In order to create a team, see https://gatling.io/docs/enterprise/cloud/reference/admin/teams/");
        }
        if (uUID == null && list.size() != 1) {
            throw new SeveralTeamsFoundException(list, "Cannot configure a team: several teams were found, you must provide a configuration for a single team.");
        }
        if (uUID != null) {
            return list.stream().filter(team -> uUID.equals(team.id)).findFirst().orElseThrow(() -> new TeamNotFoundException(uUID));
        }
        return list.get(0);
    }

    private Pkg createAndUploadDefaultPackage(Team team, String string, String string2, File file) throws EnterprisePluginException {
        String string3 = string != null ? string + ":" + string2 : string2;
        Pkg pkg = this.enterpriseClient.createPackage(string3, team.id);
        this.enterpriseClient.uploadPackage(pkg.id, file);
        return pkg;
    }

    private Map<String, HostByLocation> defaultHostByLocation() throws EnterprisePluginException {
        Locations locations = this.enterpriseClient.getLocations();
        if (locations.publicLocations.isEmpty()) {
            throw new IllegalStateException("Cannot automatically create a simulation if no pool is available");
        }
        Location location = locations.publicLocations.get(0);
        return Collections.singletonMap(location.getIdAsString(), new HostByLocation(1, 0));
    }

    private SimulationStartResult createAndStartSimulation(Team team, Pkg pkg, String string, Map<String, HostByLocation> map, Map<String, String> map2, Map<String, String> map3) throws EnterprisePluginException {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        Simulation simulation = this.enterpriseClient.createSimulation(string2, team.id, string, pkg.id, map);
        try {
            RunSummary runSummary = this.enterpriseClient.startSimulation(simulation.id, map2, map3);
            return new SimulationStartResult(simulation, runSummary, true);
        }
        catch (EnterprisePluginException enterprisePluginException) {
            throw new SimulationStartException(simulation, true, enterprisePluginException);
        }
    }

    private String simulationClassName(Simulation simulation, List<String> list, String string) throws EnterprisePluginException {
        if (string != null) {
            if (!list.contains(string)) {
                throw new InvalidSimulationClassException(list, string);
            }
            return string;
        }
        if (simulation != null && list.contains(simulation.className)) {
            return simulation.className;
        }
        if (list.size() == 1) {
            String string2 = list.get(0);
            this.logger.info("Pick only available simulation class name " + string2);
            return string2;
        }
        throw new SeveralSimulationClassNamesFoundException(list);
    }
}

