/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import io.gatling.plugin.client.http.AbstractApiRequests;
import io.gatling.plugin.client.http.ApiPath;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidApiCallException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.UUID;

class PrivatePackagesApiRequests
extends AbstractApiRequests {
    private static final ApiPath PKG_PATH = ApiPath.of("packages");
    private static final String FILENAME_HEADER = "X-gatling-filename";

    PrivatePackagesApiRequests(URL uRL, String string) {
        super(uRL, string);
    }

    long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        ApiPath apiPath = PKG_PATH.append(uUID.toString());
        this.post(apiPath, httpURLConnection -> {
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpURLConnection.setRequestProperty(FILENAME_HEADER, file.getName());
            httpURLConnection.setDoOutput(true);
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                Files.copy(file.toPath(), outputStream);
            }
            catch (IOException iOException) {
                throw new ApiCallIOException(iOException);
            }
        }, httpResponse -> {
            if (httpResponse.code == 413) {
                throw new InvalidApiCallException("Package exceeds maximum allowed size (5 GB)");
            }
            if (httpResponse.code == 404) {
                throw new PackageNotFoundException(uUID);
            }
        });
        return file.length();
    }
}

