/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gatling.plugin.model.Location;
import io.gatling.plugin.util.ObjectsUtil;
import java.util.Objects;
import java.util.UUID;

public final class PublicLocation
implements Location {
    public final UUID id;
    public final String name;

    @Override
    public String getIdAsString() {
        return this.id.toString();
    }

    @JsonCreator
    public PublicLocation(@JsonProperty(value="id", required=true) UUID uUID, @JsonProperty(value="name", required=true) String string) {
        ObjectsUtil.nonNullParam(uUID, "id");
        ObjectsUtil.nonNullParam(string, "name");
        this.id = uUID;
        this.name = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PublicLocation publicLocation = (PublicLocation)object;
        return this.id.equals(publicLocation.id) && this.name.equals(publicLocation.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        return String.format("Location{id='%s',name='%s'}", this.id, this.name);
    }
}

