/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gatling.plugin.util.ObjectsUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RequestsSummary {
    public final In in;
    public final Out out;
    public final List<Child> children;

    @JsonCreator
    public RequestsSummary(@JsonProperty(value="in", required=true) In in, @JsonProperty(value="out", required=true) Out out, @JsonProperty(value="children") List<Child> list) {
        ObjectsUtil.nonNullParam(in, "in");
        ObjectsUtil.nonNullParam(out, "out");
        this.in = in;
        this.out = out;
        this.children = list != null ? list : Collections.emptyList();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RequestsSummary requestsSummary = (RequestsSummary)object;
        return Objects.equals(this.in, requestsSummary.in) && Objects.equals(this.out, requestsSummary.out) && Objects.equals(this.children, requestsSummary.children);
    }

    public int hashCode() {
        return Objects.hash(this.in, this.out, this.children);
    }

    public String toString() {
        return String.format("RequestsSummary{in='%s',out='%s',children='%s'}", this.in, this.out, this.children);
    }

    public static final class In {
        public final KoPercent counts;
        public final Total rps;

        @JsonCreator
        public In(@JsonProperty(value="counts", required=true) KoPercent koPercent, @JsonProperty(value="rps", required=true) Total total) {
            ObjectsUtil.nonNullParam(koPercent, "counts");
            ObjectsUtil.nonNullParam(total, "rps");
            this.counts = koPercent;
            this.rps = total;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            In in = (In)object;
            return Objects.equals(this.counts, in.counts) && Objects.equals(this.rps, in.rps);
        }

        public int hashCode() {
            return Objects.hash(this.counts, this.rps);
        }

        public String toString() {
            return String.format("In{counts='%s',rps='%s'}", this.counts, this.rps);
        }
    }

    public static final class Out {
        public final Total counts;
        public final Total rps;

        @JsonCreator
        public Out(@JsonProperty(value="counts", required=true) Total total, @JsonProperty(value="rps", required=true) Total total2) {
            ObjectsUtil.nonNullParam(total, "counts");
            ObjectsUtil.nonNullParam(total2, "rps");
            this.counts = total;
            this.rps = total2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Out out = (Out)object;
            return Objects.equals(this.counts, out.counts) && Objects.equals(this.rps, out.rps);
        }

        public int hashCode() {
            return Objects.hash(this.counts, this.rps);
        }

        public String toString() {
            return String.format("Out{counts='%s',rps='%s'}", this.counts, this.rps);
        }
    }

    public static final class Total {
        public final double total;

        @JsonCreator
        public Total(@JsonProperty(value="total", required=true) double d) {
            this.total = d;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Total total = (Total)object;
            return Objects.equals(this.total, total.total);
        }

        public int hashCode() {
            return Objects.hash(this.total);
        }

        public String toString() {
            return String.format("Total{total='%s'}", this.total);
        }
    }

    public static final class KoPercent {
        public final double koPercent;

        @JsonCreator
        public KoPercent(@JsonProperty(value="koPercent", required=true) double d) {
            this.koPercent = d;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            KoPercent koPercent = (KoPercent)object;
            return Objects.equals(this.koPercent, koPercent.koPercent);
        }

        public int hashCode() {
            return Objects.hash(this.koPercent);
        }

        public String toString() {
            return String.format("KoPercent{koPercent='%s'}", this.koPercent);
        }
    }

    public static final class Child {
        public final String name;
        public final In in;
        public final Out out;
        public final Integer index;
        public final List<Child> children;

        @JsonCreator
        public Child(@JsonProperty(value="name", required=true) String string, @JsonProperty(value="in", required=true) In in, @JsonProperty(value="out", required=true) Out out, @JsonProperty(value="index") Integer n, @JsonProperty(value="children") List<Child> list) {
            ObjectsUtil.nonNullParam(string, "name");
            ObjectsUtil.nonNullParam(in, "in");
            ObjectsUtil.nonNullParam(out, "out");
            this.name = string;
            this.in = in;
            this.out = out;
            this.index = n;
            this.children = list;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Child child = (Child)object;
            return Objects.equals(this.name, child.name) && Objects.equals(this.in, child.in) && Objects.equals(this.out, child.out) && Objects.equals(this.index, child.index) && Objects.equals(this.children, child.children);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.in, this.out, this.index, this.children);
        }

        public String toString() {
            return String.format("Child{name='%s',in='%s',out='%s',index='%s',children='%s'}", this.name, this.in, this.out, this.index, this.children);
        }
    }
}

