/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.ssl;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class Tls {
    private static final Pattern CERT_PATTERN = Pattern.compile("\\.");

    private Tls() {
    }

    public static Set<String> extractSubjectAlternativeNames(SSLEngine sSLEngine) throws SSLPeerUnverifiedException, CertificateParsingException {
        HashSet<String> hashSet = new HashSet<String>();
        for (Certificate certificate : sSLEngine.getSession().getPeerCertificates()) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) continue;
            for (List<?> list : collection) {
                if (list == null) continue;
                for (Object obj : list) {
                    if (!(obj instanceof String)) continue;
                    hashSet.add((String)obj);
                }
            }
        }
        return hashSet;
    }

    public static boolean isCertificateAuthoritative(String string, String string2) {
        int n;
        String string3;
        boolean bl;
        String[] stringArray;
        String[] stringArray2 = CERT_PATTERN.split(string);
        if (stringArray2.length != (stringArray = CERT_PATTERN.split(string2)).length) {
            return false;
        }
        String string4 = stringArray[0];
        String string5 = stringArray2[0];
        int n2 = string5.length();
        int n3 = string5.indexOf(42);
        if (n3 == -1) {
            bl = false;
        } else if (n3 == 0 && n2 == 1) {
            bl = true;
        } else if (n3 == 0) {
            string3 = string5.substring(n3 + 1);
            bl = string4.endsWith(string3);
        } else if (n3 == n2 - 1) {
            string3 = string5.substring(0, n3);
            bl = string4.startsWith(string3);
        } else {
            string3 = string5.substring(n3 + 1);
            String string6 = string5.substring(0, n3);
            bl = string4.endsWith(string3) && string4.startsWith(string6);
        }
        boolean bl2 = true;
        int n4 = n = bl ? 1 : 0;
        while (n < stringArray.length && bl2) {
            bl2 = stringArray2[n].equals(stringArray[n]);
            ++n;
        }
        return bl2;
    }

    public static String domain(String string) {
        int n = string.length() - 1;
        return string.charAt(n) == '.' ? string.substring(0, n) : string;
    }
}

