/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.ahc.util.HttpUtils;
import io.gatling.http.client.impl.Http2Content;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.impl.request.WritableRequestBuilder;
import io.gatling.http.client.pool.ChannelPool;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2AppHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2AppHandler.class);
    private static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Channel was closed before handshake completed");
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey propertyKey;
    private final Http2ConnectionHandler http2ConnectionHandler;
    private final ChannelPool channelPool;
    private final HttpClientConfig config;
    private int nextStreamId = 1;

    Http2AppHandler(Http2Connection http2Connection, Http2ConnectionHandler http2ConnectionHandler, ChannelPool channelPool, HttpClientConfig httpClientConfig) {
        this.connection = http2Connection;
        this.propertyKey = http2Connection.newKey();
        this.http2ConnectionHandler = http2ConnectionHandler;
        this.channelPool = channelPool;
        this.config = httpClientConfig;
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        HttpTx httpTx = (HttpTx)object;
        this.nextStreamId += 2;
        if (httpTx.requestTimeout.isDone()) {
            this.channelPool.offer(channelHandlerContext.channel());
            return;
        }
        try {
            WritableRequest writableRequest = WritableRequestBuilder.buildRequest(httpTx.request, channelHandlerContext.alloc(), this.config, true);
            httpTx.closeConnection = HttpUtils.isConnectionClose(writableRequest.getRequest().headers());
            LOGGER.debug("Write request {}", (Object)writableRequest);
            writableRequest.write(channelHandlerContext).addListener(future -> {
                if (future.isSuccess()) {
                    Http2Stream http2Stream = this.connection.stream(this.nextStreamId);
                    http2Stream.setProperty(this.propertyKey, (Object)httpTx);
                } else {
                    this.crash(channelHandlerContext, future.cause(), httpTx.listener, true);
                }
            });
        }
        catch (Exception exception) {
            this.crash(channelHandlerContext, exception, httpTx.listener, true);
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            Integer n = httpResponse.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            Http2Stream http2Stream = this.connection.stream(n.intValue());
            HttpTx httpTx = (HttpTx)http2Stream.getProperty(this.propertyKey);
            if (httpTx.requestTimeout.isDone()) {
                this.http2ConnectionHandler.resetStream(channelHandlerContext, n.intValue(), 8L, channelHandlerContext.newPromise());
                this.channelPool.offer(channelHandlerContext.channel());
                return;
            }
            httpTx.listener.onHttpResponse(httpResponse.status(), httpResponse.headers());
        } else if (object instanceof Http2Content) {
            Http2Content http2Content = (Http2Content)object;
            int n = http2Content.getStreamId();
            Http2Stream http2Stream = this.connection.stream(n);
            HttpTx httpTx = (HttpTx)http2Stream.getProperty(this.propertyKey);
            if (httpTx.requestTimeout.isDone()) {
                this.http2ConnectionHandler.resetStream(channelHandlerContext, n, 8L, channelHandlerContext.newPromise());
                this.channelPool.offer(channelHandlerContext.channel());
                return;
            }
            HttpContent httpContent = http2Content.getHttpContent();
            boolean bl = httpContent instanceof LastHttpContent;
            httpTx.listener.onHttpResponseBodyChunk(httpContent.content(), bl);
            if (bl) {
                httpTx.requestTimeout.cancel();
                this.channelPool.offer(channelHandlerContext.channel());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crash(ChannelHandlerContext channelHandlerContext, Throwable throwable, HttpListener httpListener, boolean bl) {
        try {
            if (httpListener != null) {
                httpListener.onThrowable(throwable);
            }
            this.connection.forEachActiveStream(http2Stream -> {
                HttpTx httpTx = (HttpTx)http2Stream.getProperty(this.propertyKey);
                httpTx.listener.onThrowable(throwable);
                return true;
            });
        }
        catch (Http2Exception http2Exception) {
            LOGGER.error("Can't properly close active streams");
        }
        finally {
            if (bl) {
                channelHandlerContext.close();
            }
        }
        if (throwable instanceof Error) {
            LOGGER.error("Fatal error", throwable);
            System.exit(1);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.crash(channelHandlerContext, throwable, null, true);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.crash(channelHandlerContext, REMOTELY_CLOSED_EXCEPTION, null, false);
    }
}

